-- ============================================================================
-- R_01: SEED UBIGEOS (DEPARTAMENTOS, PROVINCIAS Y DISTRITOS) 
-- ============================================================================

INSERT INTO ubigeo_departamentos (codigo_ubigeo, nombre)
VALUES
  ('01', 'Amazonas'),
  ('02', 'Ancash'),
  ('03', 'Apurimac'),
  ('04', 'Arequipa'),
  ('05', 'Ayacucho'),
  ('06', 'Cajamarca'),
  ('07', 'Callao'),
  ('08', 'Cusco'),
  ('09', 'Huancavelica'),
  ('10', 'Huanuco'),
  ('11', 'Ica'),
  ('12', 'Junin'),
  ('13', 'La Libertad'),
  
  ('14', 'Lambayeque'),
  ('15', 'Lima'),
  ('16', 'Loreto'),
  ('17', 'Madre de Dios'),
  ('18', 'Moquegua'),
  ('19', 'Pasco'),
  ('20', 'Piura'),
  ('21', 'Puno'),
  ('22', 'San Martin'),
  ('23', 'Tacna'),
  ('24', 'Tumbes'),
  ('25', 'Ucayali')
ON DUPLICATE KEY UPDATE
  nombre = VALUES(nombre);

INSERT INTO ubigeo_provincias (codigo_ubigeo, nombre, departamento_id)
VALUES
  ('0101', 'Chachapoyas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '01')),
  ('0102', 'Bagua', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '01')),
  ('0103', 'Bongara', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '01')),
  ('0104', 'Condorcanqui', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '01')),
  ('0105', 'Luya', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '01')),
  ('0106', 'Rodriguez de Mendoza', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '01')),
  ('0107', 'Utcubamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '01')),
  ('0201', 'Huaraz', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0202', 'Aija', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0203', 'Antonio Raymondi', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0204', 'Asuncion', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0205', 'Bolognesi', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0206', 'Carhuaz', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0207', 'Carlos Fermin Fitzcarrald', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0208', 'Casma', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0209', 'Corongo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0210', 'Huari', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0211', 'Huarmey', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0212', 'Huaylas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0213', 'Mariscal Luzuriaga', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0214', 'Ocros', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0215', 'Pallasca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0216', 'Pomabamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0217', 'Recuay', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0218', 'Santa', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0219', 'Sihuas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0220', 'Yungay', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '02')),
  ('0301', 'Abancay', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '03')),
  ('0302', 'Andahuaylas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '03')),
  ('0303', 'Antabamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '03')),
  ('0304', 'Aymaraes', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '03')),
  ('0305', 'Cotabambas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '03')),
  ('0306', 'Chincheros', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '03')),
  ('0307', 'Grau', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '03')),
  ('0401', 'Arequipa', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '04')),
  ('0402', 'Camana', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '04')),
  ('0403', 'Caraveli', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '04')),
  ('0404', 'Castilla', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '04')),
  ('0405', 'Caylloma', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '04')),
  ('0406', 'Condesuyos', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '04')),
  ('0407', 'Islay', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '04')),
  ('0408', 'La Union', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '04')),
  ('0501', 'Huamanga', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0502', 'Cangallo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0503', 'Huanca Sancos', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0504', 'Huanta', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0505', 'La Mar', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0506', 'Lucanas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0507', 'Parinacochas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0508', 'Paucar del Sara Sara', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0509', 'Sucre', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0510', 'Victor Fajardo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0511', 'Vilcas Huaman', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '05')),
  ('0601', 'Cajamarca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0602', 'Cajabamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0603', 'Celendin', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0604', 'Chota', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0605', 'Contumaza', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0606', 'Cutervo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0607', 'Hualgayoc', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0608', 'Jaen', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0609', 'San Ignacio', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0610', 'San Marcos', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0611', 'San Miguel', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0612', 'San Pablo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0613', 'Santa Cruz', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '06')),
  ('0701', 'Callao', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '07')),
  ('0801', 'Cusco', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0802', 'Acomayo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0803', 'Anta', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0804', 'Calca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0805', 'Canas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0806', 'Canchis', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0807', 'Chumbivilcas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0808', 'Espinar', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0809', 'La Convencion', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0810', 'Paruro', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0811', 'Paucartambo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0812', 'Quispicanchi', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0813', 'Urubamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '08')),
  ('0901', 'Huancavelica', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '09')),
  ('0902', 'Acobamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '09')),
  ('0903', 'Angaraes', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '09')),
  ('0904', 'Castrovirreyna', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '09')),
  ('0905', 'Churcampa', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '09')),
  ('0906', 'Huaytara', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '09')),
  ('0907', 'Tayacaja', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '09')),
  ('1001', 'Huanuco', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1002', 'Ambo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1003', 'Dos de Mayo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1004', 'Huacaybamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1005', 'Huamalies', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1006', 'Leoncio Prado', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1007', 'Maraqon', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1008', 'Pachitea', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1009', 'Puerto Inca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1010', 'Lauricocha', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1011', 'Yarowilca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '10')),
  ('1101', 'Ica', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '11')),
  ('1102', 'Chincha', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '11')),
  ('1103', 'Nazca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '11')),
  ('1104', 'Palpa', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '11')),
  ('1105', 'Pisco', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '11')),
  ('1201', 'Huancayo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1202', 'Concepcion', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1203', 'Chanchamayo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1204', 'Jauja', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1205', 'Junin', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1206', 'Satipo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1207', 'Tarma', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1208', 'Yauli', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1209', 'Chupaca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '12')),
  ('1301', 'Trujillo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1302', 'Ascope', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1303', 'Bolivar', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1304', 'Chepen', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1305', 'Julcan', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1306', 'Otuzco', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1307', 'Pacasmayo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1308', 'Pataz', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1309', 'Sanchez Carrion', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1310', 'Santiago de Chuco', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1311', 'Gran Chimu', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1312', 'Viru', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '13')),
  ('1401', 'Chiclayo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '14')),
  ('1402', 'Ferreqafe', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '14')),
  ('1403', 'Lambayeque', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '14')),
  ('1501', 'Lima', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1502', 'Barranca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1503', 'Cajatambo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1504', 'Canta', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1505', 'Cañete', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1506', 'Huaral', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1507', 'Huarochiri', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1508', 'Huaura', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1509', 'Oyon', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1510', 'Yauyos', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '15')),
  ('1601', 'Maynas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '16')),
  ('1602', 'Alto Amazonas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '16')),
  ('1603', 'Loreto', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '16')),
  ('1604', 'Mariscal Ramon Castilla', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '16')),
  ('1605', 'Requena', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '16')),
  ('1606', 'Ucayali', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '16')),
  ('1701', 'Tambopata', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '17')),
  ('1702', 'Manu', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '17')),
  ('1703', 'Tahuamanu', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '17')),
  ('1801', 'Mariscal Nieto', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '18')),
  ('1802', 'General Sanchez Cerro', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '18')),
  ('1803', 'Ilo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '18')),
  ('1901', 'Pasco', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '19')),
  ('1902', 'Daniel Alcides Carrion', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '19')),
  ('1903', 'Oxapampa', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '19')),
  ('2001', 'Piura', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '20')),
  ('2002', 'Ayabaca', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '20')),
  ('2003', 'Huancabamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '20')),
  ('2004', 'Morropon', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '20')),
  ('2005', 'Paita', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '20')),
  ('2006', 'Sullana', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '20')),
  ('2007', 'Talara', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '20')),
  ('2008', 'Sechura', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '20')),
  ('2101', 'Puno', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2102', 'Azangaro', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2103', 'Carabaya', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2104', 'Chucuito', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2105', 'El Collao', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2106', 'Huancane', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2107', 'Lampa', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2108', 'Melgar', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2109', 'Moho', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2110', 'San Antonio de Putina', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2111', 'San Roman', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2112', 'Sandia', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2113', 'Yunguyo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '21')),
  ('2201', 'Moyobamba', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2202', 'Bellavista', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2203', 'El Dorado', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2204', 'Huallaga', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2205', 'Lamas', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2206', 'Mariscal Caceres', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2207', 'Picota', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2208', 'Rioja', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2209', 'San Martin', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2210', 'Tocache', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '22')),
  ('2301', 'Tacna', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '23')),
  ('2302', 'Candarave', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '23')),
  ('2303', 'Jorge Basadre', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '23')),
  ('2304', 'Tarata', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '23')),
  ('2401', 'Tumbes', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '24')),
  ('2402', 'Contralmirante Villar', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '24')),
  ('2403', 'Zarumilla', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '24')),
  ('2501', 'Coronel Portillo', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '25')),
  ('2502', 'Atalaya', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '25')),
  ('2503', 'Padre Abad', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '25')),
  ('2504', 'Purus', (SELECT id FROM ubigeo_departamentos WHERE codigo_ubigeo = '25'))
ON DUPLICATE KEY UPDATE
  nombre = VALUES(nombre),
  departamento_id = VALUES(departamento_id);

INSERT INTO ubigeo_distritos (codigo_ubigeo, nombre, provincia_id)
VALUES
  ('010101', 'Chachapoyas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010102', 'Asuncion', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010103', 'Balsas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010104', 'Cheto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010105', 'Chiliquin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010106', 'Chuquibamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010107', 'Granada', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010108', 'Huancas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010109', 'La Jalca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010110', 'Leimebamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010111', 'Levanto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010112', 'Magdalena', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010113', 'Mariscal Castilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010114', 'Molinopampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010115', 'Montevideo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010116', 'Olleros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010117', 'Quinjalca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010118', 'San Francisco de Daguas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010119', 'San Isidro de Maino', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010120', 'Soloco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010121', 'Sonche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0101')),
  ('010201', 'La Peca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0102')),
  ('010202', 'Aramango', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0102')),
  ('010203', 'Copallin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0102')),
  ('010204', 'El Parco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0102')),
  ('010205', 'Imaza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0102')),
  ('010301', 'Jumbilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010302', 'Corosha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010303', 'Cuispes', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010304', 'Chisquilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010305', 'Churuja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010306', 'Florida', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010307', 'Recta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010308', 'San Carlos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010309', 'Shipasbamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010310', 'Valera', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010311', 'Yambrasbamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010312', 'Jazan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0103')),
  ('010401', 'Nieva', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0104')),
  ('010402', 'El Cenepa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0104')),
  ('010403', 'Rio Santiago', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0104')),
  ('010501', 'Lamud', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010502', 'Camporredondo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010503', 'Cocabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010504', 'Colcamar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010505', 'Conila', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010506', 'Inguilpata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010507', 'Longuita', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010508', 'Lonya Chico', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010509', 'Luya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010510', 'Luya Viejo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010511', 'Maria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010512', 'Ocalli', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010513', 'Ocumal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010514', 'Pisuquia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010515', 'Providencia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010516', 'San Cristobal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010517', 'San Francisco del Yeso', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010518', 'San Jeronimo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010519', 'San Juan de Lopecancha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010520', 'Santa Catalina', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010521', 'Santo Tomas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010522', 'Tingo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010523', 'Trita', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0105')),
  ('010601', 'San Nicolas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010602', 'Chirimoto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010603', 'Cochamal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010604', 'Huambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010605', 'Limabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010606', 'Longar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010607', 'Mariscal Benavides', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010608', 'Milpuc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010609', 'Omia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010610', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010611', 'Totora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010612', 'Vista Alegre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0106')),
  ('010701', 'Bagua Grande', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0107')),
  ('010702', 'Cajaruro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0107')),
  ('010703', 'Cumba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0107')),
  ('010704', 'El Milagro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0107')),
  ('010705', 'Jamalca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0107')),
  ('010706', 'Lonya Grande', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0107')),
  ('010707', 'Yamon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0107')),
  ('020101', 'Huaraz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020102', 'Cochabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020103', 'Colcabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020104', 'Huanchay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020105', 'Independencia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020106', 'Jangas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020107', 'La Libertad', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020108', 'Olleros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020109', 'Pampas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020110', 'Pariacoto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020111', 'Pira', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020112', 'Tarica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0201')),
  ('020201', 'Aija', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0202')),
  ('020202', 'Coris', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0202')),
  ('020203', 'Huacllan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0202')),
  ('020204', 'La Merced', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0202')),
  ('020205', 'Succha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0202')),
  ('020301', 'Llamellin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0203')),
  ('020302', 'Aczo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0203')),
  ('020303', 'Chaccho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0203')),
  ('020304', 'Chingas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0203')),
  ('020305', 'Mirgas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0203')),
  ('020306', 'San Juan de Rontoy', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0203')),
  ('020401', 'Chacas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0204')),
  ('020402', 'Acochaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0204')),
  ('020501', 'Chiquian', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020502', 'Abelardo Pardo Lezameta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020503', 'Antonio Raymondi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020504', 'Aquia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020505', 'Cajacay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020506', 'Canis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020507', 'Colquioc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020508', 'Huallanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020509', 'Huasta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020510', 'Huayllacayan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020511', 'La Primavera', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020512', 'Mangas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020513', 'Pacllon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020514', 'San Miguel de Corpanqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020515', 'Ticllos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0205')),
  ('020601', 'Carhuaz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020602', 'Acopampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020603', 'Amashca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020604', 'Anta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020605', 'Ataquero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020606', 'Marcara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020607', 'Pariahuanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020608', 'San Miguel de Aco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020609', 'Shilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020610', 'Tinco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020611', 'Yungar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0206')),
  ('020701', 'San Luis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0207')),
  ('020702', 'San Nicolas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0207')),
  ('020703', 'Yauya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0207')),
  ('020801', 'Casma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0208')),
  ('020802', 'Buena Vista Alta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0208')),
  ('020803', 'Comandante Noel', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0208')),
  ('020804', 'Yautan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0208')),
  ('020901', 'Corongo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0209')),
  ('020902', 'Aco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0209')),
  ('020903', 'Bambas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0209')),
  ('020904', 'Cusca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0209')),
  ('020905', 'La Pampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0209')),
  ('020906', 'Yanac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0209')),
  ('020907', 'Yupan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0209')),
  ('021001', 'Huari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021002', 'Anra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021003', 'Cajay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021004', 'Chavin de Huantar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021005', 'Huacachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021006', 'Huacchis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021007', 'Huachis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021008', 'Huantar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021009', 'Masin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021010', 'Paucas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021011', 'Ponto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021012', 'Rahuapampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021013', 'Rapayan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021014', 'San Marcos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021015', 'San Pedro de Chana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021016', 'Uco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0210')),
  ('021101', 'Huarmey', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0211')),
  ('021102', 'Cochapeti', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0211')),
  ('021103', 'Culebras', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0211')),
  ('021104', 'Huayan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0211')),
  ('021105', 'Malvas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0211')),
  ('021201', 'Caraz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021202', 'Huallanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021203', 'Huata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021204', 'Huaylas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021205', 'Mato', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021206', 'Pamparomas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021207', 'Pueblo Libre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021208', 'Santa Cruz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021209', 'Santo Toribio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021210', 'Yuracmarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0212')),
  ('021301', 'Piscobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0213')),
  ('021302', 'Casca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0213')),
  ('021303', 'Eleazar Guzman Barron', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0213')),
  ('021304', 'Fidel Olivas Escudero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0213')),
  ('021305', 'Llama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0213')),
  ('021306', 'Llumpa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0213')),
  ('021307', 'Lucma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0213')),
  ('021308', 'Musga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0213')),
  ('021401', 'Ocros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021402', 'Acas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021403', 'Cajamarquilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021404', 'Carhuapampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021405', 'Cochas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021406', 'Congas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021407', 'Llipa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021408', 'San Cristobal de Rajan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021409', 'San Pedro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021410', 'Santiago de Chilcas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0214')),
  ('021501', 'Cabana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021502', 'Bolognesi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021503', 'Conchucos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021504', 'Huacaschuque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021505', 'Huandoval', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021506', 'Lacabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021507', 'Llapo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021508', 'Pallasca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021509', 'Pampas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021510', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021511', 'Tauca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0215')),
  ('021601', 'Pomabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0216')),
  ('021602', 'Huayllan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0216')),
  ('021603', 'Parobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0216')),
  ('021604', 'Quinuabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0216')),
  ('021701', 'Recuay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021702', 'Catac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021703', 'Cotaparaco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021704', 'Huayllapampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021705', 'Llacllin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021706', 'Marca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021707', 'Pampas Chico', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021708', 'Pararin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021709', 'Tapacocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021710', 'Ticapampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0217')),
  ('021801', 'Chimbote', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021802', 'Caceres del Peru', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021803', 'Coishco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021804', 'Macate', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021805', 'Moro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021806', 'Nepeqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021807', 'Samanco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021808', 'Santa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021809', 'Nuevo Chimbote', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0218')),
  ('021901', 'Sihuas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021902', 'Acobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021903', 'Alfonso Ugarte', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021904', 'Cashapampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021905', 'Chingalpo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021906', 'Huayllabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021907', 'Quiches', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021908', 'Ragash', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021909', 'San Juan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('021910', 'Sicsibamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0219')),
  ('022001', 'Yungay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0220')),
  ('022002', 'Cascapara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0220')),
  ('022003', 'Mancos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0220')),
  ('022004', 'Matacoto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0220')),
  ('022005', 'Quillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0220')),
  ('022006', 'Ranrahirca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0220')),
  ('022007', 'Shupluy', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0220')),
  ('022008', 'Yanama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0220')),
  ('030101', 'Abancay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030102', 'Chacoche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030103', 'Circa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030104', 'Curahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030105', 'Huanipaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030106', 'Lambrama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030107', 'Pichirhua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030108', 'San Pedro de Cachora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030109', 'Tamburco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0301')),
  ('030201', 'Andahuaylas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030202', 'Andarapa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030203', 'Chiara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030204', 'Huancarama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030205', 'Huancaray', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030206', 'Huayana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030207', 'Kishuara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030208', 'Pacobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030209', 'Pacucha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030210', 'Pampachiri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030211', 'Pomacocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030212', 'San Antonio de Cachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030213', 'San Jeronimo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030214', 'San Miguel de Chaccrampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030215', 'Santa Maria de Chicmo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030216', 'Talavera', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030217', 'Tumay Huaraca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030218', 'Turpo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030219', 'Kaquiabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0302')),
  ('030301', 'Antabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0303')),
  ('030302', 'El Oro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0303')),
  ('030303', 'Huaquirca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0303')),
  ('030304', 'Juan Espinoza Medrano', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0303')),
  ('030305', 'Oropesa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0303')),
  ('030306', 'Pachaconas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0303')),
  ('030307', 'Sabaino', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0303')),
  ('030401', 'Chalhuanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030402', 'Capaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030403', 'Caraybamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030404', 'Chapimarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030405', 'Colcabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030406', 'Cotaruse', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030407', 'Huayllo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030408', 'Justo Apu Sahuaraura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030409', 'Lucre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030410', 'Pocohuanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030411', 'San Juan de Chacqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030412', 'Saqayca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030413', 'Soraya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030414', 'Tapairihua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030415', 'Tintay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030416', 'Toraya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030417', 'Yanaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0304')),
  ('030501', 'Tambobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0305')),
  ('030502', 'Cotabambas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0305')),
  ('030503', 'Coyllurqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0305')),
  ('030504', 'Haquira', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0305')),
  ('030505', 'Mara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0305')),
  ('030506', 'Challhuahuacho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0305')),
  ('030601', 'Chincheros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0306')),
  ('030602', 'Anco-Huallo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0306')),
  ('030603', 'Cocharcas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0306')),
  ('030604', 'Huaccana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0306')),
  ('030605', 'Ocobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0306')),
  ('030606', 'Ongoy', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0306')),
  ('030607', 'Uranmarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0306')),
  ('030608', 'Ranracancha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0306')),
  ('030701', 'Chuquibambilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030702', 'Curpahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030703', 'Gamarra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030704', 'Huayllati', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030705', 'Mamara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030706', 'Micaela Bastidas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030707', 'Pataypampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030708', 'Progreso', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030709', 'San Antonio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030710', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030711', 'Turpay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030712', 'Vilcabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030713', 'Virundo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('030714', 'Curasco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0307')),
  ('040101', 'Arequipa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040102', 'Alto Selva Alegre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040103', 'Cayma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040104', 'Cerro Colorado', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040105', 'Characato', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040106', 'Chiguata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040107', 'Jacobo Hunter', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040108', 'La Joya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040109', 'Mariano Melgar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040110', 'Miraflores', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040111', 'Mollebaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040112', 'Paucarpata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040113', 'Pocsi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040114', 'Polobaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040115', 'Quequeqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040116', 'Sabandia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040117', 'Sachaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040118', 'San Juan de Siguas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040119', 'San Juan de Tarucani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040120', 'Santa Isabel de Siguas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040121', 'Santa Rita de Siguas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040122', 'Socabaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040123', 'Tiabaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040124', 'Uchumayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040125', 'Vitor', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040126', 'Yanahuara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040127', 'Yarabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040128', 'Yura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040129', 'Jose Luis Bustamante y Rivero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0401')),
  ('040201', 'Camana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0402')),
  ('040202', 'Jose Maria Quimper', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0402')),
  ('040203', 'Mariano Nicolas Valcarcel', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0402')),
  ('040204', 'Mariscal Caceres', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0402')),
  ('040205', 'Nicolas de Pierola', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0402')),
  ('040206', 'Ocoqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0402')),
  ('040207', 'Quilca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0402')),
  ('040208', 'Samuel Pastor', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0402')),
  ('040301', 'Caraveli', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040302', 'Acari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040303', 'Atico', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040304', 'Atiquipa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040305', 'Bella Union', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040306', 'Cahuacho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040307', 'Chala', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040308', 'Chaparra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040309', 'Huanuhuanu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040310', 'Jaqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040311', 'Lomas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040312', 'Quicacha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040313', 'Yauca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0403')),
  ('040401', 'Aplao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040402', 'Andagua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040403', 'Ayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040404', 'Chachas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040405', 'Chilcaymarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040406', 'Choco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040407', 'Huancarqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040408', 'Machaguay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040409', 'Orcopampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040410', 'Pampacolca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040411', 'Tipan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040412', 'Uqon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040413', 'Uraca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040414', 'Viraco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040419', 'Yanque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040420', 'Majes', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0404')),
  ('040501', 'Chivay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040502', 'Achoma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040503', 'Cabanaconde', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040504', 'Callalli', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040505', 'Caylloma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040506', 'Coporaque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040507', 'Huambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040508', 'Huanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040509', 'Ichupampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040510', 'Lari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040511', 'Lluta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040512', 'Maca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040513', 'Madrigal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040514', 'San Antonio de Chuca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040515', 'Sibayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040516', 'Tapay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040517', 'Tisco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040518', 'Tuti', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040519', 'Yanque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040520', 'Majes', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0405')),
  ('040601', 'Chuquibamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0406')),
  ('040602', 'Andaray', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0406')),
  ('040603', 'Cayarani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0406')),
  ('040604', 'Chichas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0406')),
  ('040605', 'Iray', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0406')),
  ('040606', 'Rio Grande', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0406')),
  ('040607', 'Salamanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0406')),
  ('040608', 'Yanaquihua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0406')),
  ('040701', 'Mollendo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0407')),
  ('040702', 'Cocachacra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0407')),
  ('040703', 'Dean Valdivia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0407')),
  ('040704', 'Islay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0407')),
  ('040705', 'Mejia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0407')),
  ('040706', 'Punta de Bombon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0407')),
  ('040801', 'Cotahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040802', 'Alca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040803', 'Charcana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040804', 'Huaynacotas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040805', 'Pampamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040806', 'Puyca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040807', 'Quechualla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040808', 'Sayla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040809', 'Tauria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040810', 'Tomepampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('040811', 'Toro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0408')),
  ('050101', 'Ayacucho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050102', 'Acocro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050103', 'Acos Vinchos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050104', 'Carmen Alto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050105', 'Chiara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050106', 'Ocros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050107', 'Pacaycasa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050108', 'Quinua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050109', 'San Jose de Ticllas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050110', 'San Juan Bautista', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050111', 'Santiago de Pischa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050112', 'Socos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050113', 'Tambillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050114', 'Vinchos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050115', 'Jesús Nazareno', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0501')),
  ('050201', 'Cangallo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0502')),
  ('050202', 'Chuschi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0502')),
  ('050203', 'Los Morochucos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0502')),
  ('050204', 'Maria Parado de Bellido', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0502')),
  ('050205', 'Paras', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0502')),
  ('050206', 'Totos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0502')),
  ('050301', 'Sancos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0503')),
  ('050302', 'Carapo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0503')),
  ('050303', 'Sacsamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0503')),
  ('050304', 'Santiago de Lucanamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0503')),
  ('050401', 'Huanta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0504')),
  ('050402', 'Ayahuanco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0504')),
  ('050403', 'Huamanguilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0504')),
  ('050404', 'Iguain', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0504')),
  ('050405', 'Luricocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0504')),
  ('050406', 'Santillana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0504')),
  ('050407', 'Sivia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0504')),
  ('050408', 'Llochegua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0504')),
  ('050501', 'San Miguel', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0505')),
  ('050502', 'Anco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0505')),
  ('050503', 'Ayna', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0505')),
  ('050504', 'Chilcas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0505')),
  ('050505', 'Chungui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0505')),
  ('050506', 'Luis Carranza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0505')),
  ('050507', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0505')),
  ('050508', 'Tambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0505')),
  ('050601', 'Puquio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050602', 'Aucara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050603', 'Cabana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050604', 'Carmen Salcedo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050605', 'Chaviqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050606', 'Chipao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050607', 'Huac-Huas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050608', 'Laramate', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050609', 'Leoncio Prado', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050610', 'Llauta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050611', 'Lucanas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050612', 'Ocaqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050613', 'Otoca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050614', 'Saisa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050615', 'San Cristobal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050616', 'San Juan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050617', 'San Pedro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050618', 'San Pedro de Palco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050619', 'Sancos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050620', 'Santa Ana de Huaycahuacho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050621', 'Santa Lucia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0506')),
  ('050701', 'Coracora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0507')),
  ('050702', 'Chumpi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0507')),
  ('050703', 'Coronel Castaqeda', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0507')),
  ('050704', 'Pacapausa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0507')),
  ('050705', 'Pullo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0507')),
  ('050706', 'Puyusca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0507')),
  ('050707', 'San Francisco de Ravacayco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0507')),
  ('050708', 'Upahuacho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0507')),
  ('050801', 'Pausa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050802', 'Colta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050803', 'Corculla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050804', 'Lampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050805', 'Marcabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050806', 'Oyolo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050807', 'Pararca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050808', 'San Javier de Alpabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050809', 'San Jose de Ushua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050810', 'Sara Sara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0508')),
  ('050901', 'Querobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050902', 'Belen', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050903', 'Chalcos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050904', 'Chilcayoc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050905', 'Huacaqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050906', 'Morcolla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050907', 'Paico', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050908', 'San Pedro de Larcay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050909', 'San Salvador de Quije', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050910', 'Santiago de Paucaray', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('050911', 'Soras', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0509')),
  ('051001', 'Huancapi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051002', 'Alcamenca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051003', 'Apongo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051004', 'Asquipata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051005', 'Canaria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051006', 'Cayara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051007', 'Colca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051008', 'Huamanquiquia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051009', 'Huancaraylla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051010', 'Huaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051011', 'Sarhua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051012', 'Vilcanchos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0510')),
  ('051101', 'Vilcas Huaman', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0511')),
  ('051102', 'Accomarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0511')),
  ('051103', 'Carhuanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0511')),
  ('051104', 'Concepcion', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0511')),
  ('051105', 'Huambalpa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0511')),
  ('051106', 'Independencia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0511')),
  ('051107', 'Saurama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0511')),
  ('051108', 'Vischongo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0511')),
  ('060101', 'Cajamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060102', 'Asuncion', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060103', 'Chetilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060104', 'Cospan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060105', 'Encaqada', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060106', 'Jesus', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060107', 'Llacanora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060108', 'Los Baqos del Inca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060109', 'Magdalena', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060110', 'Matara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060111', 'Namora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060112', 'San Juan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0601')),
  ('060201', 'Cajabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0602')),
  ('060202', 'Cachachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0602')),
  ('060203', 'Condebamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0602')),
  ('060204', 'Sitacocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0602')),
  ('060301', 'Celendin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060302', 'Chumuch', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060303', 'Cortegana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060304', 'Huasmin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060305', 'Jorge Chavez', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060306', 'Jose Galvez', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060307', 'Miguel Iglesias', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060308', 'Oxamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060309', 'Sorochuco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060310', 'Sucre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060311', 'Utco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060312', 'La Libertad de Pallan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0603')),
  ('060401', 'Chota', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060402', 'Anguia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060403', 'Chadin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060404', 'Chiguirip', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060405', 'Chimban', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060406', 'Choropampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060407', 'Cochabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060408', 'Conchan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060409', 'Huambos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060410', 'Lajas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060411', 'Llama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060412', 'Miracosta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060413', 'Paccha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060414', 'Pion', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060415', 'Querocoto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060416', 'San Juan de Licupis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060417', 'Tacabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060418', 'Tocmoche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060419', 'Chalamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0604')),
  ('060501', 'Contumaza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0605')),
  ('060502', 'Chilete', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0605')),
  ('060503', 'Cupisnique', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0605')),
  ('060504', 'Guzmango', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0605')),
  ('060505', 'San Benito', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0605')),
  ('060506', 'Santa Cruz de Toled', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0605')),
  ('060507', 'Tantarica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0605')),
  ('060508', 'Yonan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0605')),
  ('060601', 'Cutervo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060602', 'Callayuc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060603', 'Choros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060604', 'Cujillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060605', 'La Ramada', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060606', 'Pimpingos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060607', 'Querocotillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060608', 'San Andres de Cutervo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060609', 'San Juan de Cutervo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060610', 'San Luis de Lucma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060611', 'Santa Cruz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060612', 'Santo Domingo de la Capilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060613', 'Santo Tomas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060614', 'Socota', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060615', 'Toribio Casanova', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0606')),
  ('060701', 'Bambamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0607')),
  ('060702', 'Chugur', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0607')),
  ('060703', 'Hualgayoc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0607')),
  ('060801', 'Jaen', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060802', 'Bellavista', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060803', 'Chontali', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060804', 'Colasay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060805', 'Huabal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060806', 'Las Pirias', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060807', 'Pomahuaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060808', 'Pucara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060809', 'Sallique', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060810', 'San Felipe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060811', 'San Jose del Alto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060812', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0608')),
  ('060901', 'San Ignacio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0609')),
  ('060902', 'Chirinos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0609')),
  ('060903', 'Huarango', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0609')),
  ('060904', 'La Coipa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0609')),
  ('060905', 'Namballe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0609')),
  ('060906', 'San Jose de Lourdes', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0609')),
  ('060907', 'Tabaconas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0609')),
  ('061001', 'Pedro Galvez', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0610')),
  ('061002', 'Chancay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0610')),
  ('061003', 'Eduardo Villanueva', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0610')),
  ('061004', 'Gregorio Pita', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0610')),
  ('061005', 'Ichocan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0610')),
  ('061006', 'Jose Manuel Quiroz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0610')),
  ('061007', 'Jose Sabogal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0610')),
  ('061101', 'San Miguel', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061102', 'Bolivar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061103', 'Calquis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061104', 'Catilluc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061105', 'El Prado', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061106', 'La Florida', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061107', 'Llapa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061108', 'Nanchoc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061109', 'Niepos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061110', 'San Gregorio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061111', 'San Silvestre de Cochan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061112', 'Tongod', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061113', 'Union Agua Blanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0611')),
  ('061201', 'San Pablo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0612')),
  ('061202', 'San Bernardino', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0612')),
  ('061203', 'San Luis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0612')),
  ('061204', 'Tumbaden', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0612')),
  ('061301', 'Santa Cruz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061302', 'Andabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061303', 'Catache', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061304', 'Chancaybaqos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061305', 'La Esperanza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061306', 'Ninabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061307', 'Pulan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061308', 'Saucepampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061309', 'Sexi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061310', 'Uticyacu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('061311', 'Yauyucan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0613')),
  ('070101', 'Callao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0701')),
  ('070102', 'Bellavista', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0701')),
  ('070103', 'Carmen de la Legua Reynoso', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0701')),
  ('070104', 'La Perla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0701')),
  ('070105', 'La Punta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0701')),
  ('070106', 'Ventanilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0701')),
  ('080101', 'Cusco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0801')),
  ('080102', 'Ccorca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0801')),
  ('080103', 'Poroy', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0801')),
  ('080104', 'San Jeronimo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0801')),
  ('080105', 'San Sebastian', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0801')),
  ('080106', 'Santiago', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0801')),
  ('080107', 'Saylla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0801')),
  ('080108', 'Wanchaq', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0801')),
  ('080201', 'Acomayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0802')),
  ('080202', 'Acopia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0802')),
  ('080203', 'Acos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0802')),
  ('080204', 'Mosoc Llacta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0802')),
  ('080205', 'Pomacanchi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0802')),
  ('080206', 'Rondocan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0802')),
  ('080207', 'Sangarara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0802')),
  ('080301', 'Anta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080302', 'Ancahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080303', 'Cachimayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080304', 'Chinchaypujio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080305', 'Huarocondo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080306', 'Limatambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080307', 'Mollepata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080308', 'Pucyura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080309', 'Zurite', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0803')),
  ('080401', 'Calca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0804')),
  ('080402', 'Coya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0804')),
  ('080403', 'Lamay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0804')),
  ('080404', 'Lares', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0804')),
  ('080405', 'Pisac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0804')),
  ('080406', 'San Salvador', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0804')),
  ('080407', 'Taray', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0804')),
  ('080408', 'Yanatile', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0804')),
  ('080501', 'Yanaoca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0805')),
  ('080502', 'Checca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0805')),
  ('080503', 'Kunturkanki', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0805')),
  ('080504', 'Langui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0805')),
  ('080505', 'Layo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0805')),
  ('080506', 'Pampamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0805')),
  ('080507', 'Quehue', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0805')),
  ('080508', 'Tupac Amaru', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0805')),
  ('080601', 'Sicuani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0806')),
  ('080602', 'Checacupe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0806')),
  ('080603', 'Combapata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0806')),
  ('080604', 'Marangani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0806')),
  ('080605', 'Pitumarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0806')),
  ('080606', 'San Pablo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0806')),
  ('080607', 'San Pedro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0806')),
  ('080608', 'Tinta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0806')),
  ('080701', 'Santo Tomas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0807')),
  ('080702', 'Capacmarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0807')),
  ('080703', 'Chamaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0807')),
  ('080704', 'Colquemarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0807')),
  ('080705', 'Livitaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0807')),
  ('080706', 'Llusco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0807')),
  ('080707', 'Quiqota', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0807')),
  ('080708', 'Velille', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0807')),
  ('080801', 'Espinar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0808')),
  ('080802', 'Condoroma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0808')),
  ('080803', 'Coporaque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0808')),
  ('080804', 'Ocoruro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0808')),
  ('080805', 'Pallpata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0808')),
  ('080806', 'Pichigua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0808')),
  ('080807', 'Suyckutambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0808')),
  ('080808', 'Alto Pichigua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0808')),
  ('080901', 'Santa Ana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080902', 'Echarate', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080903', 'Huayopata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080904', 'Maranura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080905', 'Ocobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080906', 'Quellouno', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080907', 'Quimbiri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080908', 'Santa Teresa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080909', 'Vilcabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('080910', 'Pichari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0809')),
  ('081001', 'Paruro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081002', 'Accha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081003', 'Ccapi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081004', 'Colcha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081005', 'Huanoquite', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081006', 'Omacha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081007', 'Paccaritambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081008', 'Pillpinto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081009', 'Yaurisque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0810')),
  ('081101', 'Paucartambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0811')),
  ('081102', 'Caicay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0811')),
  ('081103', 'Challabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0811')),
  ('081104', 'Colquepata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0811')),
  ('081105', 'Huancarani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0811')),
  ('081106', 'Kosqipata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0811')),
  ('081201', 'Urcos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081202', 'Andahuaylillas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081203', 'Camanti', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081204', 'Ccarhuayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081205', 'Ccatca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081206', 'Cusipata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081207', 'Huaro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081208', 'Lucre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081209', 'Marcapata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081210', 'Ocongate', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081211', 'Oropesa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081212', 'Quiquijana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0812')),
  ('081301', 'Urubamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0813')),
  ('081302', 'Chinchero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0813')),
  ('081303', 'Huayllabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0813')),
  ('081304', 'Machupicchu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0813')),
  ('081305', 'Maras', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0813')),
  ('081306', 'Ollantaytambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0813')),
  ('081307', 'Yucay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0813')),
  ('090101', 'Huancavelica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090102', 'Acobambilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090103', 'Acoria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090104', 'Conayca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090105', 'Cuenca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090106', 'Huachocolpa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090107', 'Huayllahuara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090108', 'Izcuchaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090109', 'Laria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090110', 'Manta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090111', 'Mariscal Caceres', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090112', 'Moya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090113', 'Nuevo Occoro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090114', 'Palca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090115', 'Pilchaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090116', 'Vilca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090117', 'Yauli', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090118', 'Ascensión', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090119', 'Huando', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0901')),
  ('090201', 'Acobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0902')),
  ('090202', 'Andabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0902')),
  ('090203', 'Anta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0902')),
  ('090204', 'Caja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0902')),
  ('090205', 'Marcas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0902')),
  ('090206', 'Paucara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0902')),
  ('090207', 'Pomacocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0902')),
  ('090208', 'Rosario', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0902')),
  ('090301', 'Lircay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090302', 'Anchonga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090303', 'Callanmarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090304', 'Ccochaccasa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090305', 'Chincho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090306', 'Congalla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090307', 'Huanca-Huanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090308', 'Huayllay Grande', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090309', 'Julcamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090310', 'San Antonio de Antaparco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090311', 'Santo Tomas de Pata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090312', 'Secclla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0903')),
  ('090401', 'Castrovirreyna', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090402', 'Arma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090403', 'Aurahua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090404', 'Capillas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090405', 'Chupamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090406', 'Cocas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090407', 'Huachos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090408', 'Huamatambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090409', 'Mollepampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090410', 'San Juan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090411', 'Santa Ana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090412', 'Tantara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090413', 'Ticrapo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0904')),
  ('090501', 'Churcampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090502', 'Anco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090503', 'Chinchihuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090504', 'El Carmen', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090505', 'La Merced', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090506', 'Locroja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090507', 'Paucarbamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090508', 'San Miguel de Mayocc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090509', 'San Pedro de Coris', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090510', 'Pachamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0905')),
  ('090601', 'Huaytara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090602', 'Ayavi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090603', 'Cordova', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090604', 'Huayacundo Arma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090605', 'Laramarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090606', 'Ocoyo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090607', 'Pilpichaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090608', 'Querco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090609', 'Quito-Arma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090610', 'San Antonio de Cusicancha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090611', 'San Francisco de Sangayaico', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090612', 'San Isidro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090613', 'Santiago de Chocorvos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090614', 'Santiago de Quirahuara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090615', 'Santo Domingo de Capillas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090616', 'Tambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0906')),
  ('090701', 'Pampas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090702', 'Acostambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090703', 'Acraquia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090704', 'Ahuaycha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090705', 'Colcabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090706', 'Daniel Hernandez', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090707', 'Huachocolpa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090708', 'Huando', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090709', 'Huaribamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090710', 'Qahuimpuquio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090711', 'Pazos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090712', 'Pachamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090713', 'Quishuar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090714', 'Salcabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090715', 'Salcahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090716', 'San Marcos de Rocchac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090717', 'Surcubamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('090718', 'Tintay Puncu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '0907')),
  ('100101', 'Huanuco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100102', 'Amarilis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100103', 'Chinchao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100104', 'Churubamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100105', 'Margos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100106', 'Quisqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100107', 'San Francisco de Cayran', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100108', 'San Pedro de Chaulan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100109', 'Santa Maria del Valle', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100110', 'Yarumayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100111', 'Pillcomarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1001')),
  ('100201', 'Ambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1002')),
  ('100202', 'Cayna', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1002')),
  ('100203', 'Colpas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1002')),
  ('100204', 'Conchamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1002')),
  ('100205', 'Huacar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1002')),
  ('100206', 'San Francisco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1002')),
  ('100207', 'San Rafael', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1002')),
  ('100208', 'Tomay Kichwa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1002')),
  ('100301', 'La Union', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100307', 'Chuquis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100311', 'Marias', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100313', 'Pachas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100316', 'Quivilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100317', 'Ripan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100321', 'Shunqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100322', 'Sillapata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100323', 'Yanas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1003')),
  ('100401', 'Huacaybamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1004')),
  ('100402', 'Canchabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1004')),
  ('100403', 'Cochabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1004')),
  ('100404', 'Pinra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1004')),
  ('100501', 'Llata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100502', 'Arancay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100503', 'Chavin de Pariarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100504', 'Jacas Grande', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100505', 'Jircan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100506', 'Miraflores', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100507', 'Monzon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100508', 'Punchao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100509', 'Puqos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100510', 'Singa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100511', 'Tantamayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1005')),
  ('100601', 'Rupa-Rupa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1006')),
  ('100602', 'Daniel Alomias Robles', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1006')),
  ('100603', 'Hermilio Valdizan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1006')),
  ('100604', 'Jose Crespo y Castillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1006')),
  ('100605', 'Luyando', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1006')),
  ('100606', 'Mariano Damaso Beraun', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1006')),
  ('100701', 'Huacrachuco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1007')),
  ('100702', 'Cholon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1007')),
  ('100703', 'San Buenaventura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1007')),
  ('100801', 'Panao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1008')),
  ('100802', 'Chaglla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1008')),
  ('100803', 'Molino', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1008')),
  ('100804', 'Umari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1008')),
  ('100901', 'Puerto Inca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1009')),
  ('100902', 'Codo del Pozuzo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1009')),
  ('100903', 'Honoria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1009')),
  ('100904', 'Tournavista', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1009')),
  ('100905', 'Yuyapichis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1009')),
  ('101001', 'Jesus', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1010')),
  ('101002', 'Baqos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1010')),
  ('101003', 'Jivia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1010')),
  ('101004', 'Queropalca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1010')),
  ('101005', 'Rondos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1010')),
  ('101006', 'San Francisco de Asis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1010')),
  ('101007', 'San Miguel de Cauri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1010')),
  ('101101', 'Chavinillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1011')),
  ('101102', 'Cahuac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1011')),
  ('101103', 'Chacabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1011')),
  ('101104', 'Chupan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1011')),
  ('101105', 'Jacas Chico', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1011')),
  ('101106', 'Obas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1011')),
  ('101107', 'Pampamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1011')),
  ('101108', 'Choras', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1011')),
  ('110101', 'Ica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110102', 'La Tinguiqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110103', 'Los Aquijes', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110104', 'Ocucaje', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110105', 'Pachacutec', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110106', 'Parcona', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110107', 'Pueblo Nuevo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110108', 'Salas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110109', 'San Jose de los Molinos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110110', 'San Juan Bautista', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110111', 'Santiago', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110112', 'Subtanjalla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110113', 'Tate', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110114', 'Yauca del Rosario  1/', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1101')),
  ('110201', 'Chincha Alta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110202', 'Alto Laran', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110203', 'Chavin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110204', 'Chincha Baja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110205', 'El Carmen', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110206', 'Grocio Prado', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110207', 'Pueblo Nuevo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110208', 'San Juan de Yanac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110209', 'San Pedro de Huacarpana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110210', 'Sunampe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110211', 'Tambo de Mora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1102')),
  ('110301', 'Nazca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1103')),
  ('110302', 'Changuillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1103')),
  ('110303', 'El Ingenio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1103')),
  ('110304', 'Marcona', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1103')),
  ('110305', 'Vista Alegre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1103')),
  ('110401', 'Palpa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1104')),
  ('110402', 'Llipata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1104')),
  ('110403', 'Rio Grande', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1104')),
  ('110404', 'Santa Cruz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1104')),
  ('110405', 'Tibillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1104')),
  ('110501', 'Pisco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1105')),
  ('110502', 'Huancano', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1105')),
  ('110503', 'Humay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1105')),
  ('110504', 'Independencia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1105')),
  ('110505', 'Paracas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1105')),
  ('110506', 'San Andres', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1105')),
  ('110507', 'San Clemente', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1105')),
  ('110508', 'Tupac Amaru Inca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1105')),
  ('120101', 'Huancayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120104', 'Carhuacallanga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120105', 'Chacapampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120106', 'Chicche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120107', 'Chilca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120108', 'Chongos Alto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120111', 'Chupuro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120112', 'Colca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120113', 'Cullhuas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120114', 'El Tambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120116', 'Huacrapuquio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120117', 'Hualhuas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120119', 'Huancan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120120', 'Huasicancha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120121', 'Huayucachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120122', 'Ingenio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120124', 'Pariahuanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120125', 'Pilcomayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120126', 'Pucara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120127', 'Quichuay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120128', 'Quilcas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120129', 'San Agustin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120130', 'San Jeronimo de Tunan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120132', 'Saqo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120133', 'Sapallanga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120134', 'Sicaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120135', 'Santo Domingo de Acobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120136', 'Viques', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1201')),
  ('120201', 'Concepcion', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120202', 'Aco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120203', 'Andamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120204', 'Chambara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120205', 'Cochas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120206', 'Comas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120207', 'Heroinas Toledo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120208', 'Manzanares', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120209', 'Mariscal Castilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120210', 'Matahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120211', 'Mito', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120212', 'Nueve de Julio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120213', 'Orcotuna', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120214', 'San Jose de Quero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120215', 'Santa Rosa de Ocopa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1202')),
  ('120301', 'Chanchamayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1203')),
  ('120302', 'Perene', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1203')),
  ('120303', 'Pichanaqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1203')),
  ('120304', 'San Luis de Shuaro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1203')),
  ('120305', 'San Ramon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1203')),
  ('120306', 'Vitoc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1203')),
  ('120401', 'Jauja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120402', 'Acolla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120403', 'Apata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120404', 'Ataura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120405', 'Canchayllo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120406', 'Curicaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120407', 'El Mantaro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120408', 'Huamali', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120409', 'Huaripampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120410', 'Huertas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120411', 'Janjaillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120412', 'Julcan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120413', 'Leonor Ordoqez', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120414', 'Llocllapampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120415', 'Marco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120416', 'Masma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120417', 'Masma Chicche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120418', 'Molinos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120419', 'Monobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120420', 'Muqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120421', 'Muquiyauyo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120422', 'Paca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120423', 'Paccha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120424', 'Pancan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120425', 'Parco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120426', 'Pomacancha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120427', 'Ricran', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120428', 'San Lorenzo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120429', 'San Pedro de Chunan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120430', 'Sausa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120431', 'Sincos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120432', 'Tunan Marca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120433', 'Yauli', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120434', 'Yauyos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1204')),
  ('120501', 'Junin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1205')),
  ('120502', 'Carhuamayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1205')),
  ('120503', 'Ondores', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1205')),
  ('120504', 'Ulcumayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1205')),
  ('120601', 'Satipo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1206')),
  ('120602', 'Coviriali', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1206')),
  ('120603', 'Llaylla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1206')),
  ('120604', 'Mazamari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1206')),
  ('120605', 'Pampa Hermosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1206')),
  ('120606', 'Pangoa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1206')),
  ('120607', 'Rio Negro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1206')),
  ('120608', 'Rio Tambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1206')),
  ('120701', 'Tarma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120702', 'Acobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120703', 'Huaricolca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120704', 'Huasahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120705', 'La Union', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120706', 'Palca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120707', 'Palcamayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120708', 'San Pedro de Cajas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120709', 'Tapo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1207')),
  ('120801', 'La Oroya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120802', 'Chacapalpa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120803', 'Huay-Huay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120804', 'Marcapomacocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120805', 'Morococha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120806', 'Paccha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120807', 'Santa Barbara de Carhuacayan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120808', 'Santa Rosa de Sacco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120809', 'Suitucancha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120810', 'Yauli', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1208')),
  ('120901', 'Chupaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('120902', 'Ahuac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('120903', 'Chongos Bajo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('120904', 'Huachac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('120905', 'Huamancaca Chico', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('120906', 'San Juan de Iscos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('120907', 'San Juan de Jarpa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('120908', 'Tres de Diciembre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('120909', 'Yanacancha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1209')),
  ('130101', 'Trujillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130102', 'El Porvenir', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130103', 'Florencia de Mora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130104', 'Huanchaco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130105', 'La Esperanza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130106', 'Laredo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130107', 'Moche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130108', 'Poroto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130109', 'Salaverry', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130110', 'Simbal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130111', 'Victor Larco Herrera', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1301')),
  ('130201', 'Ascope', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1302')),
  ('130202', 'Chicama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1302')),
  ('130203', 'Chocope', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1302')),
  ('130204', 'Magdalena de Cao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1302')),
  ('130205', 'Paijan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1302')),
  ('130206', 'Razuri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1302')),
  ('130207', 'Santiago de Cao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1302')),
  ('130208', 'Casa Grande', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1302')),
  ('130301', 'Bolivar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1303')),
  ('130302', 'Bambamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1303')),
  ('130303', 'Condormarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1303')),
  ('130304', 'Longotea', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1303')),
  ('130305', 'Uchumarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1303')),
  ('130306', 'Ucuncha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1303')),
  ('130401', 'Chepen', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1304')),
  ('130402', 'Pacanga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1304')),
  ('130403', 'Pueblo Nuevo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1304')),
  ('130501', 'Julcan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1305')),
  ('130502', 'Calamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1305')),
  ('130503', 'Carabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1305')),
  ('130504', 'Huaso', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1305')),
  ('130601', 'Otuzco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130602', 'Agallpampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130604', 'Charat', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130605', 'Huaranchal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130606', 'La Cuesta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130608', 'Mache', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130610', 'Paranday', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130611', 'Salpo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130613', 'Sinsicap', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130614', 'Usquil', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1306')),
  ('130701', 'San Pedro de Lloc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1307')),
  ('130702', 'Guadalupe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1307')),
  ('130703', 'Jequetepeque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1307')),
  ('130704', 'Pacasmayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1307')),
  ('130705', 'San Jose', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1307')),
  ('130801', 'Tayabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130802', 'Buldibuyo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130803', 'Chillia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130804', 'Huancaspata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130805', 'Huaylillas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130806', 'Huayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130807', 'Ongon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130808', 'Parcoy', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130809', 'Pataz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130810', 'Pias', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130811', 'Santiago de Challas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130812', 'Taurija', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130813', 'Urpay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1308')),
  ('130901', 'Huamachuco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1309')),
  ('130902', 'Chugay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1309')),
  ('130903', 'Cochorco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1309')),
  ('130904', 'Curgos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1309')),
  ('130905', 'Marcabal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1309')),
  ('130906', 'Sanagoran', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1309')),
  ('130907', 'Sarin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1309')),
  ('130908', 'Sartimbamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1309')),
  ('131001', 'Santiago de Chuco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1310')),
  ('131002', 'Angasmarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1310')),
  ('131003', 'Cachicadan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1310')),
  ('131004', 'Mollebamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1310')),
  ('131005', 'Mollepata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1310')),
  ('131006', 'Quiruvilca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1310')),
  ('131007', 'Santa Cruz de Chuca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1310')),
  ('131008', 'Sitabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1310')),
  ('131101', 'Cascas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1311')),
  ('131102', 'Lucma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1311')),
  ('131103', 'Marmot', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1311')),
  ('131104', 'Sayapullo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1311')),
  ('131201', 'Viru', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1312')),
  ('131202', 'Chao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1312')),
  ('131203', 'Guadalupito', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1312')),
  ('140101', 'Chiclayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140102', 'Chongoyape', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140103', 'Eten', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140104', 'Eten Puerto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140105', 'Jose Leonardo Ortiz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140106', 'La Victoria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140107', 'Lagunas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140108', 'Monsefu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140109', 'Nueva Arica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140110', 'Oyotun', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140111', 'Picsi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140112', 'Pimentel', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140113', 'Reque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140114', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140115', 'Saqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140116', 'Cayaltí', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140117', 'Patapo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140118', 'Pomalca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140119', 'Pucalá', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140120', 'Tumán', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1401')),
  ('140201', 'Ferreqafe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1402')),
  ('140202', 'Caqaris', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1402')),
  ('140203', 'Incahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1402')),
  ('140204', 'Manuel Antonio Mesones Muro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1402')),
  ('140205', 'Pitipo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1402')),
  ('140206', 'Pueblo Nuevo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1402')),
  ('140301', 'Lambayeque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140302', 'Chochope', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140303', 'Illimo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140304', 'Jayanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140305', 'Mochumi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140306', 'Morrope', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140307', 'Motupe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140308', 'Olmos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140309', 'Pacora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140310', 'Salas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140311', 'San Jose', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('140312', 'Tucume', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1403')),
  ('150101', 'Cercado de Lima', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150102', 'Ancon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150103', 'Ate', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150104', 'Barranco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150105', 'Breña', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150106', 'Carabayllo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150107', 'Chaclacayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150108', 'Chorrillos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150109', 'Cieneguilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150110', 'Comas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150111', 'El Agustino', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150112', 'Independencia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150113', 'Jesus Maria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150114', 'La Molina', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150115', 'La Victoria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150116', 'Lince', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150117', 'Los Olivos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150118', 'Lurigancho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150119', 'Lurin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150120', 'Magdalena del Mar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150121', 'Pueblo Libre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150122', 'Miraflores', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150123', 'Pachacamac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150124', 'Pucusana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150125', 'Puente Piedra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150126', 'Punta Hermosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150127', 'Punta Negra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150128', 'Rimac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150129', 'San Bartolo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150130', 'San Borja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150131', 'San Isidro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150132', 'San Juan de Lurigancho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150133', 'San Juan de Miraflores', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150134', 'San Luis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150135', 'San Martin de Porres', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150136', 'San Miguel', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150137', 'Santa Anita', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150138', 'Santa Maria del Mar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150139', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150140', 'Santiago de Surco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150141', 'Surquillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150142', 'Villa El Salvador', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150143', 'Villa Maria del Triunfo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1501')),
  ('150201', 'Barranca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1502')),
  ('150202', 'Paramonga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1502')),
  ('150203', 'Pativilca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1502')),
  ('150204', 'Supe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1502')),
  ('150205', 'Supe Puerto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1502')),
  ('150301', 'Cajatambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1503')),
  ('150302', 'Copa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1503')),
  ('150303', 'Gorgor', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1503')),
  ('150304', 'Huancapon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1503')),
  ('150305', 'Manas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1503')),
  ('150401', 'Canta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1504')),
  ('150402', 'Arahuay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1504')),
  ('150403', 'Huamantanga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1504')),
  ('150404', 'Huaros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1504')),
  ('150405', 'Lachaqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1504')),
  ('150406', 'San Buenaventura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1504')),
  ('150407', 'Santa Rosa de Quives', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1504')),
  ('150501', 'San Vicente de Cañete', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150502', 'Asia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150503', 'Calango', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150504', 'Cerro Azul', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150505', 'Chilca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150506', 'Coayllo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150507', 'Imperial', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150508', 'Lunahuana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150509', 'Mala', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150510', 'Nuevo Imperial', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150511', 'Pacaran', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150512', 'Quilmana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150513', 'San Antonio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150514', 'San Luis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150515', 'Santa Cruz de Flores', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150516', 'Zuqiga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1505')),
  ('150601', 'Huaral', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150602', 'Atavillos Alto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150603', 'Atavillos Bajo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150604', 'Aucallama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150605', 'Chancay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150606', 'Ihuari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150607', 'Lampian', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150608', 'Pacaraos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150609', 'San Miguel de Acos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150610', 'Santa Cruz de Andamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150611', 'Sumbilca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150612', 'Veintisiete de Noviembre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1506')),
  ('150701', 'Matucana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150702', 'Antioquia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150703', 'Callahuanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150704', 'Carampoma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150705', 'Chicla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150706', 'Cuenca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150707', 'Huachupampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150708', 'Huanza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150709', 'Huarochiri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150710', 'Lahuaytambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150711', 'Langa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150712', 'Laraos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150713', 'Mariatana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150714', 'Ricardo Palma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150715', 'San Andres de Tupicocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150716', 'San Antonio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150717', 'San Bartolome', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150718', 'San Damian', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150719', 'San Juan de Iris', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150720', 'San Juan de Tantaranche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150721', 'San Lorenzo de Quinti', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150722', 'San Mateo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150723', 'San Mateo de Otao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150724', 'San Pedro de Casta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150725', 'San Pedro de Huancayre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150726', 'Sangallaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150727', 'Santa Cruz de Cocachacra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150728', 'Santa Eulalia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150729', 'Santiago de Anchucaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150730', 'Santiago de Tuna', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150731', 'Santo Domingo de los Olleros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150732', 'Surco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1507')),
  ('150801', 'Huacho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150802', 'Ambar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150803', 'Caleta de Carquin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150804', 'Checras', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150805', 'Hualmay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150806', 'Huaura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150807', 'Leoncio Prado', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150808', 'Paccho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150809', 'Santa Leonor', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150810', 'Santa Maria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150811', 'Sayan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150812', 'Vegueta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1508')),
  ('150901', 'Oyon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1509')),
  ('150902', 'Andajes', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1509')),
  ('150903', 'Caujul', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1509')),
  ('150904', 'Cochamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1509')),
  ('150905', 'Navan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1509')),
  ('150906', 'Pachangara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1509')),
  ('151001', 'Yauyos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151002', 'Alis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151003', 'Ayauca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151004', 'Ayaviri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151005', 'Azangaro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151006', 'Cacra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151007', 'Carania', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151008', 'Catahuasi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151009', 'Chocos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151010', 'Cochas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151011', 'Colonia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151012', 'Hongos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151013', 'Huampara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151014', 'Huancaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151015', 'Huangascar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151016', 'Huantan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151017', 'Huaqec', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151018', 'Laraos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151019', 'Lincha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151020', 'Madean', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151021', 'Miraflores', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151022', 'Omas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151023', 'Putinza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151024', 'Quinches', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151025', 'Quinocay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151026', 'San Joaquin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151027', 'San Pedro de Pilas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151028', 'Tanta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151029', 'Tauripampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151030', 'Tomas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151031', 'Tupe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151032', 'Viqac', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('151033', 'Vitis', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1510')),
  ('160101', 'Iquitos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160102', 'Alto Nanay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160103', 'Fernando Lores', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160104', 'Indiana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160105', 'Las Amazonas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160106', 'Mazan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160107', 'Napo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160108', 'Punchana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160109', 'Putumayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160110', 'Torres Causana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160111', 'Yaquerana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160112', 'Belén', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160113', 'San Juan Bautista', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1601')),
  ('160201', 'Yurimaguas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160202', 'Balsapuerto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160203', 'Barranca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160204', 'Cahuapanas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160205', 'Jeberos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160206', 'Lagunas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160207', 'Manseriche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160208', 'Morona', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160209', 'Pastaza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160210', 'Santa Cruz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160211', 'Teniente Cesar Lopez Rojas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1602')),
  ('160301', 'Nauta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1603')),
  ('160302', 'Parinari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1603')),
  ('160303', 'Tigre', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1603')),
  ('160304', 'Trompeteros', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1603')),
  ('160305', 'Urarinas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1603')),
  ('160401', 'Ramon Castilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1604')),
  ('160402', 'Pebas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1604')),
  ('160403', 'Yavari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1604')),
  ('160404', 'San Pablo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1604')),
  ('160501', 'Requena', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160502', 'Alto Tapiche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160503', 'Capelo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160504', 'Emilio San Martin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160505', 'Maquia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160506', 'Puinahua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160507', 'Saquena', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160508', 'Soplin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160509', 'Tapiche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160510', 'Jenaro Herrera', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160511', 'Yaquerana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1605')),
  ('160601', 'Contamana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1606')),
  ('160602', 'Inahuaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1606')),
  ('160603', 'Padre Marquez', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1606')),
  ('160604', 'Pampa Hermosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1606')),
  ('160605', 'Sarayacu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1606')),
  ('160606', 'Vargas Guerra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1606')),
  ('170101', 'Tambopata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1701')),
  ('170102', 'Inambari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1701')),
  ('170103', 'Las Piedras', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1701')),
  ('170104', 'Laberinto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1701')),
  ('170201', 'Manu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1702')),
  ('170202', 'Fitzcarrald', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1702')),
  ('170203', 'Madre de Dios', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1702')),
  ('170204', 'Huepetuhe', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1702')),
  ('170301', 'Iqapari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1703')),
  ('170302', 'Iberia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1703')),
  ('170303', 'Tahuamanu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1703')),
  ('180101', 'Moquegua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1801')),
  ('180102', 'Carumas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1801')),
  ('180103', 'Cuchumbaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1801')),
  ('180104', 'Samegua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1801')),
  ('180105', 'San Cristobal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1801')),
  ('180106', 'Torata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1801')),
  ('180201', 'Omate', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180202', 'Chojata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180203', 'Coalaque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180204', 'Ichuqa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180205', 'La Capilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180206', 'Lloque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180207', 'Matalaque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180208', 'Puquina', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180209', 'Quinistaquillas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180210', 'Ubinas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180211', 'Yunga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1802')),
  ('180301', 'Ilo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1803')),
  ('180302', 'El Algarrobal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1803')),
  ('180303', 'Pacocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1803')),
  ('190101', 'Chaupimarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190102', 'Huachon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190103', 'Huariaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190104', 'Huayllay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190105', 'Ninacaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190106', 'Pallanchacra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190107', 'Paucartambo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190108', 'San Fco.De Asis de Yarusyacan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190109', 'Simon Bolivar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190110', 'Ticlacayan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190111', 'Tinyahuarco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190112', 'Vicco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190113', 'Yanacancha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1901')),
  ('190201', 'Yanahuanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1902')),
  ('190202', 'Chacayan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1902')),
  ('190203', 'Goyllarisquizga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1902')),
  ('190204', 'Paucar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1902')),
  ('190205', 'San Pedro de Pillao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1902')),
  ('190206', 'Santa Ana de Tusi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1902')),
  ('190207', 'Tapuc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1902')),
  ('190208', 'Vilcabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1902')),
  ('190301', 'Oxapampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1903')),
  ('190302', 'Chontabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1903')),
  ('190303', 'Huancabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1903')),
  ('190304', 'Palcazu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1903')),
  ('190305', 'Pozuzo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1903')),
  ('190306', 'Puerto Bermudez', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1903')),
  ('190307', 'Villa Rica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '1903')),
  ('200101', 'Piura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200104', 'Castilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200105', 'Catacaos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200107', 'Cura Mori', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200108', 'El Tallan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200109', 'La Arena', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200110', 'La Union', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200111', 'Las Lomas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200114', 'Tambo Grande', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2001')),
  ('200201', 'Ayabaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200202', 'Frias', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200203', 'Jilili', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200204', 'Lagunas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200205', 'Montero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200206', 'Pacaipampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200207', 'Paimas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200208', 'Sapillica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200209', 'Sicchez', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200210', 'Suyo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2002')),
  ('200301', 'Huancabamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2003')),
  ('200302', 'Canchaque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2003')),
  ('200303', 'El Carmen de la Frontera', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2003')),
  ('200304', 'Huarmaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2003')),
  ('200305', 'Lalaquiz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2003')),
  ('200306', 'San Miguel de El Faique', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2003')),
  ('200307', 'Sondor', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2003')),
  ('200308', 'Sondorillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2003')),
  ('200401', 'Chulucanas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200402', 'Buenos Aires', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200403', 'Chalaco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200404', 'La Matanza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200405', 'Morropon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200406', 'Salitral', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200407', 'San Juan de Bigote', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200408', 'Santa Catalina de Mossa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200409', 'Santo Domingo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200410', 'Yamango', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2004')),
  ('200501', 'Paita', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2005')),
  ('200502', 'Amotape', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2005')),
  ('200503', 'Arenal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2005')),
  ('200504', 'Colan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2005')),
  ('200505', 'La Huaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2005')),
  ('200506', 'Tamarindo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2005')),
  ('200507', 'Vichayal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2005')),
  ('200601', 'Sullana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2006')),
  ('200602', 'Bellavista', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2006')),
  ('200603', 'Ignacio Escudero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2006')),
  ('200604', 'Lancones', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2006')),
  ('200605', 'Marcavelica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2006')),
  ('200606', 'Miguel Checa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2006')),
  ('200607', 'Querecotillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2006')),
  ('200608', 'Salitral', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2006')),
  ('200701', 'Pariqas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2007')),
  ('200702', 'El Alto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2007')),
  ('200703', 'La Brea', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2007')),
  ('200704', 'Lobitos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2007')),
  ('200705', 'Los Organos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2007')),
  ('200706', 'Mancora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2007')),
  ('200801', 'Sechura', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2008')),
  ('200802', 'Bellavista de la Union', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2008')),
  ('200803', 'Bernal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2008')),
  ('200804', 'Cristo Nos Valga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2008')),
  ('200805', 'Vice', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2008')),
  ('200806', 'Rinconada Llicuar', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2008')),
  ('210101', 'Puno', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210102', 'Acora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210103', 'Amantani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210104', 'Atuncolla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210105', 'Capachica', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210106', 'Chucuito', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210107', 'Coata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210108', 'Huata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210109', 'Maqazo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210110', 'Paucarcolla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210111', 'Pichacani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210112', 'Plateria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210113', 'San Antonio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210114', 'Tiquillaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210115', 'Vilque', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2101')),
  ('210201', 'Azangaro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210202', 'Achaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210203', 'Arapa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210204', 'Asillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210205', 'Caminaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210206', 'Chupa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210207', 'Jose Domingo Choquehuanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210208', 'Muqani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210209', 'Potoni', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210210', 'Saman', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210211', 'San Anton', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210212', 'San Jose', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210213', 'San Juan de Salinas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210214', 'Santiago de Pupuja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210215', 'Tirapata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2102')),
  ('210301', 'Macusani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210302', 'Ajoyani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210303', 'Ayapata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210304', 'Coasa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210305', 'Corani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210306', 'Crucero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210307', 'Ituata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210308', 'Ollachea', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210309', 'San Gaban', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210310', 'Usicayos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2103')),
  ('210401', 'Juli', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2104')),
  ('210402', 'Desaguadero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2104')),
  ('210403', 'Huacullani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2104')),
  ('210404', 'Kelluyo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2104')),
  ('210405', 'Pisacoma', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2104')),
  ('210406', 'Pomata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2104')),
  ('210407', 'Zepita', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2104')),
  ('210501', 'Ilave', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2105')),
  ('210502', 'Capazo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2105')),
  ('210503', 'Pilcuyo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2105')),
  ('210504', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2105')),
  ('210505', 'Conduriri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2105')),
  ('210601', 'Huancane', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2106')),
  ('210602', 'Cojata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2106')),
  ('210603', 'Huatasani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2106')),
  ('210604', 'Inchupalla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2106')),
  ('210605', 'Pusi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2106')),
  ('210606', 'Rosaspata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2106')),
  ('210607', 'Taraco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2106')),
  ('210608', 'Vilque Chico', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2106')),
  ('210701', 'Lampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210702', 'Cabanilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210703', 'Calapuja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210704', 'Nicasio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210705', 'Ocuviri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210706', 'Palca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210707', 'Paratia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210708', 'Pucara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210709', 'Santa Lucia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210710', 'Vilavila', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2107')),
  ('210801', 'Ayaviri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210802', 'Antauta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210803', 'Cupi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210804', 'Llalli', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210805', 'Macari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210806', 'Nuqoa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210807', 'Orurillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210808', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210809', 'Umachiri', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2108')),
  ('210901', 'Moho', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2109')),
  ('210902', 'Conima', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2109')),
  ('210903', 'Huayrapata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2109')),
  ('210904', 'Tilali', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2109')),
  ('211001', 'Putina', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2110')),
  ('211002', 'Ananea', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2110')),
  ('211003', 'Pedro Vilca Apaza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2110')),
  ('211004', 'Quilcapuncu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2110')),
  ('211005', 'Sina', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2110')),
  ('211101', 'Juliaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2111')),
  ('211102', 'Cabana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2111')),
  ('211103', 'Cabanillas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2111')),
  ('211104', 'Caracoto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2111')),
  ('211201', 'Sandia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211202', 'Cuyocuyo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211203', 'Limbani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211204', 'Patambuco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211205', 'Phara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211206', 'Quiaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211207', 'San Juan del Oro', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211208', 'Yanahuaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211209', 'Alto Inambari', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2112')),
  ('211301', 'Yunguyo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2113')),
  ('211302', 'Anapia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2113')),
  ('211303', 'Copani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2113')),
  ('211304', 'Cuturapi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2113')),
  ('211305', 'Ollaraya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2113')),
  ('211306', 'Tinicachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2113')),
  ('211307', 'Unicachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2113')),
  ('220101', 'Moyobamba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2201')),
  ('220102', 'Calzada', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2201')),
  ('220103', 'Habana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2201')),
  ('220104', 'Jepelacio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2201')),
  ('220105', 'Soritor', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2201')),
  ('220106', 'Yantalo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2201')),
  ('220201', 'Bellavista', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2202')),
  ('220202', 'Alto Biavo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2202')),
  ('220203', 'Bajo Biavo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2202')),
  ('220204', 'Huallaga', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2202')),
  ('220205', 'San Pablo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2202')),
  ('220206', 'San Rafael', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2202')),
  ('220301', 'San Jose de Sisa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2203')),
  ('220302', 'Agua Blanca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2203')),
  ('220303', 'San Martin', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2203')),
  ('220304', 'Santa Rosa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2203')),
  ('220305', 'Shatoja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2203')),
  ('220401', 'Saposoa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2204')),
  ('220402', 'Alto Saposoa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2204')),
  ('220403', 'El Eslabon', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2204')),
  ('220404', 'Piscoyacu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2204')),
  ('220405', 'Sacanche', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2204')),
  ('220406', 'Tingo de Saposoa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2204')),
  ('220501', 'Lamas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220502', 'Alonso de Alvarado', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220503', 'Barranquita', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220504', 'Caynarachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220505', 'Cuqumbuqui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220506', 'Pinto Recodo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220507', 'Rumisapa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220508', 'San Roque de Cumbaza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220509', 'Shanao', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220510', 'Tabalosos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220511', 'Zapatero', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2205')),
  ('220601', 'Juanjui', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2206')),
  ('220602', 'Campanilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2206')),
  ('220603', 'Huicungo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2206')),
  ('220604', 'Pachiza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2206')),
  ('220605', 'Pajarillo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2206')),
  ('220701', 'Picota', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220702', 'Buenos Aires', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220703', 'Caspisapa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220704', 'Pilluana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220705', 'Pucacaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220706', 'San Cristobal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220707', 'San Hilarion', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220708', 'Shamboyacu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220709', 'Tingo de Ponasa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220710', 'Tres Unidos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2207')),
  ('220801', 'Rioja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220802', 'Awajun', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220803', 'Elias Soplin Vargas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220804', 'Nueva Cajamarca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220805', 'Pardo Miguel', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220806', 'Posic', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220807', 'San Fernando', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220808', 'Yorongos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220809', 'Yuracyacu', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2208')),
  ('220901', 'Tarapoto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220902', 'Alberto Leveau', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220903', 'Cacatachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220904', 'Chazuta', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220905', 'Chipurana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220906', 'El Porvenir', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220907', 'Huimbayoc', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220908', 'Juan Guerra', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220909', 'La Banda de Shilcayo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220910', 'Morales', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220911', 'Papaplaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220912', 'San Antonio', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220913', 'Sauce', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('220914', 'Shapaja', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2209')),
  ('221001', 'Tocache', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2210')),
  ('221002', 'Nuevo Progreso', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2210')),
  ('221003', 'Polvora', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2210')),
  ('221004', 'Shunte', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2210')),
  ('221005', 'Uchiza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2210')),
  ('230101', 'Tacna', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230102', 'Alto de la Alianza', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230103', 'Calana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230104', 'Ciudad Nueva', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230105', 'Inclan', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230106', 'Pachia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230107', 'Palca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230108', 'Pocollay', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230109', 'Sama', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230110', 'Cor Gregorio Albarracín', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2301')),
  ('230201', 'Candarave', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2302')),
  ('230202', 'Cairani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2302')),
  ('230203', 'Camilaca', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2302')),
  ('230204', 'Curibaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2302')),
  ('230205', 'Huanuara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2302')),
  ('230206', 'Quilahuani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2302')),
  ('230301', 'Locumba', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2303')),
  ('230302', 'Ilabaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2303')),
  ('230303', 'Ite', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2303')),
  ('230401', 'Tarata', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2304')),
  ('230402', 'Chucatamani', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2304')),
  ('230403', 'Estique', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2304')),
  ('230404', 'Estique-Pampa', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2304')),
  ('230405', 'Sitajara', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2304')),
  ('230406', 'Susapaya', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2304')),
  ('230407', 'Tarucachi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2304')),
  ('230408', 'Ticaco', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2304')),
  ('240101', 'Tumbes', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2401')),
  ('240102', 'Corrales', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2401')),
  ('240103', 'La Cruz', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2401')),
  ('240104', 'Pampas de Hospital', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2401')),
  ('240105', 'San Jacinto', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2401')),
  ('240106', 'San Juan de la Virgen', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2401')),
  ('240201', 'Zorritos', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2402')),
  ('240202', 'Casitas', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2402')),
  ('240301', 'Zarumilla', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2403')),
  ('240302', 'Aguas Verdes', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2403')),
  ('240303', 'Matapalo', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2403')),
  ('240304', 'Papayal', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2403')),
  ('250101', 'Calleria', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2501')),
  ('250102', 'Campoverde', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2501')),
  ('250103', 'Iparia', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2501')),
  ('250104', 'Masisea', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2501')),
  ('250105', 'Yarinacocha', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2501')),
  ('250106', 'Nueva Requena', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2501')),
  ('250201', 'Raymondi', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2502')),
  ('250202', 'Sepahua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2502')),
  ('250203', 'Tahuania', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2502')),
  ('250204', 'Yurua', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2502')),
  ('250301', 'Padre Abad', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2503')),
  ('250302', 'Irazola', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2503')),
  ('250303', 'Curimana', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2503')),
  ('250401', 'Purus', (SELECT id FROM ubigeo_provincias WHERE codigo_ubigeo = '2504'))
ON DUPLICATE KEY UPDATE
  nombre = VALUES(nombre),
  provincia_id = VALUES(provincia_id);
