/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.shared.sede;

import com.dulcecontrol.bakery.features.admin.configuracion.repository.SedeAdminRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioSedeId;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioTienda;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioSedeRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Sede;
import com.dulcecontrol.bakery.security.TipoUsuario;
import com.dulcecontrol.bakery.shared.exception.AuthenticationException;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ForbiddenException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import com.dulcecontrol.bakery.shared.sede.SedeContext;
import com.dulcecontrol.bakery.shared.sede.SedeContextHolder;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class SedeContextFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SedeContextFilter.class);
    public static final String HEADER_SEDE_ID = "X-Sede-Id";
    private final UsuarioTiendaRepository usuarioTiendaRepository;
    private final UsuarioSedeRepository usuarioSedeRepository;
    private final SedeAdminRepository sedeAdminRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            this.aplicarContexto(request);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            SedeContextHolder.clear();
        }
    }

    private void aplicarContexto(HttpServletRequest request) {
        if (this.shouldSkip(request)) {
            return;
        }
        String headerValue = request.getHeader(HEADER_SEDE_ID);
        if (!StringUtils.hasText((String)headerValue)) {
            return;
        }
        Long sedeId = this.parseSedeId(headerValue);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            throw new AuthenticationException("Usuario no autenticado");
        }
        String correo = authentication.getName();
        if (!StringUtils.hasText((String)correo)) {
            throw new AuthenticationException("No se pudo determinar el usuario autenticado");
        }
        UsuarioTienda usuario = (UsuarioTienda)this.usuarioTiendaRepository.findByCorreo(correo).orElseThrow(() -> new AuthenticationException("Usuario de tienda no encontrado"));
        this.usuarioSedeRepository.findById((Object)new UsuarioSedeId(usuario.getId(), sedeId)).orElseThrow(() -> new ForbiddenException("No tienes acceso a la sede seleccionada"));
        Sede sede = (Sede)this.sedeAdminRepository.findById((Object)sedeId).orElseThrow(() -> new ResourceNotFoundException("La sede seleccionada no existe"));
        if (Boolean.FALSE.equals(sede.getActivo())) {
            throw new ForbiddenException("La sede seleccionada est\u00e1 inactiva");
        }
        if (sede.getTienda() == null || !usuario.getTiendaId().equals(sede.getTienda().getId())) {
            throw new ForbiddenException("La sede no pertenece a tu tienda");
        }
        SedeContextHolder.set((SedeContext)new SedeContext(sede.getId(), sede.getTienda().getId(), sede.getNombre(), Boolean.TRUE.equals(sede.getEsPrincipal())));
    }

    private boolean shouldSkip(HttpServletRequest request) {
        Object userTypeAttr = request.getAttribute("userType");
        if (!(userTypeAttr instanceof TipoUsuario)) {
            return true;
        }
        TipoUsuario tipoUsuario = (TipoUsuario)userTypeAttr;
        return tipoUsuario != TipoUsuario.ADMIN;
    }

    private Long parseSedeId(String raw) {
        try {
            return Long.parseLong(raw);
        }
        catch (NumberFormatException ex) {
            log.debug("Cabecera X-Sede-Id inv\u00e1lida: {}", (Object)raw);
            throw new BadRequestException("El valor de X-Sede-Id debe ser num\u00e9rico");
        }
    }

    @Generated
    public SedeContextFilter(UsuarioTiendaRepository usuarioTiendaRepository, UsuarioSedeRepository usuarioSedeRepository, SedeAdminRepository sedeAdminRepository) {
        this.usuarioTiendaRepository = usuarioTiendaRepository;
        this.usuarioSedeRepository = usuarioSedeRepository;
        this.sedeAdminRepository = sedeAdminRepository;
    }
}

