/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.shared.integration.decolecta;

import com.dulcecontrol.bakery.shared.integration.decolecta.DecolectaClient;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.ReniecDniResponse;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.SunatRucBasicoResponse;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.SunatRucFullResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DecolectaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecolectaService.class);
    private final DecolectaClient decolectaClient;

    public ReniecDniResponse consultarPersonaPorDni(String dni) {
        this.validarDni(dni);
        log.info("Consultando persona con DNI: {}", (Object)dni);
        return this.decolectaClient.consultarDni(dni);
    }

    public SunatRucBasicoResponse consultarEmpresaPorRucBasico(String ruc) {
        this.validarRuc(ruc);
        log.info("Consultando empresa con RUC (b\u00e1sico): {}", (Object)ruc);
        return this.decolectaClient.consultarRucBasico(ruc);
    }

    public SunatRucFullResponse consultarEmpresaPorRucCompleto(String ruc) {
        this.validarRuc(ruc);
        log.info("Consultando empresa con RUC (completo): {}", (Object)ruc);
        return this.decolectaClient.consultarRucCompleto(ruc);
    }

    private void validarDni(String dni) {
        if (dni == null || !dni.matches("\\d{8}")) {
            throw new IllegalArgumentException("DNI inv\u00e1lido. Debe contener 8 d\u00edgitos");
        }
    }

    private void validarRuc(String ruc) {
        if (ruc == null || !ruc.matches("\\d{11}")) {
            throw new IllegalArgumentException("RUC inv\u00e1lido. Debe contener 11 d\u00edgitos");
        }
    }

    @Generated
    public DecolectaService(DecolectaClient decolectaClient) {
        this.decolectaClient = decolectaClient;
    }
}

