/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.security.token.service.impl;

import com.dulcecontrol.bakery.security.JwtProvider;
import com.dulcecontrol.bakery.security.TipoUsuario;
import com.dulcecontrol.bakery.security.token.dto.TokenListResponse;
import com.dulcecontrol.bakery.security.token.dto.TokenProfileResponse;
import com.dulcecontrol.bakery.security.token.dto.TokenRegisterRequest;
import com.dulcecontrol.bakery.security.token.entity.DesarrolladorToken;
import com.dulcecontrol.bakery.security.token.repository.DesarrolladorTokenRepository;
import com.dulcecontrol.bakery.security.token.service.ITokenService;
import com.dulcecontrol.bakery.shared.exception.AuthenticationException;
import com.dulcecontrol.bakery.shared.exception.BusinessException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TokenService
implements ITokenService {
    private final DesarrolladorTokenRepository desarrolladorTokenRepository;
    private final JwtProvider jwtProvider;
    private final BCryptPasswordEncoder passwordEncoder;

    @Transactional
    public String register(TokenRegisterRequest request) {
        if (this.desarrolladorTokenRepository.existsByCorreo(request.getCorreo())) {
            throw new BusinessException("El correo ya est\u00e1 registrado");
        }
        if (this.desarrolladorTokenRepository.existsByNombreCompleto(request.getNombreCompleto())) {
            throw new BusinessException("El nombre completo ya est\u00e1 registrado");
        }
        DesarrolladorToken desarrollador = new DesarrolladorToken();
        desarrollador.setNombreCompleto(request.getNombreCompleto());
        desarrollador.setCorreo(request.getCorreo());
        desarrollador.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getContrasena()));
        desarrollador.setActivo(Boolean.valueOf(true));
        this.desarrolladorTokenRepository.save((Object)desarrollador);
        return this.jwtProvider.generarToken(desarrollador.getCorreo(), "ROLE_DEVELOPER", TipoUsuario.DEVELOPER, null);
    }

    @Transactional(readOnly=true)
    public String login(String correo, String contrasena) {
        DesarrolladorToken desarrollador = (DesarrolladorToken)this.desarrolladorTokenRepository.findByCorreo(correo).orElseThrow(() -> new AuthenticationException("Credenciales inv\u00e1lidas"));
        if (!desarrollador.getActivo().booleanValue()) {
            throw new AuthenticationException("Desarrollador inactivo");
        }
        if (!this.passwordEncoder.matches((CharSequence)contrasena, desarrollador.getHashContrasena())) {
            throw new AuthenticationException("Credenciales inv\u00e1lidas");
        }
        return this.jwtProvider.generarToken(desarrollador.getCorreo(), "ROLE_DEVELOPER", TipoUsuario.DEVELOPER, null);
    }

    @Transactional(readOnly=true)
    public TokenProfileResponse obtenerPerfil(String correo) {
        DesarrolladorToken desarrollador = (DesarrolladorToken)this.desarrolladorTokenRepository.findByCorreo(correo).orElseThrow(() -> new AuthenticationException("Desarrollador no encontrado"));
        return new TokenProfileResponse(desarrollador.getId(), desarrollador.getNombreCompleto(), desarrollador.getCorreo(), desarrollador.getActivo());
    }

    @Transactional(readOnly=true)
    public Page<TokenListResponse> listarTodos(Pageable pageable) {
        return this.desarrolladorTokenRepository.findAll(pageable).map(dev -> new TokenListResponse(dev.getId(), dev.getNombreCompleto(), dev.getCorreo(), dev.getActivo(), dev.getCreadoEn()));
    }

    @Transactional
    public void eliminarDesarrollador(Long id) {
        DesarrolladorToken desarrollador = (DesarrolladorToken)this.desarrolladorTokenRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Desarrollador no encontrado"));
        this.desarrolladorTokenRepository.delete((Object)desarrollador);
    }

    @Generated
    public TokenService(DesarrolladorTokenRepository desarrolladorTokenRepository, JwtProvider jwtProvider, BCryptPasswordEncoder passwordEncoder) {
        this.desarrolladorTokenRepository = desarrolladorTokenRepository;
        this.jwtProvider = jwtProvider;
        this.passwordEncoder = passwordEncoder;
    }
}

