/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.security.token.controller;

import com.dulcecontrol.bakery.security.JwtProvider;
import com.dulcecontrol.bakery.security.token.dto.TokenListResponse;
import com.dulcecontrol.bakery.security.token.dto.TokenLoginRequest;
import com.dulcecontrol.bakery.security.token.dto.TokenProfileResponse;
import com.dulcecontrol.bakery.security.token.dto.TokenRegisterRequest;
import com.dulcecontrol.bakery.security.token.dto.TokenResponse;
import com.dulcecontrol.bakery.security.token.service.ITokenService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/token"})
public class TokenController {
    private final ITokenService tokenService;
    private final JwtProvider jwtProvider;

    @PostMapping(value={"/register"})
    public ResponseEntity<TokenResponse> register(@Valid @RequestBody TokenRegisterRequest request) {
        String token = this.tokenService.register(request);
        TokenResponse response = new TokenResponse(token, "Bearer", this.jwtProvider.getExpirationTime());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<TokenResponse> login(@Valid @RequestBody TokenLoginRequest request) {
        String token = this.tokenService.login(request.getCorreo(), request.getContrasena());
        TokenResponse response = new TokenResponse(token, "Bearer", this.jwtProvider.getExpirationTime());
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<TokenProfileResponse> obtenerPerfil(Authentication authentication) {
        String correo = authentication.getName();
        TokenProfileResponse profile = this.tokenService.obtenerPerfil(correo);
        return ResponseEntity.ok((Object)profile);
    }

    @GetMapping
    public ResponseEntity<Page<TokenListResponse>> listarTodos(Pageable pageable) {
        Page desarrolladores = this.tokenService.listarTodos(pageable);
        return ResponseEntity.ok((Object)desarrolladores);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminarDesarrollador(@PathVariable Long id) {
        this.tokenService.eliminarDesarrollador(id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public TokenController(ITokenService tokenService, JwtProvider jwtProvider) {
        this.tokenService = tokenService;
        this.jwtProvider = jwtProvider;
    }
}

