/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.security.auth.service;

import com.dulcecontrol.bakery.features.admin.clientes.entity.Cliente;
import com.dulcecontrol.bakery.features.admin.clientes.repository.ClienteRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioTienda;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.storefront.auth.dto.ActivarCuentaRequest;
import com.dulcecontrol.bakery.features.storefront.auth.dto.VerificarEmailResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.UsuarioSuperadmin;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.UsuarioSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.Plan;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.Suscripcion;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.enums.EstadoSuscripcion;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.repository.SuscripcionRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.enums.EstadoTienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.TiendaRepository;
import com.dulcecontrol.bakery.security.JwtProvider;
import com.dulcecontrol.bakery.security.TipoUsuario;
import com.dulcecontrol.bakery.security.auth.dto.AdminLoginRequest;
import com.dulcecontrol.bakery.security.auth.dto.AuthTokenResponse;
import com.dulcecontrol.bakery.security.auth.dto.StorefrontLoginRequest;
import com.dulcecontrol.bakery.security.auth.dto.StorefrontRegisterRequest;
import com.dulcecontrol.bakery.security.auth.dto.SubscriptionStatusPayload;
import com.dulcecontrol.bakery.security.auth.dto.SuperadminLoginRequest;
import com.dulcecontrol.bakery.shared.exception.AuthenticationException;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceConflictException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuthService {
    private final UsuarioSuperadminRepository usuarioSuperadminRepository;
    private final UsuarioTiendaRepository usuarioTiendaRepository;
    private final ClienteRepository clienteRepository;
    private final SuscripcionRepository suscripcionRepository;
    private final TiendaRepository tiendaRepository;
    private final JwtProvider jwtProvider;
    private final BCryptPasswordEncoder passwordEncoder;
    private static final Set<EstadoSuscripcion> ESTADOS_VIGENTES = EnumSet.of(EstadoSuscripcion.EN_PRUEBA, EstadoSuscripcion.ACTIVA);

    public AuthTokenResponse loginSuperadmin(SuperadminLoginRequest request) {
        String email = this.normalizarCorreo(request.getEmail());
        UsuarioSuperadmin usuario = (UsuarioSuperadmin)this.usuarioSuperadminRepository.findByCorreo(email).orElseThrow(() -> new AuthenticationException("Credenciales inv\u00e1lidas"));
        if (!Boolean.TRUE.equals(usuario.getActivo())) {
            throw new AuthenticationException("Usuario inactivo");
        }
        this.validarPassword(request.getPassword(), usuario.getHashContrasena());
        String token = this.jwtProvider.generarToken(usuario.getCorreo(), "ROLE_SUPERADMIN", TipoUsuario.SUPERADMIN, null, this.construirClaimsNombre(usuario.getNombres()), usuario.getId());
        return this.buildResponse(token, TipoUsuario.SUPERADMIN, null, usuario.getId(), null);
    }

    @Transactional
    public AuthTokenResponse loginAdmin(AdminLoginRequest request) {
        String email = this.normalizarCorreo(request.getEmail());
        UsuarioTienda usuario = (UsuarioTienda)this.usuarioTiendaRepository.findByCorreo(email).orElseThrow(() -> new AuthenticationException("Credenciales inv\u00e1lidas"));
        if (!Boolean.TRUE.equals(usuario.getActivo())) {
            throw new AuthenticationException("Usuario inactivo");
        }
        this.validarPassword(request.getPassword(), usuario.getHashContrasena());
        this.validarTiendaHabilitada(usuario.getTiendaId());
        usuario.setUltimoAccesoEn(LocalDateTime.now());
        this.usuarioTiendaRepository.save((Object)usuario);
        Long tiendaId = usuario.getTiendaId();
        SubscriptionStatusPayload subscriptionStatus = this.obtenerSuscripcionActiva(tiendaId);
        String token = this.jwtProvider.generarToken(usuario.getCorreo(), "ROLE_ADMIN", TipoUsuario.ADMIN, tiendaId, this.construirClaimsNombre(usuario.getNombres()), usuario.getId());
        return this.buildResponse(token, TipoUsuario.ADMIN, tiendaId, usuario.getId(), subscriptionStatus);
    }

    public AuthTokenResponse loginStorefront(StorefrontLoginRequest request) {
        String email;
        Long tiendaId = request.getTiendaId();
        Cliente cliente = (Cliente)this.clienteRepository.findByTiendaIdAndEmail(tiendaId, email = this.normalizarCorreo(request.getEmail())).orElseThrow(() -> new AuthenticationException("Credenciales inv\u00e1lidas"));
        if (!Boolean.TRUE.equals(cliente.getActivo())) {
            throw new AuthenticationException("Usuario inactivo");
        }
        this.validarPassword(request.getPassword(), cliente.getHashContrasena());
        this.validarTiendaHabilitada(tiendaId);
        String token = this.jwtProvider.generarToken(cliente.getEmail(), "ROLE_CLIENTE", TipoUsuario.CLIENTE, tiendaId, this.construirClaimsNombre(cliente.getNombreDoc()), cliente.getId());
        return this.buildResponse(token, TipoUsuario.CLIENTE, tiendaId, cliente.getId(), null);
    }

    public AuthTokenResponse registerStorefront(StorefrontRegisterRequest request) {
        String email;
        Long tiendaId = request.getTiendaId();
        if (this.clienteRepository.findByTiendaIdAndEmail(tiendaId, email = this.normalizarCorreo(request.getEmail())).isPresent()) {
            throw new ResourceConflictException("Ya existe un usuario con este email");
        }
        Cliente cliente = new Cliente();
        cliente.setTiendaId(tiendaId);
        cliente.setNombreDoc(request.getNombreCompleto());
        cliente.setEmail(email);
        cliente.setTelefono(request.getTelefono());
        cliente.setEsUsuarioVirtual(Boolean.valueOf(true));
        cliente.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        cliente.setActivo(Boolean.valueOf(true));
        cliente = (Cliente)this.clienteRepository.save((Object)cliente);
        String token = this.jwtProvider.generarToken(cliente.getEmail(), "ROLE_CLIENTE", TipoUsuario.CLIENTE, tiendaId, this.construirClaimsNombre(cliente.getNombreDoc()), cliente.getId());
        return this.buildResponse(token, TipoUsuario.CLIENTE, tiendaId, cliente.getId(), null);
    }

    private void validarPassword(String rawPassword, String hash) {
        if (hash == null || !this.passwordEncoder.matches((CharSequence)rawPassword, hash)) {
            throw new AuthenticationException("Credenciales inv\u00e1lidas");
        }
    }

    private String normalizarCorreo(String email) {
        if (email == null) {
            return null;
        }
        return email.trim().toLowerCase();
    }

    private AuthTokenResponse buildResponse(String token, TipoUsuario tipoUsuario, Long tiendaId, Long userId, SubscriptionStatusPayload subscriptionStatus) {
        return AuthTokenResponse.builder().token(token).tokenType("Bearer").expiresIn(this.jwtProvider.getExpirationTime()).userType(tipoUsuario).tiendaId(tiendaId).userId(userId).subscriptionStatus(subscriptionStatus).build();
    }

    private Map<String, Object> construirClaimsNombre(String nombreCompleto) {
        if (nombreCompleto == null || nombreCompleto.isBlank()) {
            return null;
        }
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("nombre_completo", nombreCompleto.trim());
        return claims;
    }

    private SubscriptionStatusPayload obtenerSuscripcionActiva(Long tiendaId) {
        List suscripciones = this.suscripcionRepository.findByTiendaId(tiendaId);
        if (suscripciones.isEmpty()) {
            throw new AuthenticationException("No pudimos validar una suscripcion activa para tu tienda. Actualiza tu plan para continuar.");
        }
        suscripciones.sort(Comparator.comparing(Suscripcion::getFechaFin, Comparator.nullsLast(Comparator.naturalOrder())).reversed());
        LocalDateTime ahora = LocalDateTime.now();
        for (Suscripcion suscripcion : suscripciones) {
            LocalDateTime fechaFin;
            if (!ESTADOS_VIGENTES.contains(suscripcion.getEstado()) || (fechaFin = suscripcion.getFechaFin()) != null && fechaFin.isBefore(ahora)) continue;
            return this.buildSubscriptionStatusPayload(suscripcion, ahora);
        }
        Suscripcion masReciente = (Suscripcion)suscripciones.get(0);
        LocalDateTime fechaFin = masReciente.getFechaFin();
        if (fechaFin != null && fechaFin.isBefore(ahora)) {
            throw new AuthenticationException("No pudimos iniciar sesion porque la suscripcion de tu tienda esta vencida. Actualiza tu plan para continuar.");
        }
        EstadoSuscripcion estado = masReciente.getEstado();
        if (estado == EstadoSuscripcion.CANCELADA) {
            throw new AuthenticationException("No pudimos iniciar sesion porque la suscripcion de tu tienda fue cancelada. Actualiza tu plan o contacta a soporte.");
        }
        if (estado == EstadoSuscripcion.VENCIDA) {
            throw new AuthenticationException("No pudimos iniciar sesion porque la suscripcion de tu tienda esta vencida. Actualiza tu plan para continuar.");
        }
        throw new AuthenticationException("No encontramos una suscripcion activa para tu tienda. Actualiza tu plan para continuar.");
    }

    private SubscriptionStatusPayload buildSubscriptionStatusPayload(Suscripcion suscripcion, LocalDateTime referencia) {
        LocalDateTime fechaFin = suscripcion.getFechaFin();
        Long remainingSeconds = null;
        if (fechaFin != null) {
            long seconds = Duration.between(referencia, fechaFin).getSeconds();
            remainingSeconds = Math.max(seconds, 0L);
        }
        Plan plan = suscripcion.getPlan();
        return SubscriptionStatusPayload.builder().id(suscripcion.getId()).estado(suscripcion.getEstado() != null ? suscripcion.getEstado().name() : null).planNombre(plan != null ? plan.getNombre() : null).planId(plan != null ? plan.getId() : null).planCodigo(plan != null ? plan.getCodigo() : null).ciclo(suscripcion.getCiclo() != null ? suscripcion.getCiclo().name() : null).autorenovar(Boolean.valueOf(Boolean.TRUE.equals(suscripcion.getAutorenovar()))).fechaInicio(suscripcion.getFechaInicio()).fechaFin(fechaFin).remainingSeconds(remainingSeconds).enPeriodoPrueba(Boolean.valueOf(suscripcion.getEstado() == EstadoSuscripcion.EN_PRUEBA)).build();
    }

    public VerificarEmailResponse verificarEmail(Long tiendaId, String email) {
        String emailNormalizado = this.normalizarCorreo(email);
        return this.clienteRepository.findByTiendaIdAndEmail(tiendaId, emailNormalizado).map(cliente -> {
            if (Boolean.TRUE.equals(cliente.getEsUsuarioVirtual())) {
                return VerificarEmailResponse.builder().existe(true).esClienteFisico(false).mensaje("Este email ya est\u00e1 registrado como cliente virtual").build();
            }
            return VerificarEmailResponse.builder().existe(true).esClienteFisico(true).mensaje("Este email pertenece a un cliente f\u00edsico. Puedes activar tu cuenta.").build();
        }).orElse(VerificarEmailResponse.builder().existe(false).esClienteFisico(false).mensaje("Email disponible").build());
    }

    @Transactional
    public AuthTokenResponse activarCuenta(Long tiendaId, ActivarCuentaRequest request) {
        String emailNormalizado = this.normalizarCorreo(request.getEmail());
        Cliente cliente = (Cliente)this.clienteRepository.findByTiendaIdAndEmail(tiendaId, emailNormalizado).orElseThrow(() -> new BadRequestException("No existe un cliente con este email"));
        if (Boolean.TRUE.equals(cliente.getEsUsuarioVirtual())) {
            throw new BadRequestException("Esta cuenta ya est\u00e1 activada como virtual");
        }
        if (!request.getTipoDoc().equals(cliente.getTipoDoc().name())) {
            throw new BadRequestException("El tipo de documento no coincide con nuestros registros");
        }
        if (!request.getNumeroDoc().equals(cliente.getNumeroDoc())) {
            throw new BadRequestException("El n\u00famero de documento no coincide con nuestros registros");
        }
        cliente.setEsUsuarioVirtual(Boolean.valueOf(true));
        cliente.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getContrasena()));
        this.clienteRepository.save((Object)cliente);
        String token = this.jwtProvider.generarToken(cliente.getEmail(), "ROLE_CLIENTE", TipoUsuario.CLIENTE, tiendaId, this.construirClaimsNombre(cliente.getNombreDoc()), cliente.getId());
        return this.buildResponse(token, TipoUsuario.CLIENTE, tiendaId, cliente.getId(), null);
    }

    private void validarTiendaHabilitada(Long tiendaId) {
        Tienda tienda = (Tienda)this.tiendaRepository.findById((Object)tiendaId).orElseThrow(() -> new AuthenticationException("La tienda ya no est\u00e1 disponible"));
        if (tienda.getEstado() == EstadoTienda.CANCELADA) {
            throw new AuthenticationException("La tienda fue cancelada. Contacta a soporte para m\u00e1s informaci\u00f3n.");
        }
    }

    @Generated
    public AuthService(UsuarioSuperadminRepository usuarioSuperadminRepository, UsuarioTiendaRepository usuarioTiendaRepository, ClienteRepository clienteRepository, SuscripcionRepository suscripcionRepository, TiendaRepository tiendaRepository, JwtProvider jwtProvider, BCryptPasswordEncoder passwordEncoder) {
        this.usuarioSuperadminRepository = usuarioSuperadminRepository;
        this.usuarioTiendaRepository = usuarioTiendaRepository;
        this.clienteRepository = clienteRepository;
        this.suscripcionRepository = suscripcionRepository;
        this.tiendaRepository = tiendaRepository;
        this.jwtProvider = jwtProvider;
        this.passwordEncoder = passwordEncoder;
    }
}

