/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.service.impl;

import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.DominioCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.DominioResponse;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.DominioUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.DominioTienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.DominioTiendaRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.TiendaRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.service.IDominioSuperAdminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DominioSuperAdminService
implements IDominioSuperAdminService {
    private final DominioTiendaRepository dominioRepository;
    private final TiendaRepository tiendaRepository;

    @Transactional(readOnly=true)
    public List<DominioResponse> listarPorTienda(Long tiendaId) {
        this.validarTiendaExiste(tiendaId);
        return this.dominioRepository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public DominioResponse obtenerPorId(Long tiendaId, Long dominioId) {
        DominioTienda dominio = this.obtenerDominio(tiendaId, dominioId);
        return this.toResponse(dominio);
    }

    @Transactional
    public DominioResponse crear(Long tiendaId, DominioCreateRequest request) {
        Tienda tienda = this.obtenerTienda(tiendaId);
        String dominioNormalizado = this.normalizarDominio(request.getUrlDominio());
        this.validarUrlDisponible(dominioNormalizado, null);
        DominioTienda dominio = DominioTienda.builder().tienda(tienda).tipo(request.getTipo()).urlDominio(dominioNormalizado).urlLogo(this.normalizarUrl(request.getUrlLogo())).urlFavicon(this.normalizarUrl(request.getUrlFavicon())).colorPrimario(this.normalizarColor(request.getColorPrimario(), "#000000")).colorSecundario(this.normalizarColor(request.getColorSecundario(), "#FFFFFF")).build();
        DominioTienda guardado = (DominioTienda)this.dominioRepository.save((Object)dominio);
        return this.toResponse(guardado);
    }

    @Transactional
    public DominioResponse actualizar(Long tiendaId, Long dominioId, DominioUpdateRequest request) {
        DominioTienda dominio = this.obtenerDominio(tiendaId, dominioId);
        String dominioNormalizado = this.normalizarDominio(request.getUrlDominio());
        this.validarUrlDisponible(dominioNormalizado, dominioId);
        dominio.setTipo(request.getTipo());
        dominio.setUrlDominio(dominioNormalizado);
        dominio.setUrlLogo(this.normalizarUrl(request.getUrlLogo()));
        dominio.setUrlFavicon(this.normalizarUrl(request.getUrlFavicon()));
        dominio.setColorPrimario(this.normalizarColor(request.getColorPrimario(), "#000000"));
        dominio.setColorSecundario(this.normalizarColor(request.getColorSecundario(), "#FFFFFF"));
        DominioTienda actualizado = (DominioTienda)this.dominioRepository.save((Object)dominio);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long dominioId) {
        DominioTienda dominio = this.obtenerDominio(tiendaId, dominioId);
        this.dominioRepository.delete((Object)dominio);
    }

    private DominioTienda obtenerDominio(Long tiendaId, Long dominioId) {
        return (DominioTienda)this.dominioRepository.findByIdAndTiendaId(dominioId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("El dominio solicitado no existe para la tienda indicada"));
    }

    private Tienda obtenerTienda(Long tiendaId) {
        return (Tienda)this.tiendaRepository.findById((Object)tiendaId).orElseThrow(() -> new ResourceNotFoundException("La tienda indicada no existe"));
    }

    private void validarTiendaExiste(Long tiendaId) {
        if (!this.tiendaRepository.existsById((Object)tiendaId)) {
            throw new ResourceNotFoundException("La tienda indicada no existe");
        }
    }

    private void validarUrlDisponible(String urlDominio, Long dominioId) {
        boolean ocupado;
        boolean bl = ocupado = dominioId == null ? this.dominioRepository.existsByUrlDominio(urlDominio) : this.dominioRepository.existsByUrlDominioAndIdNot(urlDominio, dominioId);
        if (ocupado) {
            throw new BadRequestException("La URL de dominio ya est\u00e1 registrada en otra tienda");
        }
    }

    private DominioResponse toResponse(DominioTienda dominio) {
        return DominioResponse.builder().id(dominio.getId()).tiendaId(dominio.getTienda().getId()).tipo(dominio.getTipo()).urlDominio(dominio.getUrlDominio()).urlLogo(dominio.getUrlLogo()).urlFavicon(dominio.getUrlFavicon()).colorPrimario(dominio.getColorPrimario()).colorSecundario(dominio.getColorSecundario()).creadoEn(dominio.getCreadoEn()).actualizadoEn(dominio.getActualizadoEn()).build();
    }

    private String normalizarDominio(String dominio) {
        if (dominio == null) {
            return null;
        }
        String normalizado = dominio.trim().toLowerCase();
        if (normalizado.startsWith("http://")) {
            normalizado = normalizado.substring(7);
        } else if (normalizado.startsWith("https://")) {
            normalizado = normalizado.substring(8);
        }
        if (normalizado.endsWith("/")) {
            normalizado = normalizado.substring(0, normalizado.length() - 1);
        }
        return normalizado;
    }

    private String normalizarUrl(String url) {
        return url == null ? null : url.trim();
    }

    private String normalizarColor(String color, String valorPorDefecto) {
        if (color == null || color.isBlank()) {
            return valorPorDefecto;
        }
        Object normalizado = color.trim();
        if (!((String)normalizado).startsWith("#")) {
            normalizado = "#" + (String)normalizado;
        }
        return ((String)normalizado).toUpperCase();
    }

    @Generated
    public DominioSuperAdminService(DominioTiendaRepository dominioRepository, TiendaRepository tiendaRepository) {
        this.dominioRepository = dominioRepository;
        this.tiendaRepository = tiendaRepository;
    }
}

