/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.entity;

import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.DominioTienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.enums.TipoDominioTienda;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="dominios_tienda")
public class DominioTienda {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="tienda_id", nullable=false)
    private Tienda tienda;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, length=20)
    private TipoDominioTienda tipo;
    @Column(name="url_dominio", nullable=false, unique=true, length=255)
    private String urlDominio;
    @Column(name="url_logo", columnDefinition="TEXT")
    private String urlLogo;
    @Column(name="url_favicon", columnDefinition="TEXT")
    private String urlFavicon;
    @Column(name="color_primario", nullable=false, length=7)
    private String colorPrimario;
    @Column(name="color_secundario", nullable=false, length=7)
    private String colorSecundario;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        LocalDateTime now;
        this.creadoEn = now = LocalDateTime.now();
        this.actualizadoEn = now;
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public static DominioTiendaBuilder builder() {
        return new DominioTiendaBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Tienda getTienda() {
        return this.tienda;
    }

    @Generated
    public TipoDominioTienda getTipo() {
        return this.tipo;
    }

    @Generated
    public String getUrlDominio() {
        return this.urlDominio;
    }

    @Generated
    public String getUrlLogo() {
        return this.urlLogo;
    }

    @Generated
    public String getUrlFavicon() {
        return this.urlFavicon;
    }

    @Generated
    public String getColorPrimario() {
        return this.colorPrimario;
    }

    @Generated
    public String getColorSecundario() {
        return this.colorSecundario;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTienda(Tienda tienda) {
        this.tienda = tienda;
    }

    @Generated
    public void setTipo(TipoDominioTienda tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setUrlDominio(String urlDominio) {
        this.urlDominio = urlDominio;
    }

    @Generated
    public void setUrlLogo(String urlLogo) {
        this.urlLogo = urlLogo;
    }

    @Generated
    public void setUrlFavicon(String urlFavicon) {
        this.urlFavicon = urlFavicon;
    }

    @Generated
    public void setColorPrimario(String colorPrimario) {
        this.colorPrimario = colorPrimario;
    }

    @Generated
    public void setColorSecundario(String colorSecundario) {
        this.colorSecundario = colorSecundario;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public DominioTienda() {
    }

    @Generated
    public DominioTienda(Long id, Tienda tienda, TipoDominioTienda tipo, String urlDominio, String urlLogo, String urlFavicon, String colorPrimario, String colorSecundario, LocalDateTime creadoEn, LocalDateTime actualizadoEn) {
        this.id = id;
        this.tienda = tienda;
        this.tipo = tipo;
        this.urlDominio = urlDominio;
        this.urlLogo = urlLogo;
        this.urlFavicon = urlFavicon;
        this.colorPrimario = colorPrimario;
        this.colorSecundario = colorSecundario;
        this.creadoEn = creadoEn;
        this.actualizadoEn = actualizadoEn;
    }
}

