/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.controller;

import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.TiendaCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.TiendaResponse;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.TiendaUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.service.ITiendaSuperAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/tiendas"})
@Validated
public class TiendaSuperAdminController {
    private final ITiendaSuperAdminService tiendaService;

    @GetMapping
    public ResponseEntity<List<TiendaResponse>> listar() {
        return ResponseEntity.ok((Object)this.tiendaService.listar());
    }

    @GetMapping(value={"/{tiendaId}"})
    public ResponseEntity<TiendaResponse> obtener(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.tiendaService.obtenerPorId(tiendaId));
    }

    @PostMapping
    public ResponseEntity<TiendaResponse> crear(@Valid @RequestBody TiendaCreateRequest request) {
        TiendaResponse response = this.tiendaService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{tiendaId}"})
    public ResponseEntity<TiendaResponse> actualizar(@PathVariable Long tiendaId, @Valid @RequestBody TiendaUpdateRequest request) {
        TiendaResponse response = this.tiendaService.actualizar(tiendaId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{tiendaId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId) {
        this.tiendaService.eliminar(tiendaId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public TiendaSuperAdminController(ITiendaSuperAdminService tiendaService) {
        this.tiendaService = tiendaService;
    }
}

