/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.controller;

import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.DominioCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.DominioResponse;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.DominioUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.service.IDominioSuperAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/tiendas/{tiendaId}/dominios"})
@Validated
public class DominioSuperAdminController {
    private final IDominioSuperAdminService dominioService;

    @GetMapping
    public ResponseEntity<List<DominioResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.dominioService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/{dominioId}"})
    public ResponseEntity<DominioResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long dominioId) {
        return ResponseEntity.ok((Object)this.dominioService.obtenerPorId(tiendaId, dominioId));
    }

    @PostMapping
    public ResponseEntity<DominioResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody DominioCreateRequest request) {
        DominioResponse response = this.dominioService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{dominioId}"})
    public ResponseEntity<DominioResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long dominioId, @Valid @RequestBody DominioUpdateRequest request) {
        DominioResponse response = this.dominioService.actualizar(tiendaId, dominioId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{dominioId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long dominioId) {
        this.dominioService.eliminar(tiendaId, dominioId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public DominioSuperAdminController(IDominioSuperAdminService dominioService) {
        this.dominioService = dominioService;
    }
}

