/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.suscripciones.entity;

import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.Plan;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.enums.CicloSuscripcion;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.enums.EstadoSuscripcion;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="suscripciones")
public class Suscripcion {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="plan_id", nullable=false)
    private Plan plan;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, columnDefinition="ENUM('mensual','anual')")
    private CicloSuscripcion ciclo = CicloSuscripcion.MENSUAL;
    @Column(name="precio_pactado_centimos", nullable=false)
    private Long precioPactadoCentimos;
    @Column(name="fecha_inicio", nullable=false)
    private LocalDateTime fechaInicio;
    @Column(name="fecha_fin", nullable=false)
    private LocalDateTime fechaFin;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, columnDefinition="ENUM('en_prueba','activa','vencida','cancelada')")
    private EstadoSuscripcion estado = EstadoSuscripcion.EN_PRUEBA;
    @Column(nullable=false)
    private Boolean autorenovar = Boolean.TRUE;
    @Column(name="cancelado_en")
    private LocalDateTime canceladoEn;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        LocalDateTime ahora = LocalDateTime.now();
        if (this.fechaInicio == null) {
            this.fechaInicio = ahora;
        }
        this.creadoEn = ahora;
        this.actualizadoEn = ahora;
        if (this.autorenovar == null) {
            this.autorenovar = Boolean.TRUE;
        }
        if (this.estado == null) {
            this.estado = EstadoSuscripcion.EN_PRUEBA;
        }
        if (this.ciclo == null) {
            this.ciclo = CicloSuscripcion.MENSUAL;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Plan getPlan() {
        return this.plan;
    }

    @Generated
    public CicloSuscripcion getCiclo() {
        return this.ciclo;
    }

    @Generated
    public Long getPrecioPactadoCentimos() {
        return this.precioPactadoCentimos;
    }

    @Generated
    public LocalDateTime getFechaInicio() {
        return this.fechaInicio;
    }

    @Generated
    public LocalDateTime getFechaFin() {
        return this.fechaFin;
    }

    @Generated
    public EstadoSuscripcion getEstado() {
        return this.estado;
    }

    @Generated
    public Boolean getAutorenovar() {
        return this.autorenovar;
    }

    @Generated
    public LocalDateTime getCanceladoEn() {
        return this.canceladoEn;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Generated
    public void setCiclo(CicloSuscripcion ciclo) {
        this.ciclo = ciclo;
    }

    @Generated
    public void setPrecioPactadoCentimos(Long precioPactadoCentimos) {
        this.precioPactadoCentimos = precioPactadoCentimos;
    }

    @Generated
    public void setFechaInicio(LocalDateTime fechaInicio) {
        this.fechaInicio = fechaInicio;
    }

    @Generated
    public void setFechaFin(LocalDateTime fechaFin) {
        this.fechaFin = fechaFin;
    }

    @Generated
    public void setEstado(EstadoSuscripcion estado) {
        this.estado = estado;
    }

    @Generated
    public void setAutorenovar(Boolean autorenovar) {
        this.autorenovar = autorenovar;
    }

    @Generated
    public void setCanceladoEn(LocalDateTime canceladoEn) {
        this.canceladoEn = canceladoEn;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }
}

