/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.suscripciones.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="planes")
public class Plan {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, unique=true, length=50)
    private String codigo;
    @Column(nullable=false, length=100)
    private String nombre;
    @Column(columnDefinition="TEXT")
    private String descripcion;
    @Column(name="precio_mensual_centimos", nullable=false)
    private Long precioMensualCentimos;
    @Column(name="precio_anual_centimos", nullable=false)
    private Long precioAnualCentimos;
    @Column(name="moneda", columnDefinition="char(3)")
    private String moneda = "PEN";
    @Column(name="limites", nullable=false, columnDefinition="JSON")
    private String limitesJson;
    @Column(nullable=false)
    private Boolean activo = Boolean.TRUE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        LocalDateTime ahora;
        this.creadoEn = ahora = LocalDateTime.now();
        this.actualizadoEn = ahora;
        if (this.activo == null) {
            this.activo = Boolean.TRUE;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public Long getPrecioMensualCentimos() {
        return this.precioMensualCentimos;
    }

    @Generated
    public Long getPrecioAnualCentimos() {
        return this.precioAnualCentimos;
    }

    @Generated
    public String getMoneda() {
        return this.moneda;
    }

    @Generated
    public String getLimitesJson() {
        return this.limitesJson;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setPrecioMensualCentimos(Long precioMensualCentimos) {
        this.precioMensualCentimos = precioMensualCentimos;
    }

    @Generated
    public void setPrecioAnualCentimos(Long precioAnualCentimos) {
        this.precioAnualCentimos = precioAnualCentimos;
    }

    @Generated
    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    @Generated
    public void setLimitesJson(String limitesJson) {
        this.limitesJson = limitesJson;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }
}

