/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.suscripciones.controller;

import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.SuscripcionCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.SuscripcionResponse;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.SuscripcionUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.enums.EstadoSuscripcion;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.service.ISuscripcionSuperadminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/suscripciones"})
@Validated
public class SuscripcionSuperadminController {
    private final ISuscripcionSuperadminService suscripcionService;

    @GetMapping
    public ResponseEntity<List<SuscripcionResponse>> listar(@RequestParam(name="tiendaId", required=false) Long tiendaId, @RequestParam(name="estado", required=false) EstadoSuscripcion estado) {
        return ResponseEntity.ok((Object)this.suscripcionService.listar(tiendaId, estado));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<SuscripcionResponse> obtener(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.suscripcionService.obtener(id));
    }

    @PostMapping
    public ResponseEntity<SuscripcionResponse> crear(@Valid @RequestBody SuscripcionCreateRequest request) {
        SuscripcionResponse response = this.suscripcionService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<SuscripcionResponse> actualizar(@PathVariable Long id, @Valid @RequestBody SuscripcionUpdateRequest request) {
        return ResponseEntity.ok((Object)this.suscripcionService.actualizar(id, request));
    }

    @Generated
    public SuscripcionSuperadminController(ISuscripcionSuperadminService suscripcionService) {
        this.suscripcionService = suscripcionService;
    }
}

