/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.soporte.service.impl;

import com.dulcecontrol.bakery.features.superadmin.soporte.dto.TicketCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.soporte.dto.TicketResponse;
import com.dulcecontrol.bakery.features.superadmin.soporte.dto.TicketUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.TicketSoporte;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.enums.EstadoTicket;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.enums.PrioridadTicket;
import com.dulcecontrol.bakery.features.superadmin.soporte.repository.TicketSoporteRepository;
import com.dulcecontrol.bakery.features.superadmin.soporte.service.ITicketSoporteService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TicketSoporteService
implements ITicketSoporteService {
    private final TicketSoporteRepository ticketRepository;

    @Transactional(readOnly=true)
    public List<TicketResponse> listar(Long tiendaId, EstadoTicket estado, PrioridadTicket prioridad) {
        List items = this.ticketRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creadoEn"}));
        return items.stream().filter(ticket -> tiendaId == null || Objects.equals(ticket.getTiendaId(), tiendaId)).filter(ticket -> estado == null || ticket.getEstado() == estado).filter(ticket -> prioridad == null || ticket.getPrioridad() == prioridad).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public TicketResponse obtener(Long id) {
        TicketSoporte t = (TicketSoporte)this.ticketRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Ticket no encontrado"));
        return this.toResponse(t);
    }

    @Transactional
    public TicketResponse crear(TicketCreateRequest request) {
        TicketSoporte t = new TicketSoporte();
        t.setTiendaId(request.getTiendaId());
        t.setAsignadoAId(request.getAsignadoAId());
        t.setAsunto(request.getAsunto());
        t.setPrioridad(request.getPrioridad());
        TicketSoporte saved = (TicketSoporte)this.ticketRepository.save((Object)t);
        return this.toResponse(saved);
    }

    @Transactional
    public TicketResponse actualizar(Long id, TicketUpdateRequest request) {
        TicketSoporte t = (TicketSoporte)this.ticketRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Ticket no encontrado"));
        if (request.getAsignadoAId() != null) {
            t.setAsignadoAId(request.getAsignadoAId());
        }
        if (request.getPrioridad() != null) {
            t.setPrioridad(request.getPrioridad());
        }
        if (request.getEstado() != null) {
            t.setEstado(request.getEstado());
        }
        TicketSoporte updated = (TicketSoporte)this.ticketRepository.save((Object)t);
        return this.toResponse(updated);
    }

    @Transactional
    public void eliminar(Long id) {
        TicketSoporte t = (TicketSoporte)this.ticketRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Ticket no encontrado"));
        this.ticketRepository.delete((Object)t);
    }

    private TicketResponse toResponse(TicketSoporte t) {
        return TicketResponse.builder().id(t.getId()).tiendaId(t.getTiendaId()).asignadoAId(t.getAsignadoAId()).asunto(t.getAsunto()).prioridad(t.getPrioridad()).estado(t.getEstado()).vencimientoSlaEn(t.getVencimientoSlaEn()).primeraRespuestaEn(t.getPrimeraRespuestaEn()).resueltoEn(t.getResueltoEn()).creadoEn(t.getCreadoEn()).actualizadoEn(t.getActualizadoEn()).build();
    }

    @Generated
    public TicketSoporteService(TicketSoporteRepository ticketRepository) {
        this.ticketRepository = ticketRepository;
    }
}

