/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.soporte.service.impl;

import com.dulcecontrol.bakery.features.superadmin.soporte.dto.MensajeCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.soporte.dto.MensajeResponse;
import com.dulcecontrol.bakery.features.superadmin.soporte.dto.MensajeUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.MensajeTicket;
import com.dulcecontrol.bakery.features.superadmin.soporte.repository.MensajeTicketRepository;
import com.dulcecontrol.bakery.features.superadmin.soporte.service.IMensajeTicketService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MensajeTicketService
implements IMensajeTicketService {
    private final MensajeTicketRepository mensajeRepository;

    @Transactional(readOnly=true)
    public List<MensajeResponse> listarPorTicket(Long ticketId) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        boolean isSuperadmin = auth != null && auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_SUPERADMIN"));
        return this.mensajeRepository.findByTicketIdOrderByCreadoEnAsc(ticketId).stream().filter(m -> isSuperadmin || !Boolean.TRUE.equals(m.getEsNotaInterna())).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<MensajeResponse> listarTodos() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        boolean isSuperadmin = auth != null && auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_SUPERADMIN"));
        return this.mensajeRepository.findAll().stream().filter(m -> isSuperadmin || !Boolean.TRUE.equals(m.getEsNotaInterna())).map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional
    public MensajeResponse crear(MensajeCreateRequest request) {
        MensajeTicket m = new MensajeTicket();
        m.setTicketId(request.getTicketId());
        m.setTipoRemitente(request.getTipoRemitente());
        m.setAutorAdminId(request.getAutorAdminId());
        m.setMensaje(request.getMensaje());
        m.setEsNotaInterna(Boolean.valueOf(Boolean.TRUE.equals(request.getEsNotaInterna())));
        MensajeTicket saved = (MensajeTicket)this.mensajeRepository.save((Object)m);
        return this.toResponse(saved);
    }

    @Transactional(readOnly=true)
    public MensajeResponse obtener(Long id) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        boolean isSuperadmin = auth != null && auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_SUPERADMIN"));
        MensajeTicket m = (MensajeTicket)this.mensajeRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Mensaje no encontrado"));
        if (!isSuperadmin && Boolean.TRUE.equals(m.getEsNotaInterna())) {
            throw new ResourceNotFoundException("Mensaje no encontrado");
        }
        return this.toResponse(m);
    }

    @Transactional
    public MensajeResponse actualizar(Long id, MensajeUpdateRequest request) {
        MensajeTicket m = (MensajeTicket)this.mensajeRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Mensaje no encontrado"));
        if (request.getMensaje() != null) {
            m.setMensaje(request.getMensaje());
        }
        if (request.getEsNotaInterna() != null) {
            m.setEsNotaInterna(request.getEsNotaInterna());
        }
        MensajeTicket updated = (MensajeTicket)this.mensajeRepository.save((Object)m);
        return this.toResponse(updated);
    }

    @Transactional
    public void eliminar(Long id) {
        MensajeTicket m = (MensajeTicket)this.mensajeRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Mensaje no encontrado"));
        this.mensajeRepository.delete((Object)m);
    }

    private MensajeResponse toResponse(MensajeTicket m) {
        return MensajeResponse.builder().id(m.getId()).ticketId(m.getTicketId()).tipoRemitente(m.getTipoRemitente()).autorAdminId(m.getAutorAdminId()).mensaje(m.getMensaje()).esNotaInterna(m.getEsNotaInterna()).leidoEn(m.getLeidoEn()).creadoEn(m.getCreadoEn()).build();
    }

    @Generated
    public MensajeTicketService(MensajeTicketRepository mensajeRepository) {
        this.mensajeRepository = mensajeRepository;
    }
}

