/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.soporte.entity;

import com.dulcecontrol.bakery.features.superadmin.soporte.entity.converter.EstadoTicketConverter;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.converter.PrioridadTicketConverter;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.enums.EstadoTicket;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.enums.PrioridadTicket;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="tickets_soporte")
public class TicketSoporte {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="asignado_a_id")
    private Long asignadoAId;
    @Column(nullable=false, length=255)
    private String asunto;
    @Convert(converter=PrioridadTicketConverter.class)
    @Column(name="prioridad", nullable=false, columnDefinition="ENUM('baja','media','alta','critica')")
    private PrioridadTicket prioridad = PrioridadTicket.media;
    @Convert(converter=EstadoTicketConverter.class)
    @Column(name="estado", nullable=false, columnDefinition="ENUM('abierto','pendiente_cliente','resuelto','cerrado')")
    private EstadoTicket estado = EstadoTicket.abierto;
    @Column(name="vencimiento_sla_en")
    private LocalDateTime vencimientoSlaEn;
    @Column(name="primera_respuesta_en")
    private LocalDateTime primeraRespuestaEn;
    @Column(name="resuelto_en")
    private LocalDateTime resueltoEn;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        this.actualizadoEn = LocalDateTime.now();
        if (this.prioridad == null) {
            this.prioridad = PrioridadTicket.media;
        }
        if (this.estado == null) {
            this.estado = EstadoTicket.abierto;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public TicketSoporte() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getAsignadoAId() {
        return this.asignadoAId;
    }

    @Generated
    public String getAsunto() {
        return this.asunto;
    }

    @Generated
    public PrioridadTicket getPrioridad() {
        return this.prioridad;
    }

    @Generated
    public EstadoTicket getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getVencimientoSlaEn() {
        return this.vencimientoSlaEn;
    }

    @Generated
    public LocalDateTime getPrimeraRespuestaEn() {
        return this.primeraRespuestaEn;
    }

    @Generated
    public LocalDateTime getResueltoEn() {
        return this.resueltoEn;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setAsignadoAId(Long asignadoAId) {
        this.asignadoAId = asignadoAId;
    }

    @Generated
    public void setAsunto(String asunto) {
        this.asunto = asunto;
    }

    @Generated
    public void setPrioridad(PrioridadTicket prioridad) {
        this.prioridad = prioridad;
    }

    @Generated
    public void setEstado(EstadoTicket estado) {
        this.estado = estado;
    }

    @Generated
    public void setVencimientoSlaEn(LocalDateTime vencimientoSlaEn) {
        this.vencimientoSlaEn = vencimientoSlaEn;
    }

    @Generated
    public void setPrimeraRespuestaEn(LocalDateTime primeraRespuestaEn) {
        this.primeraRespuestaEn = primeraRespuestaEn;
    }

    @Generated
    public void setResueltoEn(LocalDateTime resueltoEn) {
        this.resueltoEn = resueltoEn;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TicketSoporte)) {
            return false;
        }
        TicketSoporte other = (TicketSoporte)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Long this$asignadoAId = this.getAsignadoAId();
        Long other$asignadoAId = other.getAsignadoAId();
        if (this$asignadoAId == null ? other$asignadoAId != null : !((Object)this$asignadoAId).equals(other$asignadoAId)) {
            return false;
        }
        String this$asunto = this.getAsunto();
        String other$asunto = other.getAsunto();
        if (this$asunto == null ? other$asunto != null : !this$asunto.equals(other$asunto)) {
            return false;
        }
        PrioridadTicket this$prioridad = this.getPrioridad();
        PrioridadTicket other$prioridad = other.getPrioridad();
        if (this$prioridad == null ? other$prioridad != null : !this$prioridad.equals(other$prioridad)) {
            return false;
        }
        EstadoTicket this$estado = this.getEstado();
        EstadoTicket other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        LocalDateTime this$vencimientoSlaEn = this.getVencimientoSlaEn();
        LocalDateTime other$vencimientoSlaEn = other.getVencimientoSlaEn();
        if (this$vencimientoSlaEn == null ? other$vencimientoSlaEn != null : !((Object)this$vencimientoSlaEn).equals(other$vencimientoSlaEn)) {
            return false;
        }
        LocalDateTime this$primeraRespuestaEn = this.getPrimeraRespuestaEn();
        LocalDateTime other$primeraRespuestaEn = other.getPrimeraRespuestaEn();
        if (this$primeraRespuestaEn == null ? other$primeraRespuestaEn != null : !((Object)this$primeraRespuestaEn).equals(other$primeraRespuestaEn)) {
            return false;
        }
        LocalDateTime this$resueltoEn = this.getResueltoEn();
        LocalDateTime other$resueltoEn = other.getResueltoEn();
        if (this$resueltoEn == null ? other$resueltoEn != null : !((Object)this$resueltoEn).equals(other$resueltoEn)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        if (this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn)) {
            return false;
        }
        LocalDateTime this$actualizadoEn = this.getActualizadoEn();
        LocalDateTime other$actualizadoEn = other.getActualizadoEn();
        return !(this$actualizadoEn == null ? other$actualizadoEn != null : !((Object)this$actualizadoEn).equals(other$actualizadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TicketSoporte;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Long $asignadoAId = this.getAsignadoAId();
        result = result * 59 + ($asignadoAId == null ? 43 : ((Object)$asignadoAId).hashCode());
        String $asunto = this.getAsunto();
        result = result * 59 + ($asunto == null ? 43 : $asunto.hashCode());
        PrioridadTicket $prioridad = this.getPrioridad();
        result = result * 59 + ($prioridad == null ? 43 : $prioridad.hashCode());
        EstadoTicket $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        LocalDateTime $vencimientoSlaEn = this.getVencimientoSlaEn();
        result = result * 59 + ($vencimientoSlaEn == null ? 43 : ((Object)$vencimientoSlaEn).hashCode());
        LocalDateTime $primeraRespuestaEn = this.getPrimeraRespuestaEn();
        result = result * 59 + ($primeraRespuestaEn == null ? 43 : ((Object)$primeraRespuestaEn).hashCode());
        LocalDateTime $resueltoEn = this.getResueltoEn();
        result = result * 59 + ($resueltoEn == null ? 43 : ((Object)$resueltoEn).hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        LocalDateTime $actualizadoEn = this.getActualizadoEn();
        result = result * 59 + ($actualizadoEn == null ? 43 : ((Object)$actualizadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TicketSoporte(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", asignadoAId=" + this.getAsignadoAId() + ", asunto=" + this.getAsunto() + ", prioridad=" + String.valueOf(this.getPrioridad()) + ", estado=" + String.valueOf(this.getEstado()) + ", vencimientoSlaEn=" + String.valueOf(this.getVencimientoSlaEn()) + ", primeraRespuestaEn=" + String.valueOf(this.getPrimeraRespuestaEn()) + ", resueltoEn=" + String.valueOf(this.getResueltoEn()) + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ", actualizadoEn=" + String.valueOf(this.getActualizadoEn()) + ")";
    }
}

