/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.soporte.controller;

import com.dulcecontrol.bakery.features.superadmin.soporte.dto.TicketCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.soporte.dto.TicketResponse;
import com.dulcecontrol.bakery.features.superadmin.soporte.dto.TicketUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.enums.EstadoTicket;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.enums.PrioridadTicket;
import com.dulcecontrol.bakery.features.superadmin.soporte.service.ITicketSoporteService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/soporte/tickets"})
@Validated
public class TicketSoporteController {
    private final ITicketSoporteService ticketService;

    @GetMapping
    public ResponseEntity<List<TicketResponse>> listar(@RequestParam(required=false) Long tiendaId, @RequestParam(required=false) EstadoTicket estado, @RequestParam(required=false) PrioridadTicket prioridad) {
        return ResponseEntity.ok((Object)this.ticketService.listar(tiendaId, estado, prioridad));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TicketResponse> obtener(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.ticketService.obtener(id));
    }

    @PostMapping
    public ResponseEntity<TicketResponse> crear(@Valid @RequestBody TicketCreateRequest request) {
        TicketResponse response = this.ticketService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<TicketResponse> actualizar(@PathVariable Long id, @Valid @RequestBody TicketUpdateRequest request) {
        return ResponseEntity.ok((Object)this.ticketService.actualizar(id, request));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long id) {
        this.ticketService.eliminar(id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public TicketSoporteController(ITicketSoporteService ticketService) {
        this.ticketService = ticketService;
    }
}

