/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.soporte.controller;

import com.dulcecontrol.bakery.features.superadmin.soporte.dto.MensajeCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.soporte.dto.MensajeResponse;
import com.dulcecontrol.bakery.features.superadmin.soporte.dto.MensajeUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.soporte.service.IMensajeTicketService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/soporte"})
@Validated
public class MensajeTicketController {
    private final IMensajeTicketService mensajeService;

    @GetMapping(value={"/mensajes"})
    public ResponseEntity<List<MensajeResponse>> listar(@RequestParam(required=false) Long ticketId) {
        if (ticketId != null) {
            return ResponseEntity.ok((Object)this.mensajeService.listarPorTicket(ticketId));
        }
        return ResponseEntity.ok((Object)this.mensajeService.listarTodos());
    }

    @GetMapping(value={"/mensajes/{id}"})
    public ResponseEntity<MensajeResponse> obtener(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.mensajeService.obtener(id));
    }

    @PostMapping(value={"/mensajes"})
    public ResponseEntity<MensajeResponse> crear(@Valid @RequestBody MensajeCreateRequest request) {
        MensajeResponse response = this.mensajeService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/mensajes/{id}"})
    public ResponseEntity<MensajeResponse> actualizar(@PathVariable Long id, @Valid @RequestBody MensajeUpdateRequest request) {
        return ResponseEntity.ok((Object)this.mensajeService.actualizar(id, request));
    }

    @DeleteMapping(value={"/mensajes/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long id) {
        this.mensajeService.eliminar(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/tickets/{ticketId}/mensajes"})
    public ResponseEntity<List<MensajeResponse>> listarPorTicketPath(@PathVariable Long ticketId) {
        return ResponseEntity.ok((Object)this.mensajeService.listarPorTicket(ticketId));
    }

    @Generated
    public MensajeTicketController(IMensajeTicketService mensajeService) {
        this.mensajeService = mensajeService;
    }
}

