/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.service.impl;

import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.RolSuperadminCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.RolSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.RolSuperadminUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.PermisoSuperadmin;
import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.RolSuperadmin;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.PermisoSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.RolSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.UsuarioSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.service.IRolSuperadminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RolSuperadminService
implements IRolSuperadminService {
    private final RolSuperadminRepository rolRepository;
    private final PermisoSuperadminRepository permisoRepository;
    private final UsuarioSuperadminRepository usuarioRepository;

    @Transactional(readOnly=true)
    public List<RolSuperadminResponse> listar() {
        return this.rolRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"nombre"})).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public RolSuperadminResponse obtener(Long id) {
        RolSuperadmin rol = (RolSuperadmin)this.rolRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Rol superadmin no encontrado"));
        return this.toResponse(rol);
    }

    @Transactional
    public RolSuperadminResponse crear(RolSuperadminCreateRequest request) {
        String nombreNormalizado = request.getNombre().trim();
        if (this.rolRepository.existsByNombreIgnoreCase(nombreNormalizado)) {
            throw new BadRequestException("Ya existe un rol con el mismo nombre");
        }
        Set permisos = this.resolverPermisos(request.getPermisos(), true);
        RolSuperadmin rol = new RolSuperadmin();
        rol.setNombre(nombreNormalizado);
        rol.setDescripcion(this.limpiar(request.getDescripcion()));
        rol.setPermisos(new HashSet(permisos));
        RolSuperadmin guardado = (RolSuperadmin)this.rolRepository.save((Object)rol);
        return this.toResponse(guardado);
    }

    @Transactional
    public RolSuperadminResponse actualizar(Long id, RolSuperadminUpdateRequest request) {
        boolean nombreCambio;
        RolSuperadmin rol = (RolSuperadmin)this.rolRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Rol superadmin no encontrado"));
        String nombreNormalizado = request.getNombre().trim();
        boolean bl = nombreCambio = !rol.getNombre().equalsIgnoreCase(nombreNormalizado);
        if (nombreCambio && this.rolRepository.existsByNombreIgnoreCaseAndIdNot(nombreNormalizado, id)) {
            throw new BadRequestException("Ya existe un rol con el mismo nombre");
        }
        rol.setNombre(nombreNormalizado);
        rol.setDescripcion(this.limpiar(request.getDescripcion()));
        if (request.getEsSistema() != null) {
            rol.setEsSistema(request.getEsSistema());
        }
        if (request.getPermisos() != null) {
            Set permisos = this.resolverPermisos(request.getPermisos(), true);
            rol.setPermisos(new HashSet(permisos));
        }
        RolSuperadmin actualizado = (RolSuperadmin)this.rolRepository.save((Object)rol);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long id) {
        RolSuperadmin rol = (RolSuperadmin)this.rolRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Rol superadmin no encontrado"));
        if (Boolean.TRUE.equals(rol.getEsSistema())) {
            throw new BadRequestException("No puedes eliminar un rol del sistema");
        }
        if (this.usuarioRepository.existsByRoles_Id(id)) {
            throw new BadRequestException("No puedes eliminar un rol asignado a superadministradores activos");
        }
        this.rolRepository.delete((Object)rol);
    }

    private Set<PermisoSuperadmin> resolverPermisos(Set<String> permisosSlugs, boolean obligatorio) {
        if (permisosSlugs == null || permisosSlugs.isEmpty()) {
            if (obligatorio) {
                throw new BadRequestException("Debes seleccionar al menos un permiso");
            }
            return Set.of();
        }
        List encontrados = this.permisoRepository.findBySlugIn(permisosSlugs);
        if (encontrados.size() != permisosSlugs.size()) {
            throw new BadRequestException("Uno o m\u00e1s permisos no existen");
        }
        return new HashSet<PermisoSuperadmin>(encontrados);
    }

    private RolSuperadminResponse toResponse(RolSuperadmin rol) {
        Set permisos = rol.getPermisos() == null ? Set.of() : (Set)rol.getPermisos().stream().map(PermisoSuperadmin::getSlug).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toCollection(LinkedHashSet::new));
        long totalUsuarios = rol.getId() == null ? 0L : this.usuarioRepository.countByRoles_Id(rol.getId());
        return RolSuperadminResponse.builder().id(rol.getId()).nombre(rol.getNombre()).descripcion(rol.getDescripcion()).esSistema(rol.getEsSistema()).permisos(permisos).creadoEn(rol.getCreadoEn()).actualizadoEn(rol.getActualizadoEn()).totalUsuarios(Long.valueOf(totalUsuarios)).build();
    }

    private String limpiar(String valor) {
        return valor == null || valor.isBlank() ? null : valor.trim();
    }

    @Generated
    public RolSuperadminService(RolSuperadminRepository rolRepository, PermisoSuperadminRepository permisoRepository, UsuarioSuperadminRepository usuarioRepository) {
        this.rolRepository = rolRepository;
        this.permisoRepository = permisoRepository;
        this.usuarioRepository = usuarioRepository;
    }
}

