/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.service.impl;

import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.ActividadSuperadminCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.ActividadSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.ActividadSuperadmin;
import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.UsuarioSuperadmin;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.ActividadSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.UsuarioSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.service.IActividadSuperadminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActividadSuperadminService
implements IActividadSuperadminService {
    private static final int LIMITE_DEFECTO = 50;
    private static final int LIMITE_MAXIMO = 200;
    private final ActividadSuperadminRepository actividadRepository;
    private final UsuarioSuperadminRepository usuarioRepository;
    private final ObjectMapper objectMapper;

    @Transactional(readOnly=true)
    public List<ActividadSuperadminResponse> listarRecientes(int limite) {
        Pageable pageable = this.buildPageable(limite);
        Page pagina = this.actividadRepository.findAll(pageable);
        return pagina.getContent().stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<ActividadSuperadminResponse> listarPorSuperadmin(Long superadminId, int limite) {
        Pageable pageable = this.buildPageable(limite);
        Page pagina = this.actividadRepository.findBySuperadminId(superadminId, pageable);
        return pagina.getContent().stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional
    public ActividadSuperadminResponse registrar(Long superadminId, ActividadSuperadminCreateRequest request) {
        UsuarioSuperadmin superadmin = (UsuarioSuperadmin)this.usuarioRepository.findById((Object)superadminId).orElseThrow(() -> new ResourceNotFoundException("Superadministrador no encontrado"));
        ActividadSuperadmin actividad = new ActividadSuperadmin();
        actividad.setSuperadmin(superadmin);
        actividad.setTipoEvento(request.getTipoEvento());
        actividad.setIpOrigen(request.getIpOrigen());
        actividad.setDetallesJson(this.serializarDetalles(request.getDetalles()));
        ActividadSuperadmin guardada = (ActividadSuperadmin)this.actividadRepository.save((Object)actividad);
        return this.toResponse(guardada);
    }

    private Pageable buildPageable(int limiteSolicitado) {
        int limiteNormalizado = limiteSolicitado <= 0 ? 50 : Math.min(limiteSolicitado, 200);
        return PageRequest.of((int)0, (int)limiteNormalizado, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creadoEn"}));
    }

    private String serializarDetalles(JsonNode detalles) {
        if (detalles == null || detalles.isNull() || detalles.isMissingNode()) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString((Object)detalles);
        }
        catch (JsonProcessingException ex) {
            throw new BadRequestException("No fue posible serializar los detalles de la actividad");
        }
    }

    private JsonNode deserializarDetalles(String detallesJson) {
        if (detallesJson == null || detallesJson.isBlank()) {
            return this.objectMapper.nullNode();
        }
        try {
            return this.objectMapper.readTree(detallesJson);
        }
        catch (JsonProcessingException ex) {
            return this.objectMapper.nullNode();
        }
    }

    private ActividadSuperadminResponse toResponse(ActividadSuperadmin actividad) {
        return ActividadSuperadminResponse.builder().id(actividad.getId()).superadminId(actividad.getSuperadmin() != null ? actividad.getSuperadmin().getId() : null).tipoEvento(actividad.getTipoEvento()).ipOrigen(actividad.getIpOrigen()).detalles(this.deserializarDetalles(actividad.getDetallesJson())).creadoEn(actividad.getCreadoEn()).build();
    }

    @Generated
    public ActividadSuperadminService(ActividadSuperadminRepository actividadRepository, UsuarioSuperadminRepository usuarioRepository, ObjectMapper objectMapper) {
        this.actividadRepository = actividadRepository;
        this.usuarioRepository = usuarioRepository;
        this.objectMapper = objectMapper;
    }
}

