/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.entity;

import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.RolSuperadmin;
import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.enums.TipoDocumento;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="usuarios_superadmin")
@SQLDelete(sql="UPDATE usuarios_superadmin SET activo = false, eliminado_en = NOW() WHERE id = ?")
@SQLRestriction(value="eliminado_en IS NULL")
public class UsuarioSuperadmin {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, unique=true)
    private String correo;
    @Column(name="hash_contrasena", nullable=false)
    private String hashContrasena;
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipo_doc", nullable=false, columnDefinition="ENUM('DNI','RUC')")
    private TipoDocumento tipoDoc;
    @Column(name="numero_doc", length=20)
    private String numeroDoc;
    @Column(name="nombres_doc")
    private String nombres;
    @Column(length=50)
    private String telefono;
    @Column(nullable=false)
    private Boolean activo = Boolean.TRUE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;
    @Column(name="eliminado_en")
    private LocalDateTime eliminadoEn;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="usuarios_superadmin_roles", joinColumns={@JoinColumn(name="usuario_id")}, inverseJoinColumns={@JoinColumn(name="rol_id")})
    private Set<RolSuperadmin> roles = new HashSet();

    @PrePersist
    void onCreate() {
        LocalDateTime ahora;
        this.creadoEn = ahora = LocalDateTime.now();
        this.actualizadoEn = ahora;
        if (this.activo == null) {
            this.activo = Boolean.TRUE;
        }
        if (this.roles == null) {
            this.roles = new HashSet();
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCorreo() {
        return this.correo;
    }

    @Generated
    public String getHashContrasena() {
        return this.hashContrasena;
    }

    @Generated
    public TipoDocumento getTipoDoc() {
        return this.tipoDoc;
    }

    @Generated
    public String getNumeroDoc() {
        return this.numeroDoc;
    }

    @Generated
    public String getNombres() {
        return this.nombres;
    }

    @Generated
    public String getTelefono() {
        return this.telefono;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public LocalDateTime getEliminadoEn() {
        return this.eliminadoEn;
    }

    @Generated
    public Set<RolSuperadmin> getRoles() {
        return this.roles;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCorreo(String correo) {
        this.correo = correo;
    }

    @Generated
    public void setHashContrasena(String hashContrasena) {
        this.hashContrasena = hashContrasena;
    }

    @Generated
    public void setTipoDoc(TipoDocumento tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @Generated
    public void setNumeroDoc(String numeroDoc) {
        this.numeroDoc = numeroDoc;
    }

    @Generated
    public void setNombres(String nombres) {
        this.nombres = nombres;
    }

    @Generated
    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public void setEliminadoEn(LocalDateTime eliminadoEn) {
        this.eliminadoEn = eliminadoEn;
    }

    @Generated
    public void setRoles(Set<RolSuperadmin> roles) {
        this.roles = roles;
    }
}

