/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.entity;

import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.PermisoSuperadmin;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;

@Entity
@Table(name="roles_superadmin")
public class RolSuperadmin {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, unique=true)
    private String nombre;
    @Column(columnDefinition="TEXT")
    private String descripcion;
    @Column(name="es_sistema", nullable=false)
    private Boolean esSistema = Boolean.FALSE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="roles_superadmin_permisos", joinColumns={@JoinColumn(name="rol_id")}, inverseJoinColumns={@JoinColumn(name="permiso_id")})
    private Set<PermisoSuperadmin> permisos = new HashSet();

    @PrePersist
    void onCreate() {
        LocalDateTime ahora;
        this.creadoEn = ahora = LocalDateTime.now();
        this.actualizadoEn = ahora;
        if (this.esSistema == null) {
            this.esSistema = Boolean.FALSE;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public Boolean getEsSistema() {
        return this.esSistema;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public Set<PermisoSuperadmin> getPermisos() {
        return this.permisos;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setEsSistema(Boolean esSistema) {
        this.esSistema = esSistema;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public void setPermisos(Set<PermisoSuperadmin> permisos) {
        this.permisos = permisos;
    }
}

