/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.controller;

import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.UsuarioSuperadminCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.UsuarioSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.UsuarioSuperadminUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.service.IUsuarioSuperadminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/seguridad/usuarios"})
@Validated
public class UsuarioSuperadminController {
    private final IUsuarioSuperadminService usuarioSuperadminService;

    @GetMapping
    public ResponseEntity<List<UsuarioSuperadminResponse>> listar() {
        return ResponseEntity.ok((Object)this.usuarioSuperadminService.listar());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<UsuarioSuperadminResponse> obtener(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.usuarioSuperadminService.obtenerPorId(id));
    }

    @PostMapping
    public ResponseEntity<UsuarioSuperadminResponse> crear(@Valid @RequestBody UsuarioSuperadminCreateRequest request) {
        UsuarioSuperadminResponse response = this.usuarioSuperadminService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<UsuarioSuperadminResponse> actualizar(@PathVariable Long id, @Valid @RequestBody UsuarioSuperadminUpdateRequest request) {
        return ResponseEntity.ok((Object)this.usuarioSuperadminService.actualizar(id, request));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long id) {
        this.usuarioSuperadminService.eliminar(id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public UsuarioSuperadminController(IUsuarioSuperadminService usuarioSuperadminService) {
        this.usuarioSuperadminService = usuarioSuperadminService;
    }
}

