/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.controller;

import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.ActividadSuperadminCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.ActividadSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.service.IActividadSuperadminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/seguridad/actividades"})
@Validated
public class ActividadSuperadminController {
    private final IActividadSuperadminService actividadSuperadminService;

    @GetMapping
    public ResponseEntity<List<ActividadSuperadminResponse>> listarRecientes(@RequestParam(name="limit", defaultValue="50") int limit) {
        return ResponseEntity.ok((Object)this.actividadSuperadminService.listarRecientes(limit));
    }

    @GetMapping(value={"/usuarios/{superadminId}"})
    public ResponseEntity<List<ActividadSuperadminResponse>> listarPorSuperadmin(@PathVariable Long superadminId, @RequestParam(name="limit", defaultValue="50") int limit) {
        return ResponseEntity.ok((Object)this.actividadSuperadminService.listarPorSuperadmin(superadminId, limit));
    }

    @PostMapping(value={"/usuarios/{superadminId}"})
    public ResponseEntity<ActividadSuperadminResponse> registrar(@PathVariable Long superadminId, @Valid @RequestBody ActividadSuperadminCreateRequest request) {
        ActividadSuperadminResponse response = this.actividadSuperadminService.registrar(superadminId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @Generated
    public ActividadSuperadminController(IActividadSuperadminService actividadSuperadminService) {
        this.actividadSuperadminService = actividadSuperadminService;
    }
}

