/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.facturacion.service.impl;

import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.TransaccionPagoResponse;
import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.TransaccionPago;
import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.enums.EstadoTransaccion;
import com.dulcecontrol.bakery.features.superadmin.facturacion.repository.TransaccionPagoRepository;
import com.dulcecontrol.bakery.features.superadmin.facturacion.service.ITransaccionPagoService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransaccionPagoService
implements ITransaccionPagoService {
    private final TransaccionPagoRepository transaccionRepository;

    @Transactional(readOnly=true)
    public List<TransaccionPagoResponse> listar(Long comprobanteId, EstadoTransaccion estado) {
        List items = comprobanteId != null ? this.transaccionRepository.findByComprobanteIdOrderByCreadoEnDesc(comprobanteId) : (estado != null ? this.transaccionRepository.findByEstadoOrderByCreadoEnDesc(estado) : this.transaccionRepository.findAll());
        return items.stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public TransaccionPagoResponse obtener(Long id) {
        TransaccionPago t = (TransaccionPago)this.transaccionRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Transacci\u00f3n no encontrada"));
        return this.toResponse(t);
    }

    private TransaccionPagoResponse toResponse(TransaccionPago t) {
        return TransaccionPagoResponse.builder().id(t.getId()).comprobanteId(t.getComprobanteId()).pasarela(t.getPasarela()).idTransaccionPasarela(t.getIdTransaccionPasarela()).montoCentimos(t.getMontoCentimos()).moneda(t.getMoneda()).estado(t.getEstado()).codigoError(t.getCodigoError()).mensajeError(t.getMensajeError()).metadataPasarela(t.getMetadataPasarela()).creadoEn(t.getCreadoEn()).build();
    }

    @Generated
    public TransaccionPagoService(TransaccionPagoRepository transaccionRepository) {
        this.transaccionRepository = transaccionRepository;
    }
}

