/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.facturacion.service.impl;

import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.SerieCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.SerieResponse;
import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.SerieUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.Serie;
import com.dulcecontrol.bakery.features.superadmin.facturacion.repository.SerieRepository;
import com.dulcecontrol.bakery.features.superadmin.facturacion.service.ISerieService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SerieService
implements ISerieService {
    private final SerieRepository serieRepository;

    @Transactional(readOnly=true)
    public List<SerieResponse> listar() {
        return this.serieRepository.findByActivoTrueOrderBySerieAsc().stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public SerieResponse obtener(Integer id) {
        Serie serie = (Serie)this.serieRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Serie no encontrada"));
        return this.toResponse(serie);
    }

    @Transactional
    public SerieResponse crear(SerieCreateRequest request) {
        if (this.serieRepository.findBySerie(request.getSerie()).isPresent()) {
            throw new BadRequestException("La serie ya existe");
        }
        Serie serie = new Serie();
        serie.setTiposComprobante(request.getTiposComprobante());
        serie.setSerie(request.getSerie());
        serie.setEsPredeterminada(Boolean.valueOf(Boolean.TRUE.equals(request.getEsPredeterminada())));
        Serie guardada = (Serie)this.serieRepository.save((Object)serie);
        return this.toResponse(guardada);
    }

    @Transactional
    public SerieResponse actualizar(Integer id, SerieUpdateRequest request) {
        Serie serie = (Serie)this.serieRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Serie no encontrada"));
        if (request.getUltimoCorrelativo() != null) {
            serie.setUltimoCorrelativo(request.getUltimoCorrelativo());
        }
        if (request.getActivo() != null) {
            serie.setActivo(request.getActivo());
        }
        if (request.getEsPredeterminada() != null) {
            serie.setEsPredeterminada(request.getEsPredeterminada());
        }
        Serie actualizada = (Serie)this.serieRepository.save((Object)serie);
        return this.toResponse(actualizada);
    }

    @Transactional
    public void eliminar(Integer id) {
        Serie serie = (Serie)this.serieRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Serie no encontrada"));
        serie.setActivo(Boolean.FALSE);
        this.serieRepository.save((Object)serie);
    }

    private SerieResponse toResponse(Serie s) {
        return SerieResponse.builder().id(s.getId()).tiposComprobante(s.getTiposComprobante()).serie(s.getSerie()).ultimoCorrelativo(s.getUltimoCorrelativo()).activo(s.getActivo()).esPredeterminada(s.getEsPredeterminada()).creadoEn(s.getCreadoEn()).actualizadoEn(s.getActualizadoEn()).build();
    }

    @Generated
    public SerieService(SerieRepository serieRepository) {
        this.serieRepository = serieRepository;
    }
}

