/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.facturacion.entity;

import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.enums.EstadoTransaccion;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.Map;
import lombok.Generated;
import org.hibernate.annotations.Type;

@Entity
@Table(name="transacciones_pago")
public class TransaccionPago {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="comprobante_id", nullable=false)
    private Long comprobanteId;
    @Column(nullable=false, length=50)
    private String pasarela;
    @Column(name="id_transaccion_pasarela", length=100)
    private String idTransaccionPasarela;
    @Column(name="monto_centimos", nullable=false)
    private Long montoCentimos;
    @Column(name="moneda", columnDefinition="CHAR(3)", nullable=false)
    private String moneda = "PEN";
    @Enumerated(value=EnumType.STRING)
    @Column(name="estado", nullable=false, columnDefinition="ENUM('pendiente','exitoso','fallido','reembolsado')")
    private EstadoTransaccion estado = EstadoTransaccion.pendiente;
    @Column(name="codigo_error", length=100)
    private String codigoError;
    @Column(name="mensaje_error")
    private String mensajeError;
    @Type(value=JsonType.class)
    @Column(name="metadata_pasarela", columnDefinition="json")
    private Map<String, Object> metadataPasarela;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        if (this.moneda == null) {
            this.moneda = "PEN";
        }
        if (this.estado == null) {
            this.estado = EstadoTransaccion.pendiente;
        }
    }

    @Generated
    public TransaccionPago() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getComprobanteId() {
        return this.comprobanteId;
    }

    @Generated
    public String getPasarela() {
        return this.pasarela;
    }

    @Generated
    public String getIdTransaccionPasarela() {
        return this.idTransaccionPasarela;
    }

    @Generated
    public Long getMontoCentimos() {
        return this.montoCentimos;
    }

    @Generated
    public String getMoneda() {
        return this.moneda;
    }

    @Generated
    public EstadoTransaccion getEstado() {
        return this.estado;
    }

    @Generated
    public String getCodigoError() {
        return this.codigoError;
    }

    @Generated
    public String getMensajeError() {
        return this.mensajeError;
    }

    @Generated
    public Map<String, Object> getMetadataPasarela() {
        return this.metadataPasarela;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setComprobanteId(Long comprobanteId) {
        this.comprobanteId = comprobanteId;
    }

    @Generated
    public void setPasarela(String pasarela) {
        this.pasarela = pasarela;
    }

    @Generated
    public void setIdTransaccionPasarela(String idTransaccionPasarela) {
        this.idTransaccionPasarela = idTransaccionPasarela;
    }

    @Generated
    public void setMontoCentimos(Long montoCentimos) {
        this.montoCentimos = montoCentimos;
    }

    @Generated
    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    @Generated
    public void setEstado(EstadoTransaccion estado) {
        this.estado = estado;
    }

    @Generated
    public void setCodigoError(String codigoError) {
        this.codigoError = codigoError;
    }

    @Generated
    public void setMensajeError(String mensajeError) {
        this.mensajeError = mensajeError;
    }

    @Generated
    public void setMetadataPasarela(Map<String, Object> metadataPasarela) {
        this.metadataPasarela = metadataPasarela;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransaccionPago)) {
            return false;
        }
        TransaccionPago other = (TransaccionPago)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Long this$comprobanteId = this.getComprobanteId();
        Long other$comprobanteId = other.getComprobanteId();
        if (this$comprobanteId == null ? other$comprobanteId != null : !((Object)this$comprobanteId).equals(other$comprobanteId)) {
            return false;
        }
        Long this$montoCentimos = this.getMontoCentimos();
        Long other$montoCentimos = other.getMontoCentimos();
        if (this$montoCentimos == null ? other$montoCentimos != null : !((Object)this$montoCentimos).equals(other$montoCentimos)) {
            return false;
        }
        String this$pasarela = this.getPasarela();
        String other$pasarela = other.getPasarela();
        if (this$pasarela == null ? other$pasarela != null : !this$pasarela.equals(other$pasarela)) {
            return false;
        }
        String this$idTransaccionPasarela = this.getIdTransaccionPasarela();
        String other$idTransaccionPasarela = other.getIdTransaccionPasarela();
        if (this$idTransaccionPasarela == null ? other$idTransaccionPasarela != null : !this$idTransaccionPasarela.equals(other$idTransaccionPasarela)) {
            return false;
        }
        String this$moneda = this.getMoneda();
        String other$moneda = other.getMoneda();
        if (this$moneda == null ? other$moneda != null : !this$moneda.equals(other$moneda)) {
            return false;
        }
        EstadoTransaccion this$estado = this.getEstado();
        EstadoTransaccion other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        String this$codigoError = this.getCodigoError();
        String other$codigoError = other.getCodigoError();
        if (this$codigoError == null ? other$codigoError != null : !this$codigoError.equals(other$codigoError)) {
            return false;
        }
        String this$mensajeError = this.getMensajeError();
        String other$mensajeError = other.getMensajeError();
        if (this$mensajeError == null ? other$mensajeError != null : !this$mensajeError.equals(other$mensajeError)) {
            return false;
        }
        Map this$metadataPasarela = this.getMetadataPasarela();
        Map other$metadataPasarela = other.getMetadataPasarela();
        if (this$metadataPasarela == null ? other$metadataPasarela != null : !((Object)this$metadataPasarela).equals(other$metadataPasarela)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        return !(this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransaccionPago;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Long $comprobanteId = this.getComprobanteId();
        result = result * 59 + ($comprobanteId == null ? 43 : ((Object)$comprobanteId).hashCode());
        Long $montoCentimos = this.getMontoCentimos();
        result = result * 59 + ($montoCentimos == null ? 43 : ((Object)$montoCentimos).hashCode());
        String $pasarela = this.getPasarela();
        result = result * 59 + ($pasarela == null ? 43 : $pasarela.hashCode());
        String $idTransaccionPasarela = this.getIdTransaccionPasarela();
        result = result * 59 + ($idTransaccionPasarela == null ? 43 : $idTransaccionPasarela.hashCode());
        String $moneda = this.getMoneda();
        result = result * 59 + ($moneda == null ? 43 : $moneda.hashCode());
        EstadoTransaccion $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        String $codigoError = this.getCodigoError();
        result = result * 59 + ($codigoError == null ? 43 : $codigoError.hashCode());
        String $mensajeError = this.getMensajeError();
        result = result * 59 + ($mensajeError == null ? 43 : $mensajeError.hashCode());
        Map $metadataPasarela = this.getMetadataPasarela();
        result = result * 59 + ($metadataPasarela == null ? 43 : ((Object)$metadataPasarela).hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransaccionPago(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", comprobanteId=" + this.getComprobanteId() + ", pasarela=" + this.getPasarela() + ", idTransaccionPasarela=" + this.getIdTransaccionPasarela() + ", montoCentimos=" + this.getMontoCentimos() + ", moneda=" + this.getMoneda() + ", estado=" + String.valueOf(this.getEstado()) + ", codigoError=" + this.getCodigoError() + ", mensajeError=" + this.getMensajeError() + ", metadataPasarela=" + String.valueOf(this.getMetadataPasarela()) + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ")";
    }
}

