/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.storefront.service.impl;

import com.dulcecontrol.bakery.features.admin.catalogo.entity.Producto;
import com.dulcecontrol.bakery.features.admin.clientes.entity.Cliente;
import com.dulcecontrol.bakery.features.admin.clientes.repository.ClienteRepository;
import com.dulcecontrol.bakery.features.admin.ventas.entity.DetallePedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.Pedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.PersonalizacionItemPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.EstadoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.OrigenPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.TipoEntregaPedido;
import com.dulcecontrol.bakery.features.admin.ventas.repository.DetallePedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.PedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.PersonalizacionItemPedidoRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import com.dulcecontrol.bakery.features.storefront.dto.PedidoPersonalizadoCreateRequest;
import com.dulcecontrol.bakery.features.storefront.dto.PedidoPersonalizadoResponse;
import com.dulcecontrol.bakery.features.storefront.service.IPedidoPersonalizadoStorefrontService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoPersonalizadoStorefrontService
implements IPedidoPersonalizadoStorefrontService {
    private final PedidoRepository pedidoRepository;
    private final DetallePedidoRepository detallePedidoRepository;
    private final PersonalizacionItemPedidoRepository personalizacionRepository;
    private final ClienteRepository clienteRepository;
    private final ProductoRepository productoRepository;

    @Transactional
    public PedidoPersonalizadoResponse crear(Long clienteId, PedidoPersonalizadoCreateRequest request) {
        Cliente cliente = (Cliente)this.clienteRepository.findById((Object)clienteId).orElseThrow(() -> new ResourceNotFoundException("Cliente no encontrado"));
        Producto producto = (Producto)this.productoRepository.findByIdAndTiendaId(request.productoId(), request.tiendaId()).orElseThrow(() -> new ResourceNotFoundException("Producto no encontrado"));
        Pedido pedido = new Pedido();
        pedido.setCodigoPedido("PED-" + UUID.randomUUID().toString().substring(0, 8).toUpperCase());
        pedido.setTiendaId(request.tiendaId());
        pedido.setSedeOrigenId(Long.valueOf(1L));
        pedido.setClienteId(clienteId);
        pedido.setOrigen(OrigenPedido.STOREFRONT_ONLINE);
        pedido.setEstadoPedido(EstadoPedido.BORRADOR);
        pedido.setTipoEntrega(TipoEntregaPedido.RECOJO_TIENDA);
        pedido.setFechaEntregaPactada(LocalDateTime.now().plusDays(3L));
        pedido.setSubtotalItemsCentimos(Long.valueOf(0L));
        pedido.setDescuentoTotalCentimos(Long.valueOf(0L));
        pedido.setImpuestosTotalesCentimos(Long.valueOf(0L));
        pedido.setTotalFinalCentimos(Long.valueOf(0L));
        pedido.setMoneda("PEN");
        pedido.setRequiereComprobante(Boolean.valueOf(false));
        pedido.setCreadoEn(LocalDateTime.now());
        pedido.setActualizadoEn(LocalDateTime.now());
        pedido = (Pedido)this.pedidoRepository.save((Object)pedido);
        DetallePedido detalle = new DetallePedido();
        detalle.setPedidoId(pedido.getId());
        detalle.setProductoId(producto.getId());
        detalle.setCantidad(request.cantidad());
        detalle.setPrecioUnitarioCentimos(producto.getPrecioBaseCentimos());
        detalle.setSubtotalLineaCentimos(Long.valueOf(producto.getPrecioBaseCentimos() * (long)request.cantidad().intValue()));
        detalle.setNotasItem("Pedido personalizado");
        detalle = (DetallePedido)this.detallePedidoRepository.save((Object)detalle);
        PersonalizacionItemPedido personalizacion = new PersonalizacionItemPedido();
        personalizacion.setDetallePedidoId(detalle.getId());
        personalizacion.setDescripcionSolicitud(request.descripcionSolicitud());
        personalizacion.setTextoDedicatoria(request.textoDedicatoria());
        personalizacion.setSaborMasa(request.saborMasa());
        personalizacion.setSaborRelleno(request.saborRelleno());
        personalizacion.setTematica(request.tematica());
        personalizacion.setCostoExtraPersonalizacionCentimos(Long.valueOf(0L));
        this.personalizacionRepository.save((Object)personalizacion);
        return PedidoPersonalizadoResponse.builder().pedidoId(pedido.getId()).codigoPedido(pedido.getCodigoPedido()).nombreProducto(producto.getNombre()).cantidad(request.cantidad()).descripcionSolicitud(request.descripcionSolicitud()).estado(pedido.getEstadoPedido().name()).fechaCreacion(pedido.getCreadoEn()).build();
    }

    @Transactional(readOnly=true)
    public List<PedidoPersonalizadoResponse> listarPorCliente(Long clienteId) {
        List pedidos = this.pedidoRepository.findByClienteIdOrderByCreadoEnDesc(clienteId);
        return pedidos.stream().map(pedido -> {
            DetallePedido detalle = this.detallePedidoRepository.findByPedidoId(pedido.getId()).stream().findFirst().orElse(null);
            if (detalle == null) {
                return null;
            }
            PersonalizacionItemPedido personalizacion = this.personalizacionRepository.findByDetallePedidoId(detalle.getId()).orElse(null);
            Producto producto = this.productoRepository.findById((Object)detalle.getProductoId()).orElse(null);
            return PedidoPersonalizadoResponse.builder().pedidoId(pedido.getId()).codigoPedido(pedido.getCodigoPedido()).nombreProducto(producto != null ? producto.getNombre() : "Producto eliminado").cantidad(detalle.getCantidad()).descripcionSolicitud(personalizacion != null ? personalizacion.getDescripcionSolicitud() : "").estado(pedido.getEstadoPedido().name()).fechaCreacion(pedido.getCreadoEn()).build();
        }).filter(response -> response != null).toList();
    }

    @Generated
    public PedidoPersonalizadoStorefrontService(PedidoRepository pedidoRepository, DetallePedidoRepository detallePedidoRepository, PersonalizacionItemPedidoRepository personalizacionRepository, ClienteRepository clienteRepository, ProductoRepository productoRepository) {
        this.pedidoRepository = pedidoRepository;
        this.detallePedidoRepository = detallePedidoRepository;
        this.personalizacionRepository = personalizacionRepository;
        this.clienteRepository = clienteRepository;
        this.productoRepository = productoRepository;
    }
}

