/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.storefront.controller;

import com.dulcecontrol.bakery.features.storefront.dto.PedidoPersonalizadoCreateRequest;
import com.dulcecontrol.bakery.features.storefront.dto.PedidoPersonalizadoResponse;
import com.dulcecontrol.bakery.features.storefront.service.IPedidoPersonalizadoStorefrontService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/storefront"})
@Validated
public class PedidoPersonalizadoStorefrontController {
    private final IPedidoPersonalizadoStorefrontService pedidoPersonalizadoService;

    @PostMapping(value={"/pedidos-personalizados"})
    public ResponseEntity<PedidoPersonalizadoResponse> crear(Authentication authentication, @Valid @RequestBody PedidoPersonalizadoCreateRequest request) {
        Long clienteId = Long.parseLong(authentication.getName());
        PedidoPersonalizadoResponse response = this.pedidoPersonalizadoService.crear(clienteId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @GetMapping(value={"/pedidos/me"})
    public ResponseEntity<List<PedidoPersonalizadoResponse>> listarMisPedidos(Authentication authentication) {
        Long clienteId = Long.parseLong(authentication.getName());
        List pedidos = this.pedidoPersonalizadoService.listarPorCliente(clienteId);
        return ResponseEntity.ok((Object)pedidos);
    }

    @Generated
    public PedidoPersonalizadoStorefrontController(IPedidoPersonalizadoStorefrontService pedidoPersonalizadoService) {
        this.pedidoPersonalizadoService = pedidoPersonalizadoService;
    }
}

