/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.shared.ubigeo.service;

import com.dulcecontrol.bakery.features.shared.ubigeo.dto.DepartamentoResponse;
import com.dulcecontrol.bakery.features.shared.ubigeo.dto.DistritoResponse;
import com.dulcecontrol.bakery.features.shared.ubigeo.dto.ProvinciaResponse;
import com.dulcecontrol.bakery.features.shared.ubigeo.entity.UbigeoDepartamento;
import com.dulcecontrol.bakery.features.shared.ubigeo.entity.UbigeoDistrito;
import com.dulcecontrol.bakery.features.shared.ubigeo.entity.UbigeoProvincia;
import com.dulcecontrol.bakery.features.shared.ubigeo.repository.UbigeoDepartamentoRepository;
import com.dulcecontrol.bakery.features.shared.ubigeo.repository.UbigeoDistritoRepository;
import com.dulcecontrol.bakery.features.shared.ubigeo.repository.UbigeoProvinciaRepository;
import com.dulcecontrol.bakery.features.shared.ubigeo.service.IUbigeoService;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UbigeoService
implements IUbigeoService {
    private final UbigeoDepartamentoRepository departamentoRepository;
    private final UbigeoProvinciaRepository provinciaRepository;
    private final UbigeoDistritoRepository distritoRepository;

    @Transactional(readOnly=true)
    public List<DepartamentoResponse> obtenerDepartamentos() {
        return this.departamentoRepository.findAll().stream().map(arg_0 -> this.mapToDepartamentoResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<ProvinciaResponse> obtenerProvinciasPorDepartamento(Long departamentoId) {
        return this.provinciaRepository.findByDepartamentoIdOrderByNombreAsc(departamentoId).stream().map(arg_0 -> this.mapToProvinciaResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<DistritoResponse> obtenerDistritosPorProvincia(Long provinciaId) {
        return this.distritoRepository.findByProvinciaIdOrderByNombreAsc(provinciaId).stream().map(arg_0 -> this.mapToDistritoResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public DistritoResponse obtenerDistritoPorId(Long id) {
        return this.distritoRepository.findById((Object)id).map(arg_0 -> this.mapToDistritoResponse(arg_0)).orElse(null);
    }

    @Transactional(readOnly=true)
    public ProvinciaResponse obtenerProvinciaPorId(Long id) {
        return this.provinciaRepository.findById((Object)id).map(arg_0 -> this.mapToProvinciaResponse(arg_0)).orElse(null);
    }

    private DepartamentoResponse mapToDepartamentoResponse(UbigeoDepartamento departamento) {
        return DepartamentoResponse.builder().id(departamento.getId()).nombre(departamento.getNombre()).codigoUbigeo(departamento.getCodigoUbigeo()).build();
    }

    private ProvinciaResponse mapToProvinciaResponse(UbigeoProvincia provincia) {
        return ProvinciaResponse.builder().id(provincia.getId()).departamentoId(provincia.getDepartamento().getId()).nombre(provincia.getNombre()).codigoUbigeo(provincia.getCodigoUbigeo()).build();
    }

    private DistritoResponse mapToDistritoResponse(UbigeoDistrito distrito) {
        return DistritoResponse.builder().id(distrito.getId()).provinciaId(distrito.getProvincia().getId()).nombre(distrito.getNombre()).codigoUbigeo(distrito.getCodigoUbigeo()).build();
    }

    @Generated
    public UbigeoService(UbigeoDepartamentoRepository departamentoRepository, UbigeoProvinciaRepository provinciaRepository, UbigeoDistritoRepository distritoRepository) {
        this.departamentoRepository = departamentoRepository;
        this.provinciaRepository = provinciaRepository;
        this.distritoRepository = distritoRepository;
    }
}

