/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.shared.ubigeo.controller;

import com.dulcecontrol.bakery.features.shared.ubigeo.dto.DepartamentoResponse;
import com.dulcecontrol.bakery.features.shared.ubigeo.dto.DistritoResponse;
import com.dulcecontrol.bakery.features.shared.ubigeo.dto.ProvinciaResponse;
import com.dulcecontrol.bakery.features.shared.ubigeo.service.IUbigeoService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ubigeo"})
public class UbigeoController {
    private final IUbigeoService ubigeoService;

    @GetMapping(value={"/departamentos"})
    public ResponseEntity<List<DepartamentoResponse>> obtenerDepartamentos() {
        return ResponseEntity.ok((Object)this.ubigeoService.obtenerDepartamentos());
    }

    @GetMapping(value={"/departamentos/{departamentoId}/provincias"})
    public ResponseEntity<List<ProvinciaResponse>> obtenerProvincias(@PathVariable Long departamentoId) {
        return ResponseEntity.ok((Object)this.ubigeoService.obtenerProvinciasPorDepartamento(departamentoId));
    }

    @GetMapping(value={"/provincias/{provinciaId}/distritos"})
    public ResponseEntity<List<DistritoResponse>> obtenerDistritos(@PathVariable Long provinciaId) {
        return ResponseEntity.ok((Object)this.ubigeoService.obtenerDistritosPorProvincia(provinciaId));
    }

    @GetMapping(value={"/distritos/{distritoId}"})
    public ResponseEntity<DistritoResponse> obtenerDistrito(@PathVariable Long distritoId) {
        return ResponseEntity.ok((Object)this.ubigeoService.obtenerDistritoPorId(distritoId));
    }

    @GetMapping(value={"/provincias/{provinciaId}"})
    public ResponseEntity<ProvinciaResponse> obtenerProvincia(@PathVariable Long provinciaId) {
        return ResponseEntity.ok((Object)this.ubigeoService.obtenerProvinciaPorId(provinciaId));
    }

    @Generated
    public UbigeoController(IUbigeoService ubigeoService) {
        this.ubigeoService = ubigeoService;
    }
}

