/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.shared.catalogo.repository;

import com.dulcecontrol.bakery.features.admin.catalogo.entity.Producto;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ProductoRepository
extends JpaRepository<Producto, Long> {
    @Query(value="SELECT p FROM Producto p LEFT JOIN FETCH p.categoria WHERE p.tiendaId = :tiendaId AND p.activo = true AND p.visibleEnStorefront = true AND (:categoriaId IS NULL OR p.categoriaId = :categoriaId) AND (:destacado IS NULL OR p.destacadoStorefront = :destacado)")
    public Page<Producto> buscarProductosPublicos(@Param(value="tiendaId") Long var1, @Param(value="categoriaId") Long var2, @Param(value="destacado") Boolean var3, Pageable var4);

    @Query(value="SELECT p FROM Producto p LEFT JOIN FETCH p.categoria WHERE p.tiendaId = :tiendaId AND p.slug = :slug AND p.activo = true AND p.visibleEnStorefront = true")
    public Optional<Producto> findByTiendaIdAndSlugForStorefront(@Param(value="tiendaId") Long var1, @Param(value="slug") String var2);

    public Page<Producto> findByTiendaId(Long var1, Pageable var2);

    public List<Producto> findByTiendaIdOrderByNombreAsc(Long var1);

    public List<Producto> findByTiendaIdAndCategoriaIdOrderByNombreAsc(Long var1, Long var2);

    public Optional<Producto> findByIdAndTiendaId(Long var1, Long var2);

    public boolean existsByTiendaIdAndSkuIgnoreCase(Long var1, String var2);

    public boolean existsByTiendaIdAndSlugIgnoreCase(Long var1, String var2);

    public boolean existsByTiendaIdAndSkuIgnoreCaseAndIdNot(Long var1, String var2, Long var3);

    public boolean existsByTiendaIdAndSlugIgnoreCaseAndIdNot(Long var1, String var2, Long var3);

    public long countByCategoriaId(Long var1);
}

