/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.publico.tienda.controller;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.ConfiguracionPublicaResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.PaginaStorefrontResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IConfiguracionPublicaService;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IPaginaStorefrontService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/public/tienda/{tiendaId}"})
public class TiendaPublicaController {
    private final IConfiguracionPublicaService configuracionPublicaService;
    private final IPaginaStorefrontService paginaStorefrontService;

    @GetMapping(value={"/config"})
    public ResponseEntity<ConfiguracionPublicaResponse> obtenerConfiguracion(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.configuracionPublicaService.obtenerConfiguracionPublica(tiendaId));
    }

    @GetMapping(value={"/paginas"})
    public ResponseEntity<List<PaginaStorefrontResponse>> listarPaginasActivas(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.paginaStorefrontService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/paginas/{slug}"})
    public ResponseEntity<PaginaStorefrontResponse> obtenerPaginaPorSlug(@PathVariable Long tiendaId, @PathVariable String slug) {
        return ResponseEntity.ok((Object)this.paginaStorefrontService.obtenerPorSlug(tiendaId, slug));
    }

    @Generated
    public TiendaPublicaController(IConfiguracionPublicaService configuracionPublicaService, IPaginaStorefrontService paginaStorefrontService) {
        this.configuracionPublicaService = configuracionPublicaService;
        this.paginaStorefrontService = paginaStorefrontService;
    }
}

