/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.publico.catalogo.service;

import com.dulcecontrol.bakery.features.admin.catalogo.entity.Categoria;
import com.dulcecontrol.bakery.features.admin.catalogo.entity.Producto;
import com.dulcecontrol.bakery.features.publico.catalogo.dto.CategoriaPublicaResponse;
import com.dulcecontrol.bakery.features.publico.catalogo.dto.ProductoDetallePublicoResponse;
import com.dulcecontrol.bakery.features.publico.catalogo.dto.ProductoPublicoResponse;
import com.dulcecontrol.bakery.features.publico.catalogo.service.ICatalogoPublicoService;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.CategoriaRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CatalogoPublicoService
implements ICatalogoPublicoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatalogoPublicoService.class);
    private final CategoriaRepository categoriaRepository;
    private final ProductoRepository productoRepository;

    public List<CategoriaPublicaResponse> obtenerCategoriasActivas(Long tiendaId) {
        log.debug("Obteniendo categor\u00edas activas para tienda: {}", (Object)tiendaId);
        List categorias = this.categoriaRepository.findCategoriasActivasByTiendaId(tiendaId);
        return categorias.stream().map(arg_0 -> this.mapToCategoriaResponse(arg_0)).collect(Collectors.toList());
    }

    public Page<ProductoPublicoResponse> buscarProductos(Long tiendaId, Long categoriaId, Boolean destacado, Pageable pageable) {
        log.debug("Buscando productos - tienda: {}, categoria: {}, destacado: {}", new Object[]{tiendaId, categoriaId, destacado});
        Page productos = this.productoRepository.buscarProductosPublicos(tiendaId, categoriaId, destacado, pageable);
        return productos.map(arg_0 -> this.mapToProductoResponse(arg_0));
    }

    public ProductoDetallePublicoResponse obtenerProductoPorSlug(Long tiendaId, String slug) {
        log.debug("Obteniendo producto por slug: {} para tienda: {}", (Object)slug, (Object)tiendaId);
        Producto producto = (Producto)this.productoRepository.findByTiendaIdAndSlugForStorefront(tiendaId, slug).orElseThrow(() -> new EntityNotFoundException("Producto no encontrado con slug: " + slug + " en tienda: " + tiendaId));
        return this.mapToProductoDetalleResponse(producto);
    }

    private CategoriaPublicaResponse mapToCategoriaResponse(Categoria categoria) {
        return CategoriaPublicaResponse.builder().id(categoria.getId()).nombre(categoria.getNombre()).slug(categoria.getSlug()).descripcion(categoria.getDescripcion()).urlImagen(categoria.getUrlImagen()).icono(categoria.getIcono()).ordenVisual(categoria.getOrdenVisual()).build();
    }

    private ProductoPublicoResponse mapToProductoResponse(Producto producto) {
        String nombreCategoria = null;
        String slugCategoria = null;
        Long categoriaId = null;
        if (producto.getCategoria() != null) {
            nombreCategoria = producto.getCategoria().getNombre();
            slugCategoria = producto.getCategoria().getSlug();
            categoriaId = producto.getCategoria().getId();
        }
        return ProductoPublicoResponse.builder().id(producto.getId()).nombre(producto.getNombre()).slug(producto.getSlug()).descripcion(producto.getDescripcion()).precioBaseCentimos(producto.getPrecioBaseCentimos()).precioOfertaCentimos(producto.getPrecioOfertaCentimos()).esPersonalizable(producto.getEsPersonalizable()).destacadoStorefront(producto.getDestacadoStorefront()).urlImagenPrincipal(producto.getUrlImagenPrincipal()).nombreCategoria(nombreCategoria).slugCategoria(slugCategoria).categoriaId(categoriaId).build();
    }

    private ProductoDetallePublicoResponse mapToProductoDetalleResponse(Producto producto) {
        CategoriaPublicaResponse categoriaResponse = null;
        if (producto.getCategoria() != null) {
            categoriaResponse = this.mapToCategoriaResponse(producto.getCategoria());
        }
        return ProductoDetallePublicoResponse.builder().id(producto.getId()).nombre(producto.getNombre()).slug(producto.getSlug()).descripcion(producto.getDescripcion()).precioBaseCentimos(producto.getPrecioBaseCentimos()).precioOfertaCentimos(producto.getPrecioOfertaCentimos()).esPersonalizable(producto.getEsPersonalizable()).urlImagenPrincipal(producto.getUrlImagenPrincipal()).imagenesGaleria(producto.getImagenesGaleria() != null ? producto.getImagenesGaleria() : Collections.emptyList()).atributos(producto.getAtributos() != null ? producto.getAtributos() : Collections.emptyMap()).categoria(categoriaResponse).build();
    }

    @Generated
    public CatalogoPublicoService(CategoriaRepository categoriaRepository, ProductoRepository productoRepository) {
        this.categoriaRepository = categoriaRepository;
        this.productoRepository = productoRepository;
    }
}

