/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.publico.catalogo.controller;

import com.dulcecontrol.bakery.features.publico.catalogo.dto.CategoriaPublicaResponse;
import com.dulcecontrol.bakery.features.publico.catalogo.dto.ProductoDetallePublicoResponse;
import com.dulcecontrol.bakery.features.publico.catalogo.dto.ProductoPublicoResponse;
import com.dulcecontrol.bakery.features.publico.catalogo.service.ICatalogoPublicoService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/public/tienda/{tiendaId}/catalogo"})
public class CatalogoPublicoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CatalogoPublicoController.class);
    private final ICatalogoPublicoService catalogoService;

    @GetMapping(value={"/categorias"})
    public ResponseEntity<List<CategoriaPublicaResponse>> obtenerCategorias(@PathVariable Long tiendaId) {
        log.info("GET /api/public/tienda/{}/catalogo/categorias", (Object)tiendaId);
        List categorias = this.catalogoService.obtenerCategoriasActivas(tiendaId);
        return ResponseEntity.ok((Object)categorias);
    }

    @GetMapping(value={"/productos"})
    public ResponseEntity<Page<ProductoPublicoResponse>> buscarProductos(@PathVariable Long tiendaId, @RequestParam(required=false) Long categoriaId, @RequestParam(required=false) Boolean destacado, @PageableDefault(size=12, sort={"nombre"}, direction=Sort.Direction.ASC) Pageable pageable) {
        log.info("GET /api/public/tienda/{}/catalogo/productos - categoriaId: {}, destacado: {}, page: {}", new Object[]{tiendaId, categoriaId, destacado, pageable.getPageNumber()});
        Page productos = this.catalogoService.buscarProductos(tiendaId, categoriaId, destacado, pageable);
        return ResponseEntity.ok((Object)productos);
    }

    @GetMapping(value={"/productos/{slug}"})
    public ResponseEntity<ProductoDetallePublicoResponse> obtenerProductoPorSlug(@PathVariable Long tiendaId, @PathVariable String slug) {
        log.info("GET /api/public/tienda/{}/catalogo/productos/{}", (Object)tiendaId, (Object)slug);
        ProductoDetallePublicoResponse producto = this.catalogoService.obtenerProductoPorSlug(tiendaId, slug);
        return ResponseEntity.ok((Object)producto);
    }

    @Generated
    public CatalogoPublicoController(ICatalogoPublicoService catalogoService) {
        this.catalogoService = catalogoService;
    }
}

