/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.service.impl;

import com.dulcecontrol.bakery.features.admin.ventas.dto.SesionCajaCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.SesionCajaResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.SesionCajaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.SesionCaja;
import com.dulcecontrol.bakery.features.admin.ventas.repository.CajaRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.SesionCajaRepository;
import com.dulcecontrol.bakery.features.admin.ventas.service.ISesionCajaAdminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SesionCajaAdminService
implements ISesionCajaAdminService {
    private final SesionCajaRepository sesionCajaRepository;
    private final CajaRepository cajaRepository;

    @Transactional(readOnly=true)
    public List<SesionCajaResponse> listar(Long tiendaId, Long cajaId, Boolean estaAbierta) {
        List sesiones;
        if (cajaId != null && estaAbierta != null) {
            this.validarCajaPerteneceATienda(tiendaId, cajaId);
            sesiones = this.sesionCajaRepository.findByTiendaIdAndCajaIdAndEstaAbiertaOrderByFechaAperturaDesc(tiendaId, cajaId, estaAbierta);
        } else if (cajaId != null) {
            this.validarCajaPerteneceATienda(tiendaId, cajaId);
            sesiones = this.sesionCajaRepository.findByTiendaIdAndCajaIdOrderByFechaAperturaDesc(tiendaId, cajaId);
        } else {
            sesiones = estaAbierta != null ? this.sesionCajaRepository.findByTiendaIdAndEstaAbiertaOrderByFechaAperturaDesc(tiendaId, estaAbierta) : this.sesionCajaRepository.findByTiendaIdOrderByFechaAperturaDesc(tiendaId);
        }
        return sesiones.stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public SesionCajaResponse obtener(Long tiendaId, Long sesionId) {
        SesionCaja sesionCaja = this.obtenerSesion(tiendaId, sesionId);
        return this.toResponse(sesionCaja);
    }

    @Transactional
    public SesionCajaResponse crear(Long tiendaId, SesionCajaCreateRequest request) {
        this.validarCajaPerteneceATienda(tiendaId, request.cajaId());
        SesionCaja sesionCaja = new SesionCaja();
        sesionCaja.setTiendaId(tiendaId);
        sesionCaja.setCajaId(request.cajaId());
        sesionCaja.setUsuarioAperturaId(request.usuarioAperturaId());
        sesionCaja.setUsuarioCierreId(request.usuarioCierreId());
        sesionCaja.setMontoInicialCentimos(request.montoInicialCentimos());
        sesionCaja.setMontoFinalEsperadoCentimos(request.montoFinalEsperadoCentimos());
        sesionCaja.setMontoFinalRealCentimos(request.montoFinalRealCentimos());
        sesionCaja.setFechaApertura(request.fechaApertura() != null ? request.fechaApertura() : LocalDateTime.now());
        sesionCaja.setFechaCierre(request.fechaCierre());
        sesionCaja.setEstaAbierta(request.estaAbierta() == null ? Boolean.TRUE : request.estaAbierta());
        SesionCaja guardada = (SesionCaja)this.sesionCajaRepository.save((Object)sesionCaja);
        return this.toResponse(guardada);
    }

    @Transactional
    public SesionCajaResponse actualizar(Long tiendaId, Long sesionId, SesionCajaUpdateRequest request) {
        SesionCaja sesionCaja = this.obtenerSesion(tiendaId, sesionId);
        if (!sesionCaja.getCajaId().equals(request.cajaId())) {
            this.validarCajaPerteneceATienda(tiendaId, request.cajaId());
            sesionCaja.setCajaId(request.cajaId());
        }
        if (request.montoInicialCentimos() != null) {
            sesionCaja.setMontoInicialCentimos(request.montoInicialCentimos());
        }
        sesionCaja.setMontoFinalEsperadoCentimos(request.montoFinalEsperadoCentimos());
        sesionCaja.setMontoFinalRealCentimos(request.montoFinalRealCentimos());
        if (request.fechaApertura() != null) {
            sesionCaja.setFechaApertura(request.fechaApertura());
        }
        sesionCaja.setFechaCierre(request.fechaCierre());
        if (request.estaAbierta() != null) {
            sesionCaja.setEstaAbierta(request.estaAbierta());
        }
        sesionCaja.setUsuarioCierreId(request.usuarioCierreId());
        SesionCaja actualizada = (SesionCaja)this.sesionCajaRepository.save((Object)sesionCaja);
        return this.toResponse(actualizada);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long sesionId) {
        SesionCaja sesionCaja = this.obtenerSesion(tiendaId, sesionId);
        this.sesionCajaRepository.delete((Object)sesionCaja);
    }

    private SesionCaja obtenerSesion(Long tiendaId, Long sesionId) {
        return (SesionCaja)this.sesionCajaRepository.findByIdAndTiendaId(sesionId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Sesi\u00f3n de caja no encontrada"));
    }

    private void validarCajaPerteneceATienda(Long tiendaId, Long cajaId) {
        if (cajaId == null) {
            throw new BadRequestException("La caja es obligatoria para la sesi\u00f3n");
        }
        this.cajaRepository.findByIdAndTiendaId(cajaId, tiendaId).orElseThrow(() -> new BadRequestException("La caja indicada no pertenece a la tienda"));
    }

    private SesionCajaResponse toResponse(SesionCaja sesionCaja) {
        return SesionCajaResponse.builder().id(sesionCaja.getId()).tiendaId(sesionCaja.getTiendaId()).cajaId(sesionCaja.getCajaId()).usuarioAperturaId(sesionCaja.getUsuarioAperturaId()).usuarioCierreId(sesionCaja.getUsuarioCierreId()).montoInicialCentimos(sesionCaja.getMontoInicialCentimos()).montoFinalEsperadoCentimos(sesionCaja.getMontoFinalEsperadoCentimos()).montoFinalRealCentimos(sesionCaja.getMontoFinalRealCentimos()).diferenciaCentimos(sesionCaja.getDiferenciaCentimos() == null ? null : Long.valueOf(sesionCaja.getDiferenciaCentimos().longValue())).fechaApertura(sesionCaja.getFechaApertura()).fechaCierre(sesionCaja.getFechaCierre()).estaAbierta(sesionCaja.getEstaAbierta()).build();
    }

    @Generated
    public SesionCajaAdminService(SesionCajaRepository sesionCajaRepository, CajaRepository cajaRepository) {
        this.sesionCajaRepository = sesionCajaRepository;
        this.cajaRepository = cajaRepository;
    }
}

