/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.service.impl;

import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioProductoResponse;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioProductoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.MovimientoInventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.MotivoMovimientoProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.TipoMovimientoInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.MovimientoInventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.service.IInventarioProductoService;
import com.dulcecontrol.bakery.features.admin.produccion.entity.DetallePlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.PlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoItemProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoPlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.OrigenItemProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.repository.DetallePlanProduccionRepository;
import com.dulcecontrol.bakery.features.admin.produccion.repository.PlanProduccionRepository;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PedidoCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PedidoResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PedidoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.DetallePedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.Pedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.EstadoPagoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.EstadoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.TipoEntregaPedido;
import com.dulcecontrol.bakery.features.admin.ventas.repository.DetallePedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.PedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.SesionCajaRepository;
import com.dulcecontrol.bakery.features.admin.ventas.service.IPedidoAdminService;
import com.dulcecontrol.bakery.features.admin.ventas.service.helper.VentasTenantValidator;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PedidoAdminService
implements IPedidoAdminService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PedidoAdminService.class);
    private final PedidoRepository pedidoRepository;
    private final SesionCajaRepository sesionCajaRepository;
    private final VentasTenantValidator tenantValidator;
    private final DetallePedidoRepository detallePedidoRepository;
    private final IInventarioProductoService inventarioProductoService;
    private final PlanProduccionRepository planProduccionRepository;
    private final DetallePlanProduccionRepository detallePlanProduccionRepository;
    private final InventarioProductoRepository inventarioProductoRepository;
    private final MovimientoInventarioProductoRepository movimientoProductoRepository;

    @Transactional(readOnly=true)
    public List<PedidoResponse> listar(Long tiendaId, Long sedeId, EstadoPedido estadoPedido, EstadoPagoPedido estadoPago, TipoEntregaPedido tipoEntrega, LocalDateTime fechaDesde, LocalDateTime fechaHasta) {
        if (sedeId != null) {
            this.tenantValidator.validarSedePerteneceATienda(tiendaId, sedeId);
        }
        if (fechaDesde != null && fechaHasta != null && fechaDesde.isAfter(fechaHasta)) {
            throw new BadRequestException("La fecha inicial no puede ser mayor a la fecha final");
        }
        List pedidos = this.pedidoRepository.buscarPorFiltros(tiendaId, sedeId, estadoPedido, estadoPago, tipoEntrega, fechaDesde, fechaHasta);
        return pedidos.stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public PedidoResponse obtener(Long tiendaId, Long pedidoId) {
        Pedido pedido = this.obtenerPedido(tiendaId, pedidoId);
        return this.toResponse(pedido);
    }

    @Transactional
    public PedidoResponse crear(Long tiendaId, PedidoCreateRequest request) {
        if (this.pedidoRepository.existsByTiendaIdAndCodigoPedidoIgnoreCase(tiendaId, request.codigoPedido())) {
            throw new BadRequestException("El c\u00f3digo de pedido ya est\u00e1 registrado para la tienda");
        }
        this.tenantValidator.validarSedePerteneceATienda(tiendaId, request.sedeOrigenId());
        this.tenantValidator.validarClientePerteneceATienda(tiendaId, request.clienteId());
        this.validarSesionPerteneceATienda(tiendaId, request.sesionCajaId());
        Pedido pedido = new Pedido();
        pedido.setCodigoPedido(request.codigoPedido());
        pedido.setTiendaId(tiendaId);
        pedido.setSedeOrigenId(request.sedeOrigenId());
        pedido.setClienteId(request.clienteId());
        pedido.setOrigen(request.origen());
        pedido.setSesionCajaId(request.sesionCajaId());
        pedido.setVendedorId(request.vendedorId());
        pedido.setEstadoPedido(request.estadoPedido());
        pedido.setEstadoPago(request.estadoPago());
        pedido.setTipoEntrega(request.tipoEntrega());
        pedido.setFechaEntregaPactada(request.fechaEntregaPactada());
        pedido.setDireccionEntrega(request.direccionEntrega());
        pedido.setCostoDeliveryCentimos(this.valorPorDefecto(request.costoDeliveryCentimos(), Long.valueOf(0L)));
        pedido.setMoneda(request.moneda() != null ? request.moneda() : "PEN");
        pedido.setSubtotalItemsCentimos(request.subtotalItemsCentimos());
        pedido.setDescuentoTotalCentimos(this.valorPorDefecto(request.descuentoTotalCentimos(), Long.valueOf(0L)));
        pedido.setImpuestosTotalesCentimos(this.valorPorDefecto(request.impuestosTotalesCentimos(), Long.valueOf(0L)));
        pedido.setTotalFinalCentimos(request.totalFinalCentimos());
        pedido.setMontoPagadoCentimos(this.valorPorDefecto(request.montoPagadoCentimos(), Long.valueOf(0L)));
        pedido.setRequiereComprobante(request.requiereComprobante() == null ? Boolean.TRUE : request.requiereComprobante());
        pedido.setTipoComprobante(request.tipoComprobante());
        pedido.setSerieComprobante(request.serieComprobante());
        pedido.setNumeroComprobante(request.numeroComprobante());
        pedido.setNotasPedido(request.notasPedido());
        Pedido guardado = (Pedido)this.pedidoRepository.save((Object)pedido);
        return this.toResponse(guardado);
    }

    @Transactional
    public PedidoResponse actualizar(Long tiendaId, Long pedidoId, PedidoUpdateRequest request) {
        Pedido pedido = this.obtenerPedido(tiendaId, pedidoId);
        if (this.pedidoRepository.existsByTiendaIdAndCodigoPedidoIgnoreCaseAndIdNot(tiendaId, request.codigoPedido(), pedidoId)) {
            throw new BadRequestException("El c\u00f3digo de pedido ya est\u00e1 registrado para la tienda");
        }
        this.tenantValidator.validarSedePerteneceATienda(tiendaId, request.sedeOrigenId());
        this.tenantValidator.validarClientePerteneceATienda(tiendaId, request.clienteId());
        this.validarSesionPerteneceATienda(tiendaId, request.sesionCajaId());
        EstadoPedido estadoAnterior = pedido.getEstadoPedido();
        pedido.setCodigoPedido(request.codigoPedido());
        pedido.setSedeOrigenId(request.sedeOrigenId());
        pedido.setClienteId(request.clienteId());
        pedido.setOrigen(request.origen());
        pedido.setSesionCajaId(request.sesionCajaId());
        pedido.setVendedorId(request.vendedorId());
        pedido.setEstadoPedido(request.estadoPedido());
        pedido.setEstadoPago(request.estadoPago());
        pedido.setTipoEntrega(request.tipoEntrega());
        pedido.setFechaEntregaPactada(request.fechaEntregaPactada());
        pedido.setDireccionEntrega(request.direccionEntrega());
        pedido.setCostoDeliveryCentimos(this.valorPorDefecto(request.costoDeliveryCentimos(), Long.valueOf(0L)));
        pedido.setMoneda(request.moneda() != null ? request.moneda() : "PEN");
        pedido.setSubtotalItemsCentimos(request.subtotalItemsCentimos());
        pedido.setDescuentoTotalCentimos(this.valorPorDefecto(request.descuentoTotalCentimos(), Long.valueOf(0L)));
        pedido.setImpuestosTotalesCentimos(this.valorPorDefecto(request.impuestosTotalesCentimos(), Long.valueOf(0L)));
        pedido.setTotalFinalCentimos(request.totalFinalCentimos());
        pedido.setMontoPagadoCentimos(this.valorPorDefecto(request.montoPagadoCentimos(), Long.valueOf(0L)));
        if (request.requiereComprobante() != null) {
            pedido.setRequiereComprobante(request.requiereComprobante());
        }
        pedido.setTipoComprobante(request.tipoComprobante());
        pedido.setSerieComprobante(request.serieComprobante());
        pedido.setNumeroComprobante(request.numeroComprobante());
        pedido.setNotasPedido(request.notasPedido());
        Pedido actualizado = (Pedido)this.pedidoRepository.save((Object)pedido);
        if (request.estadoPedido() == EstadoPedido.EN_PREPARACION && estadoAnterior != EstadoPedido.EN_PREPARACION) {
            this.generarPlanificacionParaPedido(tiendaId, pedido);
        }
        if (request.estadoPedido() == EstadoPedido.ENTREGADO && estadoAnterior != EstadoPedido.ENTREGADO) {
            this.descontarInventarioPorVenta(tiendaId, pedido);
        }
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long pedidoId) {
        Pedido pedido = this.obtenerPedido(tiendaId, pedidoId);
        this.pedidoRepository.delete((Object)pedido);
    }

    private void validarSesionPerteneceATienda(Long tiendaId, Long sesionCajaId) {
        if (sesionCajaId == null) {
            return;
        }
        this.sesionCajaRepository.findByIdAndTiendaId(sesionCajaId, tiendaId).orElseThrow(() -> new BadRequestException("La sesi\u00f3n de caja indicada no pertenece a la tienda"));
    }

    private Pedido obtenerPedido(Long tiendaId, Long pedidoId) {
        return (Pedido)this.pedidoRepository.findByIdAndTiendaId(pedidoId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Pedido no encontrado"));
    }

    private Long valorPorDefecto(Long valor, Long porDefecto) {
        return valor == null ? porDefecto : valor;
    }

    private PedidoResponse toResponse(Pedido pedido) {
        return PedidoResponse.builder().id(pedido.getId()).tiendaId(pedido.getTiendaId()).codigoPedido(pedido.getCodigoPedido()).sedeOrigenId(pedido.getSedeOrigenId()).clienteId(pedido.getClienteId()).origen(pedido.getOrigen()).sesionCajaId(pedido.getSesionCajaId()).vendedorId(pedido.getVendedorId()).estadoPedido(pedido.getEstadoPedido()).estadoPago(pedido.getEstadoPago()).tipoEntrega(pedido.getTipoEntrega()).fechaEntregaPactada(pedido.getFechaEntregaPactada()).direccionEntrega(pedido.getDireccionEntrega()).costoDeliveryCentimos(pedido.getCostoDeliveryCentimos()).moneda(pedido.getMoneda()).subtotalItemsCentimos(pedido.getSubtotalItemsCentimos()).descuentoTotalCentimos(pedido.getDescuentoTotalCentimos()).impuestosTotalesCentimos(pedido.getImpuestosTotalesCentimos()).totalFinalCentimos(pedido.getTotalFinalCentimos()).montoPagadoCentimos(pedido.getMontoPagadoCentimos()).saldoPendienteCentimos(pedido.getSaldoPendienteCentimos() == null ? null : Long.valueOf(pedido.getSaldoPendienteCentimos().longValue())).requiereComprobante(pedido.getRequiereComprobante()).tipoComprobante(pedido.getTipoComprobante()).serieComprobante(pedido.getSerieComprobante()).numeroComprobante(pedido.getNumeroComprobante()).notasPedido(pedido.getNotasPedido()).creadoEn(pedido.getCreadoEn()).actualizadoEn(pedido.getActualizadoEn()).build();
    }

    private void descontarInventarioPorVenta(Long tiendaId, Pedido pedido) {
        log.info("\ud83d\udce6 Pedido {} ENTREGADO. Descontando inventario de productos vendidos...", (Object)pedido.getCodigoPedido());
        List detalles = this.detallePedidoRepository.findByPedidoId(pedido.getId());
        if (detalles.isEmpty()) {
            log.warn("\u26a0\ufe0f El pedido {} no tiene detalles", (Object)pedido.getCodigoPedido());
            return;
        }
        Long sedeId = pedido.getSedeOrigenId();
        List inventarios = this.inventarioProductoService.listarPorTiendaYSede(tiendaId, sedeId);
        for (DetallePedido detalle : detalles) {
            Long productoId = detalle.getProductoId();
            Integer cantidadVendida = detalle.getCantidad();
            Optional<InventarioProductoResponse> inventarioOpt = inventarios.stream().filter(inv -> inv.getProductoId().equals(productoId)).findFirst();
            if (inventarioOpt.isEmpty()) {
                log.error("\u274c No se encontr\u00f3 inventario del producto {} en sede {}. No se puede descontar.", (Object)productoId, (Object)sedeId);
                continue;
            }
            InventarioProductoResponse inventario = inventarioOpt.get();
            Integer cantidadActual = inventario.getCantidadActual();
            if (cantidadActual < cantidadVendida) {
                log.warn("\u26a0\ufe0f Inventario insuficiente del producto {}. Disponible: {}, Vendido: {}. Se descontar\u00e1 lo disponible.", new Object[]{productoId, cantidadActual, cantidadVendida});
            }
            Integer nuevaCantidad = Math.max(0, cantidadActual - cantidadVendida);
            MovimientoInventarioProducto movimiento = new MovimientoInventarioProducto();
            movimiento.setTiendaId(tiendaId);
            movimiento.setSedeId(sedeId);
            movimiento.setProductoId(productoId);
            movimiento.setTipoMovimiento(TipoMovimientoInsumo.SALIDA);
            movimiento.setCantidad(cantidadVendida);
            movimiento.setCantidadAnterior(cantidadActual);
            movimiento.setCantidadPosterior(nuevaCantidad);
            movimiento.setPedidoId(pedido.getId());
            movimiento.setMotivo(MotivoMovimientoProducto.VENTA);
            this.movimientoProductoRepository.save((Object)movimiento);
            log.info("\u2705 Movimiento registrado: VENTA de {} unidades del producto #{}", (Object)cantidadVendida, (Object)productoId);
            InventarioProductoUpdateRequest updateRequest = InventarioProductoUpdateRequest.builder().sedeId(inventario.getSedeId()).productoId(inventario.getProductoId()).cantidadActual(nuevaCantidad).ubicacionFisica(inventario.getUbicacionFisica()).build();
            try {
                this.inventarioProductoService.actualizar(tiendaId, inventario.getId(), updateRequest);
                log.info("\u2705 Descontado {} unidades del producto {}. Stock anterior: {}, Stock nuevo: {}", new Object[]{cantidadVendida, productoId, cantidadActual, nuevaCantidad});
            }
            catch (Exception e) {
                log.error("\u274c Error al actualizar inventario del producto {}: {}", (Object)productoId, (Object)e.getMessage());
            }
        }
        log.info("\u2705 Inventario actualizado para pedido {}. {} productos procesados.", (Object)pedido.getCodigoPedido(), (Object)detalles.size());
    }

    private void generarPlanificacionParaPedido(Long tiendaId, Pedido pedido) {
        PlanProduccion plan;
        log.info("\ud83d\udccb Pedido {} cambi\u00f3 a EN_PREPARACION. Generando planificaci\u00f3n de producci\u00f3n...", (Object)pedido.getCodigoPedido());
        List detalles = this.detallePedidoRepository.findByPedidoId(pedido.getId());
        if (detalles.isEmpty()) {
            log.warn("\u26a0\ufe0f El pedido {} no tiene detalles", (Object)pedido.getCodigoPedido());
            return;
        }
        LocalDate fechaProduccion = pedido.getFechaEntregaPactada() != null ? pedido.getFechaEntregaPactada().toLocalDate() : LocalDate.now().plusDays(1L);
        log.info("\ud83d\udcc5 Fecha de producci\u00f3n calculada: {} (Fecha entrega pactada: {})", (Object)fechaProduccion, (Object)pedido.getFechaEntregaPactada());
        Optional planOpt = this.planProduccionRepository.findBySedeIdAndFechaProduccion(pedido.getSedeOrigenId(), fechaProduccion);
        if (planOpt.isPresent()) {
            plan = (PlanProduccion)planOpt.get();
            if (plan.getEstado() == EstadoPlanProduccion.FINALIZADO) {
                log.info("\ud83d\udd04 Plan para {} est\u00e1 FINALIZADO. Reabriendo a CONFIRMADO para agregar pedido {}...", (Object)fechaProduccion, (Object)pedido.getCodigoPedido());
                plan.setEstado(EstadoPlanProduccion.CONFIRMADO);
                plan.setNotasMaestro((String)(plan.getNotasMaestro() != null ? plan.getNotasMaestro() + " | " : "") + "Reabierto para pedido " + pedido.getCodigoPedido());
                plan = (PlanProduccion)this.planProduccionRepository.save((Object)plan);
            } else {
                log.info("\ud83d\udccb Plan existente encontrado para fecha {} (estado: {})", (Object)fechaProduccion, (Object)plan.getEstado());
            }
        } else {
            log.info("\ud83c\udf86 Creando nuevo plan de producci\u00f3n para pedido {} en fecha {}", (Object)pedido.getCodigoPedido(), (Object)fechaProduccion);
            plan = new PlanProduccion();
            plan.setTiendaId(tiendaId);
            plan.setSedeId(pedido.getSedeOrigenId());
            plan.setFechaProduccion(fechaProduccion);
            plan.setEstado(EstadoPlanProduccion.CONFIRMADO);
            plan.setNotasMaestro("Plan generado para pedido " + pedido.getCodigoPedido());
            plan = (PlanProduccion)this.planProduccionRepository.save((Object)plan);
        }
        List detallesExistentes = this.detallePlanProduccionRepository.findByPlanIdOrderByIdAsc(plan.getId());
        for (DetallePedido detalle : detalles) {
            DetallePlanProduccion detallePlan;
            Optional<DetallePlanProduccion> detalleExistenteOpt = detallesExistentes.stream().filter(d -> d.getProductoId().equals(detalle.getProductoId()) && d.getOrigen() == OrigenItemProduccion.PEDIDO_CLIENTE && d.getPedidoClienteId() != null && d.getPedidoClienteId().equals(pedido.getId())).findFirst();
            if (detalleExistenteOpt.isPresent()) {
                Optional inventarioOpt;
                detallePlan = detalleExistenteOpt.get();
                Integer cantidadPlanificadaAnterior = detallePlan.getCantidadPlanificada();
                Integer cantidadProducidaAnterior = detallePlan.getCantidadProducida();
                log.info("\ud83d\udd04 Detalle existente encontrado para producto {} del pedido {}. Actualizando...", (Object)detalle.getProductoId(), (Object)pedido.getCodigoPedido());
                log.info("   Planificado anterior: {}, Producido anterior: {}", (Object)cantidadPlanificadaAnterior, (Object)cantidadProducidaAnterior);
                if (cantidadProducidaAnterior != null && cantidadProducidaAnterior > 0 && (inventarioOpt = this.inventarioProductoRepository.findBySedeIdAndProductoId(pedido.getSedeOrigenId(), detalle.getProductoId())).isPresent()) {
                    InventarioProducto inventario = (InventarioProducto)inventarioOpt.get();
                    Integer stockActual = inventario.getCantidadActual();
                    inventario.setCantidadActual(Integer.valueOf(stockActual - cantidadProducidaAnterior));
                    this.inventarioProductoRepository.save((Object)inventario);
                    log.info("\u2b05\ufe0f Ajustando inventario: restando {} unidades producidas anteriormente. Stock: {} -> {}", new Object[]{cantidadProducidaAnterior, stockActual, inventario.getCantidadActual()});
                }
                detallePlan.setCantidadSugerida(detalle.getCantidad());
                detallePlan.setCantidadPlanificada(detalle.getCantidad());
                detallePlan.setCantidadProducida(Integer.valueOf(0));
                detallePlan.setCantidadMerma(Integer.valueOf(0));
                detallePlan.setEstado(EstadoItemProduccion.PENDIENTE);
                detallePlan.setObservaciones("Producto del pedido " + pedido.getCodigoPedido() + " (actualizado)");
                log.info("\u270f\ufe0f Planificado actualizado: {} -> {} (cantidad del pedido)", (Object)cantidadPlanificadaAnterior, (Object)detallePlan.getCantidadPlanificada());
            } else {
                log.info("\u2795 Creando nuevo detalle para producto {} del pedido {}", (Object)detalle.getProductoId(), (Object)pedido.getCodigoPedido());
                detallePlan = new DetallePlanProduccion();
                detallePlan.setPlanId(plan.getId());
                detallePlan.setProductoId(detalle.getProductoId());
                detallePlan.setOrigen(OrigenItemProduccion.PEDIDO_CLIENTE);
                detallePlan.setPedidoClienteId(pedido.getId());
                detallePlan.setDetallePedidoId(detalle.getId());
                detallePlan.setEsPersonalizado(Boolean.valueOf(false));
                detallePlan.setCantidadSugerida(detalle.getCantidad());
                detallePlan.setCantidadPlanificada(detalle.getCantidad());
                detallePlan.setCantidadProducida(Integer.valueOf(0));
                detallePlan.setCantidadMerma(Integer.valueOf(0));
                detallePlan.setEstado(EstadoItemProduccion.PENDIENTE);
                detallePlan.setObservaciones("Producto del pedido " + pedido.getCodigoPedido());
            }
            this.detallePlanProduccionRepository.save((Object)detallePlan);
        }
        log.info("\u2705 Planificaci\u00f3n creada para pedido {}. {} productos agregados al plan {}", new Object[]{pedido.getCodigoPedido(), detalles.size(), plan.getId()});
    }

    @Generated
    public PedidoAdminService(PedidoRepository pedidoRepository, SesionCajaRepository sesionCajaRepository, VentasTenantValidator tenantValidator, DetallePedidoRepository detallePedidoRepository, IInventarioProductoService inventarioProductoService, PlanProduccionRepository planProduccionRepository, DetallePlanProduccionRepository detallePlanProduccionRepository, InventarioProductoRepository inventarioProductoRepository, MovimientoInventarioProductoRepository movimientoProductoRepository) {
        this.pedidoRepository = pedidoRepository;
        this.sesionCajaRepository = sesionCajaRepository;
        this.tenantValidator = tenantValidator;
        this.detallePedidoRepository = detallePedidoRepository;
        this.inventarioProductoService = inventarioProductoService;
        this.planProduccionRepository = planProduccionRepository;
        this.detallePlanProduccionRepository = detallePlanProduccionRepository;
        this.inventarioProductoRepository = inventarioProductoRepository;
        this.movimientoProductoRepository = movimientoProductoRepository;
    }
}

