/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.service.impl;

import com.dulcecontrol.bakery.features.admin.ventas.dto.MovimientoCajaCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.MovimientoCajaResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.MovimientoCajaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.MovimientoCaja;
import com.dulcecontrol.bakery.features.admin.ventas.repository.MovimientoCajaRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.SesionCajaRepository;
import com.dulcecontrol.bakery.features.admin.ventas.service.IMovimientoCajaAdminService;
import com.dulcecontrol.bakery.features.admin.ventas.service.helper.VentasTenantValidator;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MovimientoCajaAdminService
implements IMovimientoCajaAdminService {
    private final MovimientoCajaRepository movimientoCajaRepository;
    private final SesionCajaRepository sesionCajaRepository;
    private final VentasTenantValidator tenantValidator;

    @Transactional(readOnly=true)
    public List<MovimientoCajaResponse> listar(Long tiendaId, Long sesionCajaId) {
        this.validarSesionPerteneceATienda(tiendaId, sesionCajaId);
        return this.movimientoCajaRepository.findBySesionCajaIdOrderByCreadoEnDesc(sesionCajaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public MovimientoCajaResponse obtener(Long tiendaId, Long sesionCajaId, Long movimientoId) {
        this.validarSesionPerteneceATienda(tiendaId, sesionCajaId);
        MovimientoCaja movimiento = this.obtenerMovimiento(sesionCajaId, movimientoId);
        return this.toResponse(movimiento);
    }

    @Transactional
    public MovimientoCajaResponse crear(Long tiendaId, Long sesionCajaId, MovimientoCajaCreateRequest request) {
        this.validarSesionPerteneceATienda(tiendaId, sesionCajaId);
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, request.pedidoId());
        MovimientoCaja movimiento = new MovimientoCaja();
        movimiento.setSesionCajaId(sesionCajaId);
        movimiento.setTipoMovimiento(request.tipoMovimiento());
        movimiento.setMontoCentimos(request.montoCentimos());
        movimiento.setMetodoPago(request.metodoPago());
        movimiento.setPedidoId(request.pedidoId());
        movimiento.setConcepto(request.concepto());
        movimiento.setComprobanteAsociado(request.comprobanteAsociado());
        MovimientoCaja guardado = (MovimientoCaja)this.movimientoCajaRepository.save((Object)movimiento);
        return this.toResponse(guardado);
    }

    @Transactional
    public MovimientoCajaResponse actualizar(Long tiendaId, Long sesionCajaId, Long movimientoId, MovimientoCajaUpdateRequest request) {
        this.validarSesionPerteneceATienda(tiendaId, sesionCajaId);
        MovimientoCaja movimiento = this.obtenerMovimiento(sesionCajaId, movimientoId);
        this.tenantValidator.validarPedidoPerteneceATienda(tiendaId, request.pedidoId());
        movimiento.setTipoMovimiento(request.tipoMovimiento());
        movimiento.setMontoCentimos(request.montoCentimos());
        movimiento.setMetodoPago(request.metodoPago());
        movimiento.setPedidoId(request.pedidoId());
        movimiento.setConcepto(request.concepto());
        movimiento.setComprobanteAsociado(request.comprobanteAsociado());
        MovimientoCaja actualizado = (MovimientoCaja)this.movimientoCajaRepository.save((Object)movimiento);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long sesionCajaId, Long movimientoId) {
        this.validarSesionPerteneceATienda(tiendaId, sesionCajaId);
        MovimientoCaja movimiento = this.obtenerMovimiento(sesionCajaId, movimientoId);
        this.movimientoCajaRepository.delete((Object)movimiento);
    }

    private void validarSesionPerteneceATienda(Long tiendaId, Long sesionCajaId) {
        if (sesionCajaId == null) {
            throw new BadRequestException("La sesi\u00f3n de caja es requerida");
        }
        this.sesionCajaRepository.findByIdAndTiendaId(sesionCajaId, tiendaId).orElseThrow(() -> new BadRequestException("La sesi\u00f3n de caja indicada no pertenece a la tienda"));
    }

    private MovimientoCaja obtenerMovimiento(Long sesionCajaId, Long movimientoId) {
        return (MovimientoCaja)this.movimientoCajaRepository.findByIdAndSesionCajaId(movimientoId, sesionCajaId).orElseThrow(() -> new ResourceNotFoundException("Movimiento de caja no encontrado"));
    }

    private MovimientoCajaResponse toResponse(MovimientoCaja movimiento) {
        return MovimientoCajaResponse.builder().id(movimiento.getId()).sesionCajaId(movimiento.getSesionCajaId()).tipoMovimiento(movimiento.getTipoMovimiento()).montoCentimos(movimiento.getMontoCentimos()).metodoPago(movimiento.getMetodoPago()).pedidoId(movimiento.getPedidoId()).concepto(movimiento.getConcepto()).comprobanteAsociado(movimiento.getComprobanteAsociado()).creadoEn(movimiento.getCreadoEn()).actualizadoEn(movimiento.getActualizadoEn()).build();
    }

    @Generated
    public MovimientoCajaAdminService(MovimientoCajaRepository movimientoCajaRepository, SesionCajaRepository sesionCajaRepository, VentasTenantValidator tenantValidator) {
        this.movimientoCajaRepository = movimientoCajaRepository;
        this.sesionCajaRepository = sesionCajaRepository;
        this.tenantValidator = tenantValidator;
    }
}

