/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.service.impl;

import com.dulcecontrol.bakery.features.admin.ventas.dto.CajaCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.CajaResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.CajaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.entity.Caja;
import com.dulcecontrol.bakery.features.admin.ventas.repository.CajaRepository;
import com.dulcecontrol.bakery.features.admin.ventas.service.ICajaAdminService;
import com.dulcecontrol.bakery.features.admin.ventas.service.helper.VentasTenantValidator;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CajaAdminService
implements ICajaAdminService {
    private final CajaRepository cajaRepository;
    private final VentasTenantValidator tenantValidator;

    @Transactional(readOnly=true)
    public List<CajaResponse> listar(Long tiendaId, Long sedeId) {
        List cajas;
        if (sedeId != null) {
            this.tenantValidator.validarSedePerteneceATienda(tiendaId, sedeId);
            cajas = this.cajaRepository.findByTiendaIdAndSedeIdOrderByNombreAsc(tiendaId, sedeId);
        } else {
            cajas = this.cajaRepository.findByTiendaIdOrderByNombreAsc(tiendaId);
        }
        return cajas.stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public CajaResponse obtener(Long tiendaId, Long cajaId) {
        Caja caja = this.obtenerCaja(tiendaId, cajaId);
        return this.toResponse(caja);
    }

    @Transactional
    public CajaResponse crear(Long tiendaId, CajaCreateRequest request) {
        if (this.cajaRepository.existsByTiendaIdAndNombreIgnoreCase(tiendaId, request.nombre())) {
            throw new BadRequestException("El nombre de la caja ya est\u00e1 registrado para la tienda");
        }
        this.tenantValidator.validarSedePerteneceATienda(tiendaId, request.sedeId());
        Caja caja = new Caja();
        caja.setTiendaId(tiendaId);
        caja.setSedeId(request.sedeId());
        caja.setNombre(request.nombre());
        caja.setActiva(request.activa() == null ? Boolean.TRUE : request.activa());
        Caja guardada = (Caja)this.cajaRepository.save((Object)caja);
        return this.toResponse(guardada);
    }

    @Transactional
    public CajaResponse actualizar(Long tiendaId, Long cajaId, CajaUpdateRequest request) {
        Caja caja = this.obtenerCaja(tiendaId, cajaId);
        if (this.cajaRepository.existsByTiendaIdAndNombreIgnoreCaseAndIdNot(tiendaId, request.nombre(), cajaId)) {
            throw new BadRequestException("El nombre de la caja ya est\u00e1 registrado para la tienda");
        }
        this.tenantValidator.validarSedePerteneceATienda(tiendaId, request.sedeId());
        caja.setSedeId(request.sedeId());
        caja.setNombre(request.nombre());
        if (request.activa() != null) {
            caja.setActiva(request.activa());
        }
        Caja actualizada = (Caja)this.cajaRepository.save((Object)caja);
        return this.toResponse(actualizada);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long cajaId) {
        Caja caja = this.obtenerCaja(tiendaId, cajaId);
        this.cajaRepository.delete((Object)caja);
    }

    private Caja obtenerCaja(Long tiendaId, Long cajaId) {
        return (Caja)this.cajaRepository.findByIdAndTiendaId(cajaId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Caja no encontrada"));
    }

    private CajaResponse toResponse(Caja caja) {
        return CajaResponse.builder().id(caja.getId()).tiendaId(caja.getTiendaId()).sedeId(caja.getSedeId()).nombre(caja.getNombre()).activa(caja.getActiva()).creadoEn(caja.getCreadoEn()).build();
    }

    @Generated
    public CajaAdminService(CajaRepository cajaRepository, VentasTenantValidator tenantValidator) {
        this.cajaRepository = cajaRepository;
        this.tenantValidator = tenantValidator;
    }
}

