/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.entity;

import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.EstadoPagoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.EstadoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.OrigenPedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.TipoComprobantePedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.TipoEntregaPedido;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="pedidos", uniqueConstraints={@UniqueConstraint(name="uk_pedidos_tienda_codigo", columnNames={"tienda_id", "codigo_pedido"})})
public class Pedido {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="codigo_pedido", nullable=false, length=50)
    private String codigoPedido;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="sede_origen_id", nullable=false)
    private Long sedeOrigenId;
    @Column(name="cliente_id")
    private Long clienteId;
    @Column(name="origen", nullable=false, columnDefinition="ENUM('pos_local','storefront_online','telefono')")
    private OrigenPedido origen = OrigenPedido.POS_LOCAL;
    @Column(name="sesion_caja_id")
    private Long sesionCajaId;
    @Column(name="vendedor_id")
    private Long vendedorId;
    @Column(name="estado_pedido", nullable=false, columnDefinition="ENUM('borrador','pendiente_pago','pagado','en_preparacion','listo_entrega','entregado','cancelado','devuelto')")
    private EstadoPedido estadoPedido = EstadoPedido.PENDIENTE_PAGO;
    @Column(name="estado_pago", nullable=false, columnDefinition="ENUM('pendiente','parcial','pagado_total','reembolsado')")
    private EstadoPagoPedido estadoPago = EstadoPagoPedido.PENDIENTE;
    @Column(name="tipo_entrega", nullable=false, columnDefinition="ENUM('recojo_tienda','delivery','consumo_local')")
    private TipoEntregaPedido tipoEntrega = TipoEntregaPedido.RECOJO_TIENDA;
    @Column(name="fecha_entrega_pactada", nullable=false)
    private LocalDateTime fechaEntregaPactada;
    @Column(name="direccion_entrega", columnDefinition="TEXT")
    private String direccionEntrega;
    @Column(name="costo_delivery_centimos")
    private Long costoDeliveryCentimos = 0L;
    @Column(name="moneda", nullable=false, columnDefinition="char(3)")
    private String moneda = "PEN";
    @Column(name="subtotal_items_centimos", nullable=false)
    private Long subtotalItemsCentimos;
    @Column(name="descuento_total_centimos", nullable=false)
    private Long descuentoTotalCentimos = 0L;
    @Column(name="impuestos_totales_centimos", nullable=false)
    private Long impuestosTotalesCentimos = 0L;
    @Column(name="total_final_centimos", nullable=false)
    private Long totalFinalCentimos;
    @Column(name="monto_pagado_centimos", nullable=false)
    private Long montoPagadoCentimos = 0L;
    @Column(name="saldo_pendiente_centimos", insertable=false, updatable=false, columnDefinition="int")
    private Integer saldoPendienteCentimos;
    @Column(name="requiere_comprobante", nullable=false)
    private Boolean requiereComprobante = Boolean.TRUE;
    @Column(name="tipo_comprobante", columnDefinition="ENUM('factura','boleta','nota_credito','nota_debito')")
    private TipoComprobantePedido tipoComprobante;
    @Column(name="serie_comprobante", length=20)
    private String serieComprobante;
    @Column(name="numero_comprobante", length=20)
    private String numeroComprobante;
    @Column(name="notas_pedido", columnDefinition="TEXT")
    private String notasPedido;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        if (this.fechaEntregaPactada == null) {
            this.fechaEntregaPactada = LocalDateTime.now();
        }
        if (this.costoDeliveryCentimos == null) {
            this.costoDeliveryCentimos = 0L;
        }
        if (this.descuentoTotalCentimos == null) {
            this.descuentoTotalCentimos = 0L;
        }
        if (this.impuestosTotalesCentimos == null) {
            this.impuestosTotalesCentimos = 0L;
        }
        if (this.montoPagadoCentimos == null) {
            this.montoPagadoCentimos = 0L;
        }
        if (this.requiereComprobante == null) {
            this.requiereComprobante = Boolean.TRUE;
        }
        if (this.moneda == null) {
            this.moneda = "PEN";
        }
        if (this.creadoEn == null) {
            this.creadoEn = LocalDateTime.now();
        }
        if (this.actualizadoEn == null) {
            this.actualizadoEn = this.creadoEn;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
        if (this.moneda == null) {
            this.moneda = "PEN";
        }
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCodigoPedido() {
        return this.codigoPedido;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getSedeOrigenId() {
        return this.sedeOrigenId;
    }

    @Generated
    public Long getClienteId() {
        return this.clienteId;
    }

    @Generated
    public OrigenPedido getOrigen() {
        return this.origen;
    }

    @Generated
    public Long getSesionCajaId() {
        return this.sesionCajaId;
    }

    @Generated
    public Long getVendedorId() {
        return this.vendedorId;
    }

    @Generated
    public EstadoPedido getEstadoPedido() {
        return this.estadoPedido;
    }

    @Generated
    public EstadoPagoPedido getEstadoPago() {
        return this.estadoPago;
    }

    @Generated
    public TipoEntregaPedido getTipoEntrega() {
        return this.tipoEntrega;
    }

    @Generated
    public LocalDateTime getFechaEntregaPactada() {
        return this.fechaEntregaPactada;
    }

    @Generated
    public String getDireccionEntrega() {
        return this.direccionEntrega;
    }

    @Generated
    public Long getCostoDeliveryCentimos() {
        return this.costoDeliveryCentimos;
    }

    @Generated
    public String getMoneda() {
        return this.moneda;
    }

    @Generated
    public Long getSubtotalItemsCentimos() {
        return this.subtotalItemsCentimos;
    }

    @Generated
    public Long getDescuentoTotalCentimos() {
        return this.descuentoTotalCentimos;
    }

    @Generated
    public Long getImpuestosTotalesCentimos() {
        return this.impuestosTotalesCentimos;
    }

    @Generated
    public Long getTotalFinalCentimos() {
        return this.totalFinalCentimos;
    }

    @Generated
    public Long getMontoPagadoCentimos() {
        return this.montoPagadoCentimos;
    }

    @Generated
    public Integer getSaldoPendienteCentimos() {
        return this.saldoPendienteCentimos;
    }

    @Generated
    public Boolean getRequiereComprobante() {
        return this.requiereComprobante;
    }

    @Generated
    public TipoComprobantePedido getTipoComprobante() {
        return this.tipoComprobante;
    }

    @Generated
    public String getSerieComprobante() {
        return this.serieComprobante;
    }

    @Generated
    public String getNumeroComprobante() {
        return this.numeroComprobante;
    }

    @Generated
    public String getNotasPedido() {
        return this.notasPedido;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCodigoPedido(String codigoPedido) {
        this.codigoPedido = codigoPedido;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setSedeOrigenId(Long sedeOrigenId) {
        this.sedeOrigenId = sedeOrigenId;
    }

    @Generated
    public void setClienteId(Long clienteId) {
        this.clienteId = clienteId;
    }

    @Generated
    public void setOrigen(OrigenPedido origen) {
        this.origen = origen;
    }

    @Generated
    public void setSesionCajaId(Long sesionCajaId) {
        this.sesionCajaId = sesionCajaId;
    }

    @Generated
    public void setVendedorId(Long vendedorId) {
        this.vendedorId = vendedorId;
    }

    @Generated
    public void setEstadoPedido(EstadoPedido estadoPedido) {
        this.estadoPedido = estadoPedido;
    }

    @Generated
    public void setEstadoPago(EstadoPagoPedido estadoPago) {
        this.estadoPago = estadoPago;
    }

    @Generated
    public void setTipoEntrega(TipoEntregaPedido tipoEntrega) {
        this.tipoEntrega = tipoEntrega;
    }

    @Generated
    public void setFechaEntregaPactada(LocalDateTime fechaEntregaPactada) {
        this.fechaEntregaPactada = fechaEntregaPactada;
    }

    @Generated
    public void setDireccionEntrega(String direccionEntrega) {
        this.direccionEntrega = direccionEntrega;
    }

    @Generated
    public void setCostoDeliveryCentimos(Long costoDeliveryCentimos) {
        this.costoDeliveryCentimos = costoDeliveryCentimos;
    }

    @Generated
    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    @Generated
    public void setSubtotalItemsCentimos(Long subtotalItemsCentimos) {
        this.subtotalItemsCentimos = subtotalItemsCentimos;
    }

    @Generated
    public void setDescuentoTotalCentimos(Long descuentoTotalCentimos) {
        this.descuentoTotalCentimos = descuentoTotalCentimos;
    }

    @Generated
    public void setImpuestosTotalesCentimos(Long impuestosTotalesCentimos) {
        this.impuestosTotalesCentimos = impuestosTotalesCentimos;
    }

    @Generated
    public void setTotalFinalCentimos(Long totalFinalCentimos) {
        this.totalFinalCentimos = totalFinalCentimos;
    }

    @Generated
    public void setMontoPagadoCentimos(Long montoPagadoCentimos) {
        this.montoPagadoCentimos = montoPagadoCentimos;
    }

    @Generated
    public void setSaldoPendienteCentimos(Integer saldoPendienteCentimos) {
        this.saldoPendienteCentimos = saldoPendienteCentimos;
    }

    @Generated
    public void setRequiereComprobante(Boolean requiereComprobante) {
        this.requiereComprobante = requiereComprobante;
    }

    @Generated
    public void setTipoComprobante(TipoComprobantePedido tipoComprobante) {
        this.tipoComprobante = tipoComprobante;
    }

    @Generated
    public void setSerieComprobante(String serieComprobante) {
        this.serieComprobante = serieComprobante;
    }

    @Generated
    public void setNumeroComprobante(String numeroComprobante) {
        this.numeroComprobante = numeroComprobante;
    }

    @Generated
    public void setNotasPedido(String notasPedido) {
        this.notasPedido = notasPedido;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }
}

