/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.entity;

import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.MetodoPago;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.TipoMovimientoCaja;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="movimientos_caja")
public class MovimientoCaja {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="sesion_caja_id", nullable=false)
    private Long sesionCajaId;
    @Column(name="tipo_movimiento", nullable=false, columnDefinition="ENUM('venta','devolucion','gasto_operativo','retiro_efectivo','ingreso_efectivo','ajuste')")
    private TipoMovimientoCaja tipoMovimiento;
    @Column(name="monto_centimos", nullable=false)
    private Long montoCentimos;
    @Column(name="metodo_pago", columnDefinition="ENUM('efectivo','yape','plin','tarjeta_credito','tarjeta_debito','transferencia','pasarela_online')")
    private MetodoPago metodoPago;
    @Column(name="pedido_id")
    private Long pedidoId;
    @Column(columnDefinition="TEXT")
    private String concepto;
    @Column(name="comprobante_asociado", length=100)
    private String comprobanteAsociado;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        if (this.creadoEn == null) {
            this.creadoEn = LocalDateTime.now();
        }
        if (this.actualizadoEn == null) {
            this.actualizadoEn = this.creadoEn;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getSesionCajaId() {
        return this.sesionCajaId;
    }

    @Generated
    public TipoMovimientoCaja getTipoMovimiento() {
        return this.tipoMovimiento;
    }

    @Generated
    public Long getMontoCentimos() {
        return this.montoCentimos;
    }

    @Generated
    public MetodoPago getMetodoPago() {
        return this.metodoPago;
    }

    @Generated
    public Long getPedidoId() {
        return this.pedidoId;
    }

    @Generated
    public String getConcepto() {
        return this.concepto;
    }

    @Generated
    public String getComprobanteAsociado() {
        return this.comprobanteAsociado;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSesionCajaId(Long sesionCajaId) {
        this.sesionCajaId = sesionCajaId;
    }

    @Generated
    public void setTipoMovimiento(TipoMovimientoCaja tipoMovimiento) {
        this.tipoMovimiento = tipoMovimiento;
    }

    @Generated
    public void setMontoCentimos(Long montoCentimos) {
        this.montoCentimos = montoCentimos;
    }

    @Generated
    public void setMetodoPago(MetodoPago metodoPago) {
        this.metodoPago = metodoPago;
    }

    @Generated
    public void setPedidoId(Long pedidoId) {
        this.pedidoId = pedidoId;
    }

    @Generated
    public void setConcepto(String concepto) {
        this.concepto = concepto;
    }

    @Generated
    public void setComprobanteAsociado(String comprobanteAsociado) {
        this.comprobanteAsociado = comprobanteAsociado;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }
}

