/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.controller;

import com.dulcecontrol.bakery.features.admin.ventas.dto.SesionCajaCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.SesionCajaResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.SesionCajaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.service.ISesionCajaAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/ventas/sesiones-caja"})
@Validated
public class SesionCajaAdminController {
    private final ISesionCajaAdminService sesionCajaAdminService;

    @GetMapping
    public ResponseEntity<List<SesionCajaResponse>> listar(@PathVariable Long tiendaId, @RequestParam(value="cajaId", required=false) Long cajaId, @RequestParam(value="estaAbierta", required=false) Boolean estaAbierta) {
        return ResponseEntity.ok((Object)this.sesionCajaAdminService.listar(tiendaId, cajaId, estaAbierta));
    }

    @GetMapping(value={"/{sesionId}"})
    public ResponseEntity<SesionCajaResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long sesionId) {
        return ResponseEntity.ok((Object)this.sesionCajaAdminService.obtener(tiendaId, sesionId));
    }

    @PostMapping
    public ResponseEntity<SesionCajaResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody SesionCajaCreateRequest request) {
        SesionCajaResponse response = this.sesionCajaAdminService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{sesionId}"})
    public ResponseEntity<SesionCajaResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long sesionId, @Valid @RequestBody SesionCajaUpdateRequest request) {
        SesionCajaResponse response = this.sesionCajaAdminService.actualizar(tiendaId, sesionId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{sesionId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long sesionId) {
        this.sesionCajaAdminService.eliminar(tiendaId, sesionId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public SesionCajaAdminController(ISesionCajaAdminService sesionCajaAdminService) {
        this.sesionCajaAdminService = sesionCajaAdminService;
    }
}

