/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.controller;

import com.dulcecontrol.bakery.features.admin.ventas.dto.PersonalizacionItemCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PersonalizacionItemResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.PersonalizacionItemUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.service.IPersonalizacionItemPedidoAdminService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/ventas/pedidos/{pedidoId}/detalles/{detallePedidoId}/personalizacion"})
@Validated
public class PersonalizacionItemPedidoAdminController {
    private final IPersonalizacionItemPedidoAdminService personalizacionItemPedidoAdminService;

    @GetMapping
    public ResponseEntity<PersonalizacionItemResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long detallePedidoId) {
        return ResponseEntity.ok((Object)this.personalizacionItemPedidoAdminService.obtener(tiendaId, pedidoId, detallePedidoId));
    }

    @PostMapping
    public ResponseEntity<PersonalizacionItemResponse> crear(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long detallePedidoId, @Valid @RequestBody PersonalizacionItemCreateRequest request) {
        PersonalizacionItemResponse response = this.personalizacionItemPedidoAdminService.crear(tiendaId, pedidoId, detallePedidoId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping
    public ResponseEntity<PersonalizacionItemResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long detallePedidoId, @Valid @RequestBody PersonalizacionItemUpdateRequest request) {
        PersonalizacionItemResponse response = this.personalizacionItemPedidoAdminService.actualizar(tiendaId, pedidoId, detallePedidoId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long pedidoId, @PathVariable Long detallePedidoId) {
        this.personalizacionItemPedidoAdminService.eliminar(tiendaId, pedidoId, detallePedidoId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public PersonalizacionItemPedidoAdminController(IPersonalizacionItemPedidoAdminService personalizacionItemPedidoAdminService) {
        this.personalizacionItemPedidoAdminService = personalizacionItemPedidoAdminService;
    }
}

