/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.controller;

import com.dulcecontrol.bakery.features.admin.ventas.dto.MovimientoCajaCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.MovimientoCajaResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.MovimientoCajaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.service.IMovimientoCajaAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/ventas/sesiones-caja/{sesionCajaId}/movimientos"})
@Validated
public class MovimientoCajaAdminController {
    private final IMovimientoCajaAdminService movimientoCajaAdminService;

    @GetMapping
    public ResponseEntity<List<MovimientoCajaResponse>> listar(@PathVariable Long tiendaId, @PathVariable Long sesionCajaId) {
        return ResponseEntity.ok((Object)this.movimientoCajaAdminService.listar(tiendaId, sesionCajaId));
    }

    @GetMapping(value={"/{movimientoId}"})
    public ResponseEntity<MovimientoCajaResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long sesionCajaId, @PathVariable Long movimientoId) {
        return ResponseEntity.ok((Object)this.movimientoCajaAdminService.obtener(tiendaId, sesionCajaId, movimientoId));
    }

    @PostMapping
    public ResponseEntity<MovimientoCajaResponse> crear(@PathVariable Long tiendaId, @PathVariable Long sesionCajaId, @Valid @RequestBody MovimientoCajaCreateRequest request) {
        MovimientoCajaResponse response = this.movimientoCajaAdminService.crear(tiendaId, sesionCajaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{movimientoId}"})
    public ResponseEntity<MovimientoCajaResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long sesionCajaId, @PathVariable Long movimientoId, @Valid @RequestBody MovimientoCajaUpdateRequest request) {
        MovimientoCajaResponse response = this.movimientoCajaAdminService.actualizar(tiendaId, sesionCajaId, movimientoId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{movimientoId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long sesionCajaId, @PathVariable Long movimientoId) {
        this.movimientoCajaAdminService.eliminar(tiendaId, sesionCajaId, movimientoId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public MovimientoCajaAdminController(IMovimientoCajaAdminService movimientoCajaAdminService) {
        this.movimientoCajaAdminService = movimientoCajaAdminService;
    }
}

