/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ventas.controller;

import com.dulcecontrol.bakery.features.admin.ventas.dto.CajaCreateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.dto.CajaResponse;
import com.dulcecontrol.bakery.features.admin.ventas.dto.CajaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.ventas.service.ICajaAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/ventas/cajas"})
@Validated
public class CajaAdminController {
    private final ICajaAdminService cajaAdminService;

    @GetMapping
    public ResponseEntity<List<CajaResponse>> listar(@PathVariable Long tiendaId, @RequestParam(value="sedeId", required=false) Long sedeId) {
        return ResponseEntity.ok((Object)this.cajaAdminService.listar(tiendaId, sedeId));
    }

    @GetMapping(value={"/{cajaId}"})
    public ResponseEntity<CajaResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long cajaId) {
        return ResponseEntity.ok((Object)this.cajaAdminService.obtener(tiendaId, cajaId));
    }

    @PostMapping
    public ResponseEntity<CajaResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody CajaCreateRequest request) {
        CajaResponse response = this.cajaAdminService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{cajaId}"})
    public ResponseEntity<CajaResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long cajaId, @Valid @RequestBody CajaUpdateRequest request) {
        CajaResponse response = this.cajaAdminService.actualizar(tiendaId, cajaId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{cajaId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long cajaId) {
        this.cajaAdminService.eliminar(tiendaId, cajaId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public CajaAdminController(ICajaAdminService cajaAdminService) {
        this.cajaAdminService = cajaAdminService;
    }
}

