/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.ubigeo.controller;

import com.dulcecontrol.bakery.features.admin.ubigeo.dto.UbigeoDepartamentoResponse;
import com.dulcecontrol.bakery.features.admin.ubigeo.dto.UbigeoDistritoResponse;
import com.dulcecontrol.bakery.features.admin.ubigeo.dto.UbigeoProvinciaResponse;
import com.dulcecontrol.bakery.features.admin.ubigeo.dto.UbigeoRutaResponse;
import com.dulcecontrol.bakery.features.admin.ubigeo.service.IUbigeoAdminService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/ubigeo"})
public class UbigeoAdminController {
    private final IUbigeoAdminService ubigeoAdminService;

    @GetMapping(value={"/departamentos"})
    public ResponseEntity<List<UbigeoDepartamentoResponse>> listarDepartamentos() {
        return ResponseEntity.ok((Object)this.ubigeoAdminService.listarDepartamentos());
    }

    @GetMapping(value={"/departamentos/{departamentoId}/provincias"})
    public ResponseEntity<List<UbigeoProvinciaResponse>> listarProvincias(@PathVariable Long departamentoId) {
        return ResponseEntity.ok((Object)this.ubigeoAdminService.listarProvinciasPorDepartamento(departamentoId));
    }

    @GetMapping(value={"/provincias/{provinciaId}/distritos"})
    public ResponseEntity<List<UbigeoDistritoResponse>> listarDistritos(@PathVariable Long provinciaId) {
        return ResponseEntity.ok((Object)this.ubigeoAdminService.listarDistritosPorProvincia(provinciaId));
    }

    @GetMapping(value={"/distritos/{distritoId}/ruta"})
    public ResponseEntity<UbigeoRutaResponse> obtenerRutaPorDistrito(@PathVariable Long distritoId) {
        return ResponseEntity.ok((Object)this.ubigeoAdminService.obtenerRutaPorDistrito(distritoId));
    }

    @Generated
    public UbigeoAdminController(IUbigeoAdminService ubigeoAdminService) {
        this.ubigeoAdminService = ubigeoAdminService;
    }
}

