/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.service.impl;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.AsignarSedesRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioSedeResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioSede;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioSedeId;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioSedeRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IUsuarioSedeService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioSedeService
implements IUsuarioSedeService {
    private final UsuarioSedeRepository usuarioSedeRepository;
    private final UsuarioTiendaRepository usuarioTiendaRepository;

    @Transactional(readOnly=true)
    public List<UsuarioSedeResponse> obtenerSedesPorUsuario(Long tiendaId, Long usuarioId) {
        this.usuarioTiendaRepository.findByIdAndTiendaId(usuarioId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        return this.usuarioSedeRepository.findByIdUsuarioId(usuarioId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional
    public List<UsuarioSedeResponse> asignarSedes(Long tiendaId, Long usuarioId, AsignarSedesRequest request) {
        this.usuarioTiendaRepository.findByIdAndTiendaId(usuarioId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        if (request.getSedePrincipalId() != null && !request.getSedeIds().contains(request.getSedePrincipalId())) {
            throw new BadRequestException("La sede principal debe estar en la lista de sedes asignadas");
        }
        this.usuarioSedeRepository.deleteByIdUsuarioId(usuarioId);
        for (Long sedeId : request.getSedeIds()) {
            UsuarioSede usuarioSede = new UsuarioSede();
            UsuarioSedeId id = new UsuarioSedeId(usuarioId, sedeId);
            usuarioSede.setId(id);
            usuarioSede.setEsSedePrincipal(Boolean.valueOf(sedeId.equals(request.getSedePrincipalId())));
            this.usuarioSedeRepository.save((Object)usuarioSede);
        }
        return this.obtenerSedesPorUsuario(tiendaId, usuarioId);
    }

    @Transactional
    public void removerSede(Long tiendaId, Long usuarioId, Long sedeId) {
        this.usuarioTiendaRepository.findByIdAndTiendaId(usuarioId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        UsuarioSedeId id = new UsuarioSedeId(usuarioId, sedeId);
        this.usuarioSedeRepository.deleteById((Object)id);
    }

    private UsuarioSedeResponse toResponse(UsuarioSede usuarioSede) {
        return UsuarioSedeResponse.builder().usuarioId(usuarioSede.getId().getUsuarioId()).sedeId(usuarioSede.getId().getSedeId()).sedeNombre(null).esSedePrincipal(usuarioSede.getEsSedePrincipal()).build();
    }

    @Generated
    public UsuarioSedeService(UsuarioSedeRepository usuarioSedeRepository, UsuarioTiendaRepository usuarioTiendaRepository) {
        this.usuarioSedeRepository = usuarioSedeRepository;
        this.usuarioTiendaRepository = usuarioTiendaRepository;
    }
}

