/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.service.impl;

import com.dulcecontrol.bakery.features.admin.configuracion.repository.SedeAdminRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.PerfilUpdateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioCreateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioUpdateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.Rol;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioSede;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioSedeId;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioTienda;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.RolRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioSedeRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IUsuarioAdminService;
import com.dulcecontrol.bakery.features.shared.suscripciones.model.PlanLimites;
import com.dulcecontrol.bakery.features.shared.suscripciones.service.PlanLimitesService;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Sede;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioAdminService
implements IUsuarioAdminService {
    private final UsuarioTiendaRepository usuarioRepository;
    private final RolRepository rolRepository;
    private final UsuarioSedeRepository usuarioSedeRepository;
    private final SedeAdminRepository sedeAdminRepository;
    private final BCryptPasswordEncoder passwordEncoder;
    private final PlanLimitesService planLimitesService;

    @Transactional(readOnly=true)
    public List<UsuarioResponse> listarPorTienda(Long tiendaId) {
        List usuarios = this.usuarioRepository.findAllIncludingInactiveByTiendaId(tiendaId);
        Map roles = this.rolRepository.findByTiendaId(tiendaId).stream().collect(Collectors.toMap(Rol::getId, Function.identity()));
        Map asignaciones = this.obtenerAsignacionesPorUsuario(usuarios);
        Map sedes = this.cargarSedesPorAsignaciones(asignaciones);
        return usuarios.stream().map(usuario -> {
            Rol rol = (Rol)roles.get(usuario.getRolId());
            List usuarioSedes = asignaciones.getOrDefault(usuario.getId(), Collections.emptyList());
            return this.toResponse(usuario, rol, usuarioSedes, sedes);
        }).toList();
    }

    @Transactional(readOnly=true)
    public UsuarioResponse obtenerPorId(Long tiendaId, Long usuarioId) {
        UsuarioTienda usuario = (UsuarioTienda)this.usuarioRepository.findIncludingInactiveByIdAndTiendaId(usuarioId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        Rol rol = (Rol)this.rolRepository.findById((Object)usuario.getRolId()).orElseThrow(() -> new ResourceNotFoundException("Rol no encontrado"));
        List asignaciones = this.usuarioSedeRepository.findByIdUsuarioId(usuarioId);
        Map sedes = this.cargarSedesDetalle(tiendaId, asignaciones);
        return this.toResponse(usuario, rol, asignaciones, sedes);
    }

    @Transactional
    public UsuarioResponse crear(Long tiendaId, UsuarioCreateRequest request) {
        this.validarRolPerteneceATienda(request.getRolId(), tiendaId);
        this.validarDuplicadosAlCrear(tiendaId, request.getCorreo(), request.getNumeroDoc());
        this.validarLimiteUsuarios(tiendaId);
        List sedeIds = this.normalizarSedeIds(request.getSedeIds());
        if (sedeIds.isEmpty()) {
            throw new BadRequestException("Debes asignar al menos una sede");
        }
        List sedesSeleccionadas = this.validarSedesPertenecenATienda(tiendaId, sedeIds);
        Map sedesDetalle = sedesSeleccionadas.stream().collect(Collectors.toMap(Sede::getId, Function.identity()));
        UsuarioTienda usuario = new UsuarioTienda();
        usuario.setTiendaId(tiendaId);
        usuario.setRolId(request.getRolId());
        usuario.setCorreo(request.getCorreo().toLowerCase());
        usuario.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getContrasena()));
        usuario.setTipoDoc(request.getTipoDoc());
        usuario.setNumeroDoc(request.getNumeroDoc());
        usuario.setNombres(request.getNombres());
        usuario.setTelefono(request.getTelefono());
        usuario.setActivo(Boolean.TRUE);
        UsuarioTienda guardado = (UsuarioTienda)this.usuarioRepository.save((Object)usuario);
        List asignaciones = this.sincronizarSedesAsignadas(guardado.getId(), sedesSeleccionadas);
        Rol rol = (Rol)this.rolRepository.findById((Object)request.getRolId()).orElseThrow(() -> new ResourceNotFoundException("Rol no encontrado tras crear"));
        return this.toResponse(guardado, rol, asignaciones, sedesDetalle);
    }

    private void validarLimiteUsuarios(Long tiendaId) {
        PlanLimites limites = this.planLimitesService.obtenerLimitesVigentes(tiendaId);
        if (!limites.tieneLimiteUsuarios()) {
            return;
        }
        long usuariosActivos = this.usuarioRepository.countByTiendaId(tiendaId);
        if (usuariosActivos >= (long)limites.getMaxUsuarios().intValue()) {
            throw new BadRequestException(String.format("Tu plan permite hasta %d usuarios activos. Actualiza tu suscripci\u00f3n para habilitar m\u00e1s accesos.", limites.getMaxUsuarios()));
        }
    }

    @Transactional
    public UsuarioResponse actualizar(Long tiendaId, Long usuarioId, UsuarioUpdateRequest request) {
        UsuarioTienda usuario = (UsuarioTienda)this.usuarioRepository.findIncludingInactiveByIdAndTiendaId(usuarioId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        this.validarRolPerteneceATienda(request.getRolId(), tiendaId);
        List sedeIds = this.normalizarSedeIds(request.getSedeIds());
        if (sedeIds.isEmpty()) {
            throw new BadRequestException("Debes asignar al menos una sede");
        }
        List sedesSeleccionadas = this.validarSedesPertenecenATienda(tiendaId, sedeIds);
        Map sedesDetalle = sedesSeleccionadas.stream().collect(Collectors.toMap(Sede::getId, Function.identity()));
        String correoNormalizado = request.getCorreo().toLowerCase();
        if (!usuario.getCorreo().equalsIgnoreCase(request.getCorreo()) && this.usuarioRepository.existsByTiendaIdAndCorreoAndIdNot(tiendaId, correoNormalizado, usuarioId)) {
            throw new BadRequestException("El correo ya est\u00e1 registrado para esta tienda");
        }
        if (!usuario.getNumeroDoc().equals(request.getNumeroDoc()) && this.usuarioRepository.existsByTiendaIdAndNumeroDocAndIdNot(tiendaId, request.getNumeroDoc(), usuarioId)) {
            throw new BadRequestException("El documento ya est\u00e1 registrado para esta tienda");
        }
        usuario.setRolId(request.getRolId());
        usuario.setCorreo(correoNormalizado);
        usuario.setTipoDoc(request.getTipoDoc());
        usuario.setNumeroDoc(request.getNumeroDoc());
        usuario.setNombres(request.getNombres());
        usuario.setTelefono(request.getTelefono());
        if (request.getActivo() != null) {
            usuario.setActivo(request.getActivo());
        }
        if (request.getNuevaContrasena() != null && !request.getNuevaContrasena().isBlank()) {
            usuario.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getNuevaContrasena()));
        }
        UsuarioTienda actualizado = (UsuarioTienda)this.usuarioRepository.save((Object)usuario);
        List asignaciones = this.sincronizarSedesAsignadas(actualizado.getId(), sedesSeleccionadas);
        Rol rol = (Rol)this.rolRepository.findById((Object)request.getRolId()).orElseThrow(() -> new ResourceNotFoundException("Rol no encontrado tras actualizar"));
        return this.toResponse(actualizado, rol, asignaciones, sedesDetalle);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long usuarioId) {
        UsuarioTienda usuario = (UsuarioTienda)this.usuarioRepository.findIncludingInactiveByIdAndTiendaId(usuarioId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        this.usuarioRepository.delete((Object)usuario);
        this.usuarioSedeRepository.deleteByIdUsuarioId(usuarioId);
    }

    private void validarRolPerteneceATienda(Long rolId, Long tiendaId) {
        this.rolRepository.findByIdAndTiendaId(rolId, tiendaId).orElseThrow(() -> new BadRequestException("El rol no pertenece a la tienda"));
    }

    private void validarDuplicadosAlCrear(Long tiendaId, String correo, String numeroDoc) {
        String correoNormalizado;
        String string = correoNormalizado = correo != null ? correo.toLowerCase() : null;
        if (correoNormalizado != null && this.usuarioRepository.existsByTiendaIdAndCorreo(tiendaId, correoNormalizado)) {
            throw new BadRequestException("El correo ya est\u00e1 registrado para esta tienda");
        }
        if (this.usuarioRepository.existsByTiendaIdAndNumeroDoc(tiendaId, numeroDoc)) {
            throw new BadRequestException("El documento ya est\u00e1 registrado para esta tienda");
        }
    }

    private UsuarioResponse toResponse(UsuarioTienda usuario, Rol rol, List<UsuarioSede> asignaciones, Map<Long, Sede> sedesDetalle) {
        List ordenadas = this.ordenarAsignaciones(asignaciones);
        List<Long> sedeIds = ordenadas.stream().map(asignacion -> asignacion.getId().getSedeId()).toList();
        List<String> sedeNombres = sedeIds.stream().map(sedeId -> Optional.ofNullable((Sede)sedesDetalle.get(sedeId)).map(Sede::getNombre).orElse(null)).toList();
        Long sedePrincipalId = ordenadas.stream().filter(asignacion -> Boolean.TRUE.equals(asignacion.getEsSedePrincipal())).map(asignacion -> asignacion.getId().getSedeId()).findFirst().orElseGet(() -> sedeIds.isEmpty() ? null : (Long)sedeIds.get(0));
        String sedePrincipalNombre = sedePrincipalId != null ? (String)Optional.ofNullable(sedesDetalle.get(sedePrincipalId)).map(Sede::getNombre).orElse(null) : null;
        return UsuarioResponse.builder().id(usuario.getId()).tiendaId(usuario.getTiendaId()).rolId(usuario.getRolId()).rolNombre(rol != null ? rol.getNombre() : null).sedeId(sedePrincipalId).sedeNombre(sedePrincipalNombre).sedeIds(sedeIds).sedes(sedeNombres).correo(usuario.getCorreo()).tipoDoc(usuario.getTipoDoc()).numeroDoc(usuario.getNumeroDoc()).nombres(usuario.getNombres()).telefono(usuario.getTelefono()).activo(usuario.getActivo()).ultimoAccesoEn(usuario.getUltimoAccesoEn()).creadoEn(usuario.getCreadoEn()).build();
    }

    private Map<Long, List<UsuarioSede>> obtenerAsignacionesPorUsuario(List<UsuarioTienda> usuarios) {
        if (usuarios.isEmpty()) {
            return Map.of();
        }
        List<Long> usuarioIds = usuarios.stream().map(UsuarioTienda::getId).toList();
        List asignaciones = this.usuarioSedeRepository.findByIdUsuarioIdIn(usuarioIds);
        return asignaciones.stream().collect(Collectors.groupingBy(asignacion -> asignacion.getId().getUsuarioId()));
    }

    private Map<Long, Sede> cargarSedesPorAsignaciones(Map<Long, List<UsuarioSede>> asignaciones) {
        if (asignaciones.isEmpty()) {
            return Map.of();
        }
        Set sedeIds = asignaciones.values().stream().filter(Objects::nonNull).flatMap(lista -> lista.stream().map(asignacion -> asignacion.getId().getSedeId())).collect(Collectors.toSet());
        if (sedeIds.isEmpty()) {
            return Map.of();
        }
        return this.sedeAdminRepository.findAllById(sedeIds).stream().collect(Collectors.toMap(Sede::getId, Function.identity()));
    }

    private Map<Long, Sede> cargarSedesDetalle(Long tiendaId, List<UsuarioSede> asignaciones) {
        if (asignaciones == null || asignaciones.isEmpty()) {
            return Map.of();
        }
        Set sedeIds = asignaciones.stream().map(asignacion -> asignacion.getId().getSedeId()).collect(Collectors.toSet());
        if (sedeIds.isEmpty()) {
            return Map.of();
        }
        return this.sedeAdminRepository.findAllById(sedeIds).stream().filter(sede -> sede != null && sede.getTienda() != null && Objects.equals(sede.getTienda().getId(), tiendaId)).collect(Collectors.toMap(Sede::getId, Function.identity()));
    }

    private List<Long> normalizarSedeIds(List<Long> sedeIds) {
        if (sedeIds == null || sedeIds.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet unique = sedeIds.stream().filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
        return new ArrayList<Long>(unique);
    }

    private List<Sede> validarSedesPertenecenATienda(Long tiendaId, List<Long> sedeIds) {
        if (sedeIds.isEmpty()) {
            return Collections.emptyList();
        }
        List sedes = this.sedeAdminRepository.findAllById(sedeIds);
        Map sedesPorId = sedes.stream().collect(Collectors.toMap(Sede::getId, Function.identity()));
        for (Long sedeId : sedeIds) {
            Sede sede = (Sede)sedesPorId.get(sedeId);
            if (sede != null && sede.getTienda() != null && Objects.equals(sede.getTienda().getId(), tiendaId)) continue;
            throw new BadRequestException("La sede seleccionada no pertenece a la tienda");
        }
        return sedeIds.stream().map(sedesPorId::get).collect(Collectors.toList());
    }

    private List<UsuarioSede> sincronizarSedesAsignadas(Long usuarioId, List<Sede> sedesSeleccionadas) {
        this.usuarioSedeRepository.deleteByIdUsuarioId(usuarioId);
        if (sedesSeleccionadas == null || sedesSeleccionadas.isEmpty()) {
            return Collections.emptyList();
        }
        Long sedePrincipalId = sedesSeleccionadas.get(0).getId();
        ArrayList<UsuarioSede> resultado = new ArrayList<UsuarioSede>();
        for (Sede sede : sedesSeleccionadas) {
            UsuarioSede usuarioSede = new UsuarioSede();
            usuarioSede.setId(new UsuarioSedeId(usuarioId, sede.getId()));
            usuarioSede.setEsSedePrincipal(Boolean.valueOf(Objects.equals(sede.getId(), sedePrincipalId)));
            resultado.add((UsuarioSede)this.usuarioSedeRepository.save((Object)usuarioSede));
        }
        return resultado;
    }

    private List<UsuarioSede> ordenarAsignaciones(List<UsuarioSede> asignaciones) {
        if (asignaciones == null || asignaciones.isEmpty()) {
            return Collections.emptyList();
        }
        return asignaciones.stream().sorted(Comparator.comparing(asignacion -> Boolean.TRUE.equals(asignacion.getEsSedePrincipal()) ? 0 : 1).thenComparing(asignacion -> asignacion.getId().getSedeId())).toList();
    }

    @Transactional(readOnly=true)
    public UsuarioResponse obtenerMiPerfil(Long usuarioId) {
        UsuarioTienda usuario = (UsuarioTienda)this.usuarioRepository.findById((Object)usuarioId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        Rol rol = (Rol)this.rolRepository.findById((Object)usuario.getRolId()).orElseThrow(() -> new ResourceNotFoundException("Rol no encontrado"));
        List asignaciones = this.usuarioSedeRepository.findByIdUsuarioId(usuarioId);
        Map sedes = this.cargarSedesDetalle(usuario.getTiendaId(), asignaciones);
        return this.toResponse(usuario, rol, asignaciones, sedes);
    }

    @Transactional
    public UsuarioResponse actualizarMiPerfil(Long usuarioId, PerfilUpdateRequest request) {
        UsuarioTienda usuario = (UsuarioTienda)this.usuarioRepository.findById((Object)usuarioId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        if (request.getCorreo() != null && !request.getCorreo().isBlank()) {
            String correoNormalizado = request.getCorreo().toLowerCase();
            if (!usuario.getCorreo().equalsIgnoreCase(request.getCorreo()) && this.usuarioRepository.existsByTiendaIdAndCorreoAndIdNot(usuario.getTiendaId(), correoNormalizado, usuarioId)) {
                throw new BadRequestException("El correo ya est\u00e1 registrado");
            }
            usuario.setCorreo(correoNormalizado);
        }
        if (request.getNombres() != null && !request.getNombres().isBlank()) {
            usuario.setNombres(request.getNombres());
        }
        if (request.getTelefono() != null && !request.getTelefono().isBlank()) {
            usuario.setTelefono(request.getTelefono());
        }
        if (request.getNuevaContrasena() != null && !request.getNuevaContrasena().isBlank()) {
            if (request.getContrasenaActual() == null || request.getContrasenaActual().isBlank()) {
                throw new BadRequestException("Debes proporcionar tu contrase\u00f1a actual para cambiarla");
            }
            if (!this.passwordEncoder.matches((CharSequence)request.getContrasenaActual(), usuario.getHashContrasena())) {
                throw new BadRequestException("La contrase\u00f1a actual es incorrecta");
            }
            usuario.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getNuevaContrasena()));
        }
        UsuarioTienda guardado = (UsuarioTienda)this.usuarioRepository.save((Object)usuario);
        Rol rol = (Rol)this.rolRepository.findById((Object)guardado.getRolId()).orElseThrow(() -> new ResourceNotFoundException("Rol no encontrado"));
        List asignaciones = this.usuarioSedeRepository.findByIdUsuarioId(usuarioId);
        Map sedes = this.cargarSedesDetalle(guardado.getTiendaId(), asignaciones);
        return this.toResponse(guardado, rol, asignaciones, sedes);
    }

    @Generated
    public UsuarioAdminService(UsuarioTiendaRepository usuarioRepository, RolRepository rolRepository, UsuarioSedeRepository usuarioSedeRepository, SedeAdminRepository sedeAdminRepository, BCryptPasswordEncoder passwordEncoder, PlanLimitesService planLimitesService) {
        this.usuarioRepository = usuarioRepository;
        this.rolRepository = rolRepository;
        this.usuarioSedeRepository = usuarioSedeRepository;
        this.sedeAdminRepository = sedeAdminRepository;
        this.passwordEncoder = passwordEncoder;
        this.planLimitesService = planLimitesService;
    }
}

