/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.service.impl;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.RolCreateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.RolResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.RolUpdateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.Rol;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.PermisoRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.RolPermisoRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.RolRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IRolAdminService;
import com.dulcecontrol.bakery.features.admin.seguridad.service.RolSistemaBootstrapService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RolAdminService
implements IRolAdminService {
    private final RolRepository rolRepository;
    private final PermisoRepository permisoRepository;
    private final RolPermisoRepository rolPermisoRepository;
    private final UsuarioTiendaRepository usuarioTiendaRepository;
    private final RolSistemaBootstrapService rolSistemaBootstrapService;

    @Transactional
    public List<RolResponse> listarPorTienda(Long tiendaId) {
        this.rolSistemaBootstrapService.ensureDefaultRoles(tiendaId);
        return this.rolRepository.findByTiendaId(tiendaId).stream().map(rol -> this.toResponse(rol, new HashSet(this.rolPermisoRepository.findPermisoIdsByRolId(rol.getId())))).toList();
    }

    @Transactional(readOnly=true)
    public RolResponse obtenerPorId(Long tiendaId, Long rolId) {
        Rol rol = (Rol)this.rolRepository.findByIdAndTiendaId(rolId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Rol no encontrado"));
        HashSet permisos = new HashSet(this.rolPermisoRepository.findPermisoIdsByRolId(rol.getId()));
        return this.toResponse(rol, permisos);
    }

    @Transactional
    public RolResponse crear(Long tiendaId, RolCreateRequest request) {
        if (this.rolRepository.existsByTiendaIdAndNombre(tiendaId, request.getNombre())) {
            throw new BadRequestException("Ya existe un rol con ese nombre");
        }
        Rol rol = new Rol();
        rol.setTiendaId(tiendaId);
        rol.setNombre(request.getNombre());
        rol.setDescripcion(request.getDescripcion());
        rol.setEsSistema(Boolean.FALSE);
        Rol guardado = (Rol)this.rolRepository.save((Object)rol);
        Set permisos = this.normalizarPermisos(request.getPermisos());
        this.actualizarPermisos(guardado.getId(), permisos);
        return this.toResponse(guardado, permisos);
    }

    @Transactional
    public RolResponse actualizar(Long tiendaId, Long rolId, RolUpdateRequest request) {
        Rol rol = (Rol)this.rolRepository.findByIdAndTiendaId(rolId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Rol no encontrado"));
        if (!rol.getNombre().equalsIgnoreCase(request.getNombre()) && this.rolRepository.existsByTiendaIdAndNombreAndIdNot(tiendaId, request.getNombre(), rolId)) {
            throw new BadRequestException("Ya existe un rol con ese nombre");
        }
        if (Boolean.TRUE.equals(rol.getEsSistema()) && request.getEsSistema() != null && !request.getEsSistema().booleanValue()) {
            throw new BadRequestException("No es posible cambiar la bandera de rol del sistema");
        }
        rol.setNombre(request.getNombre());
        rol.setDescripcion(request.getDescripcion());
        if (request.getEsSistema() != null) {
            rol.setEsSistema(request.getEsSistema());
        }
        Rol actualizado = (Rol)this.rolRepository.save((Object)rol);
        if (request.getPermisos() != null) {
            Set permisos = this.normalizarPermisos(request.getPermisos());
            this.actualizarPermisos(actualizado.getId(), permisos);
        }
        return this.toResponse(actualizado, new HashSet(this.rolPermisoRepository.findPermisoIdsByRolId(actualizado.getId())));
    }

    @Transactional
    public void eliminar(Long tiendaId, Long rolId) {
        Rol rol = (Rol)this.rolRepository.findByIdAndTiendaId(rolId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Rol no encontrado"));
        if (Boolean.TRUE.equals(rol.getEsSistema())) {
            throw new BadRequestException("No se puede eliminar un rol del sistema");
        }
        if (this.usuarioTiendaRepository.existsByTiendaIdAndRolId(tiendaId, rolId)) {
            throw new BadRequestException("No se puede eliminar un rol asignado a usuarios activos");
        }
        this.rolPermisoRepository.deleteByRolId(rol.getId());
        this.rolRepository.delete((Object)rol);
    }

    private Set<Long> normalizarPermisos(Set<Long> permisos) {
        if (permisos == null || permisos.isEmpty()) {
            return Set.of();
        }
        HashSet<Long> existentes = new HashSet<Long>(permisos);
        List encontrados = this.permisoRepository.findAllById(existentes);
        if (encontrados.size() != existentes.size()) {
            throw new BadRequestException("Uno o m\u00e1s permisos no existen");
        }
        return existentes;
    }

    private void actualizarPermisos(Long rolId, Set<Long> permisos) {
        this.rolPermisoRepository.deleteByRolId(rolId);
        permisos.forEach(permisoId -> this.rolPermisoRepository.insertarRelacion(rolId, permisoId));
    }

    private RolResponse toResponse(Rol rol, Set<Long> permisos) {
        return RolResponse.builder().id(rol.getId()).tiendaId(rol.getTiendaId()).nombre(rol.getNombre()).descripcion(rol.getDescripcion()).esSistema(rol.getEsSistema()).permisos(permisos).build();
    }

    @Generated
    public RolAdminService(RolRepository rolRepository, PermisoRepository permisoRepository, RolPermisoRepository rolPermisoRepository, UsuarioTiendaRepository usuarioTiendaRepository, RolSistemaBootstrapService rolSistemaBootstrapService) {
        this.rolRepository = rolRepository;
        this.permisoRepository = permisoRepository;
        this.rolPermisoRepository = rolPermisoRepository;
        this.usuarioTiendaRepository = usuarioTiendaRepository;
        this.rolSistemaBootstrapService = rolSistemaBootstrapService;
    }
}

