/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.service;

import com.dulcecontrol.bakery.features.admin.seguridad.entity.Rol;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.PermisoRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.RolPermisoRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.RolRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.service.RolSistemaBootstrapService;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RolSistemaBootstrapService {
    private final RolRepository rolRepository;
    private final PermisoRepository permisoRepository;
    private final RolPermisoRepository rolPermisoRepository;
    private static final List<RoleTemplate> DEFAULT_ROLE_TEMPLATES = List.of(RoleTemplate.allAccess((String)"Administrador", (String)"Acceso total al sistema"), RoleTemplate.includeAllExcept((String)"Gerente", (String)"Gesti\u00f3n de operaciones y reportes", List.of("config.%", "usuarios.%")), RoleTemplate.includeOnly((String)"Vendedor", (String)"Registro de ventas y atenci\u00f3n al cliente", List.of("dashboard.view", "clientes.%", "productos.view", "ventas.%", "pedidos.%", "caja.%")), RoleTemplate.includeOnly((String)"Maestro Panadero", (String)"Gesti\u00f3n de producci\u00f3n y recetas", List.of("dashboard.view", "productos.view", "produccion.%", "recetas.%", "inventario.view", "reportes.produccion")), RoleTemplate.includeOnly((String)"Almacenero", (String)"Gesti\u00f3n de inventario y compras", List.of("dashboard.view", "insumos.%", "compras.%", "proveedores.%", "inventario.%", "reportes.inventario")));

    @Transactional
    public void ensureDefaultRoles(Long tiendaId) {
        if (tiendaId == null) {
            return;
        }
        Map existentes = this.rolRepository.findByTiendaId(tiendaId).stream().collect(Collectors.toMap(rol -> RolSistemaBootstrapService.normalizeKey((String)rol.getNombre()), Function.identity(), (current, duplicate) -> current));
        boolean todasPlantillasCreadas = DEFAULT_ROLE_TEMPLATES.stream().allMatch(template -> existentes.containsKey(template.key()));
        if (todasPlantillasCreadas) {
            return;
        }
        List<PermisoSnapshot> permisos = this.permisoRepository.findAll().stream().map(permiso -> new PermisoSnapshot(permiso.getId(), permiso.getSlug())).toList();
        for (RoleTemplate template2 : DEFAULT_ROLE_TEMPLATES) {
            if (existentes.containsKey(template2.key())) continue;
            Rol nuevoRol = new Rol();
            nuevoRol.setTiendaId(tiendaId);
            nuevoRol.setNombre(template2.nombre());
            nuevoRol.setDescripcion(template2.descripcion());
            nuevoRol.setEsSistema(Boolean.valueOf(template2.esSistema()));
            Rol guardado = (Rol)this.rolRepository.save((Object)nuevoRol);
            Set permisosAsignados = template2.resolvePermisos(permisos);
            permisosAsignados.forEach(permisoId -> this.rolPermisoRepository.insertarRelacion(guardado.getId(), permisoId));
        }
    }

    private static String normalizeKey(String value) {
        return Optional.ofNullable(value).map(nombre -> nombre.trim().toLowerCase(Locale.ROOT)).orElse("");
    }

    private static boolean matchesAny(String slug, List<String> patterns) {
        if (slug == null || patterns == null || patterns.isEmpty()) {
            return false;
        }
        for (String pattern : patterns) {
            if (!RolSistemaBootstrapService.matchesPattern((String)slug, (String)pattern)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesPattern(String rawSlug, String rawPattern) {
        if (rawSlug == null || rawPattern == null) {
            return false;
        }
        String slug = rawSlug.trim().toLowerCase(Locale.ROOT);
        String pattern = rawPattern.trim().toLowerCase(Locale.ROOT);
        if (pattern.isEmpty()) {
            return false;
        }
        int wildcardIndex = pattern.indexOf(37);
        if (wildcardIndex >= 0) {
            String prefix = pattern.substring(0, wildcardIndex);
            return slug.startsWith(prefix);
        }
        return slug.equals(pattern);
    }

    @Generated
    public RolSistemaBootstrapService(RolRepository rolRepository, PermisoRepository permisoRepository, RolPermisoRepository rolPermisoRepository) {
        this.rolRepository = rolRepository;
        this.permisoRepository = permisoRepository;
        this.rolPermisoRepository = rolPermisoRepository;
    }
}

